/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import projections.analysis.AmpiFunctionData;
import projections.analysis.ObjectId;
import projections.misc.LogEntryData;

class LogEntry {
    public int TransactionType;
    public int MsgType;
    public int Entry;
    long Time;
    int EventID;
    int Pe;
    int MsgLen;
    ObjectId id;
    long recvTime;
    long sendTime;
    int numPEs;
    int[] destPEs;
    long cpuBegin;
    long cpuEnd;
    int numPapiCounts;
    long[] papiCounts;
    Integer userSupplied;
    Integer memoryUsage;
    int FunctionID;
    AmpiFunctionData ampiData;
    String note;

    public void setAmpiData(int functionID, int lineNo, String sourceFileName) {
        this.ampiData = new AmpiFunctionData();
        this.ampiData.FunctionID = functionID;
        this.ampiData.LineNo = lineNo;
        this.ampiData.sourceFileName = sourceFileName;
    }

    public LogEntry(LogEntryData data) {
        int i;
        this.TransactionType = data.type;
        this.MsgType = data.mtype;
        this.Time = data.time;
        this.Entry = data.entry;
        this.EventID = data.event;
        this.Pe = data.pe;
        this.MsgLen = data.msglen;
        this.sendTime = data.sendTime;
        this.recvTime = data.recvTime;
        this.id = new ObjectId(data.id[0], data.id[1], data.id[2], data.id[3]);
        this.userSupplied = data.userSupplied;
        this.memoryUsage = data.memoryUsage;
        this.note = data.note;
        this.numPEs = data.numPEs;
        if (data.destPEs != null) {
            this.destPEs = new int[data.destPEs.length];
            for (i = 0; i < this.destPEs.length; ++i) {
                this.destPEs[i] = data.destPEs[i];
            }
        }
        this.cpuBegin = data.cpuStartTime;
        this.cpuEnd = data.cpuEndTime;
        this.numPapiCounts = data.numPerfCounts;
        this.papiCounts = new long[this.numPapiCounts];
        for (i = 0; i < this.numPapiCounts; ++i) {
            this.papiCounts[i] = data.perfCounts[i];
        }
        this.FunctionID = data.entry;
        if (data.funcName != null) {
            this.setAmpiData(data.entry, data.lineNo, new String(data.funcName));
        }
    }

    public Integer userSuppliedValue() {
        return this.userSupplied;
    }

    public Integer memoryUsage() {
        return this.memoryUsage;
    }
}

