/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import projections.analysis.NoiseMiner;
import projections.analysis.TimelineEvent;
import projections.gui.Timeline.NonScrollingPanel;

public class NoiseMinerExemplarTimelineWindow
extends JFrame {
    JLabel explanation;

    public NoiseMinerExemplarTimelineWindow(NoiseMiner.NoiseResult nr) {
        int numCols;
        int numRows;
        JPanel wrapper = new JPanel();
        wrapper.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 0));
        wrapper.setLayout(new BorderLayout());
        wrapper.setBackground(Color.white);
        JPanel contents = new JPanel();
        contents.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        contents.setBackground(Color.white);
        NoiseMiner.EventWindow ew = nr.ew;
        int numEventsInWindow = ew.size();
        int maxTimelinesPerWindow = 36;
        int numMiniTimelines = Math.min(numEventsInWindow, maxTimelinesPerWindow);
        if (numMiniTimelines < 6) {
            numRows = numMiniTimelines;
            numCols = 1;
        } else {
            numCols = 4;
            numRows = (numMiniTimelines + numCols - 1) / numCols;
        }
        contents.setLayout(new GridLayout(numRows, numCols));
        int eventsSoFar = 0;
        for (TimelineEvent e : ew.occurrences) {
            if (eventsSoFar >= numMiniTimelines) break;
            long eDuration = e.EndTime - e.BeginTime;
            double padding = 0.7;
            long startTime = e.BeginTime - (long)((double)eDuration * padding);
            long endTime = e.EndTime + (long)((double)eDuration * padding);
            int PE = e.SrcPe;
            NonScrollingPanel tfp = new NonScrollingPanel(startTime, endTime, PE, Color.white, Color.black, true);
            contents.add(tfp);
            ++eventsSoFar;
        }
        this.explanation = new JLabel("<html><body bgcolor=white>Below are " + numMiniTimelines + "(out of " + nr.occurrences + ") mini-timelines that show a selected set of exemplar regions where extraordinarily long events occurred. In the center of each is the stretched event. Each stretched event was approximately " + nr.duration + " longer than other entry methods of the same type(but not necessarily on the same object). Each timeline does not have the same scale, so direct comparisons are meaningless.</body></html>");
        this.explanation.setFont(new Font("Serif", 0, 16));
        this.explanation.setBackground(Color.white);
        this.explanation.setForeground(Color.black);
        wrapper.add((Component)contents, "Center");
        wrapper.add((Component)this.explanation, "North");
        super.setContentPane(wrapper);
        super.pack();
        super.setTitle("NoiseMiner Exemplars");
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(null);
    }
}

