/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import javax.swing.JTextField;

public class JLongTextField
extends JTextField {
    private String lastValue;
    int lastCaretPosition;

    public JLongTextField(long defval, int size) {
        super("" + defval, size);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                if (!('0' <= ch && ch <= '9' || Character.isISOControl(ch))) {
                    evt.consume();
                } else {
                    JLongTextField.this.lastCaretPosition = JLongTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + defval;
    }

    private void checkValue() {
        try {
            Long.parseLong(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException e) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public long getValue() {
        this.checkValue();
        try {
            return Long.parseLong(this.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void setValue(long num) {
        this.lastValue = this.getText();
        this.setText(String.valueOf(num));
        this.checkValue();
    }

    public void textValueChanged(TextEvent evt) {
        this.checkValue();
    }
}

