/*
 * Decompiled with CFR 0.152.
 */
package charm.util;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ReflectiveXML {
    static final String INDENTATION = "  ";

    public static Object read(FileReader f) throws IOException, SAXException {
        XMLReader reader = null;
        reader = XMLReaderFactory.createXMLReader();
        Handler handler = new Handler();
        reader.setContentHandler(handler);
        InputSource source = new InputSource(f);
        reader.parse(source);
        return handler.getParsedObject();
    }

    public static void write(FileWriter f, Object o) throws IOException {
        f.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        ReflectiveXML.write(f, o, o.getClass(), null, -1, "");
    }

    private static void write(FileWriter f, Object o, Class cls, String name, int arrPos, String prefix) throws IOException {
        Class<?> realcls = cls;
        if (o != null) {
            realcls = o.getClass();
        }
        try {
            if (cls.isArray()) {
                f.write(prefix + "<array type=\"" + cls.getComponentType().getName() + "\" name=\"" + name + "\" size=\"" + Array.getLength(o) + "\"");
                if (arrPos >= 0) {
                    f.write(" position=\"" + arrPos + "\"");
                }
                f.write(">\n");
                for (int j = 0; j < Array.getLength(o); ++j) {
                    Object elem = Array.get(o, j);
                    if (elem == null) continue;
                    ReflectiveXML.write(f, elem, cls.getComponentType(), null, j, prefix + INDENTATION);
                }
                f.write(prefix + "</array>\n");
            } else if (cls.isPrimitive()) {
                f.write(prefix + "<" + cls.getName());
                if (name != null) {
                    f.write(" name=\"" + name + "\"");
                }
                f.write(" value=\"" + o + "\"");
                if (arrPos >= 0) {
                    f.write(" position=\"" + arrPos + "\"");
                }
                f.write(" />\n");
            } else if (realcls.equals(Class.forName("java.lang.String"))) {
                f.write(prefix + "<" + realcls.getName());
                if (name != null) {
                    f.write(" name=\"" + name + "\"");
                }
                if (o != null) {
                    f.write(" value=\"" + ((String)o).replace("\"", "#$%").replace("\n", "#%$").replace("\t", "$#%") + "\"");
                }
                if (arrPos >= 0) {
                    f.write(" position=\"" + arrPos + "\"");
                }
                f.write(" />\n");
            } else {
                f.write(prefix + "<class");
                if (o != null) {
                    f.write(" type=\"" + realcls.getName() + "\"");
                }
                if (name != null) {
                    f.write(" name=\"" + name + "\"");
                }
                if (arrPos >= 0) {
                    f.write(" position=\"" + arrPos + "\"");
                }
                if (o != null) {
                    f.write(">\n");
                    AccessibleObject[] fieldlist = realcls.getDeclaredFields();
                    AccessibleObject.setAccessible(fieldlist, true);
                    for (int i = 0; i < fieldlist.length; ++i) {
                        AccessibleObject fld = fieldlist[i];
                        if (Modifier.isFinal(((Field)fld).getModifiers())) continue;
                        Object sub = ((Field)fld).get(o);
                        ReflectiveXML.write(f, sub, ((Field)fld).getType(), ((Field)fld).getName(), -1, prefix + INDENTATION);
                    }
                    f.write(prefix + "</class>\n");
                } else {
                    f.write(" />\n");
                }
            }
        }
        catch (IllegalAccessException e) {
            System.err.println(e);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
        }
    }

    private static class Handler
    extends DefaultHandler {
        Stack recursion = new Stack();
        Object object = null;

        Handler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attrs) throws SAXException {
            block70: {
                System.out.println("start " + localName);
                String fieldName = attrs.getValue("name");
                String arrPos = attrs.getValue("position");
                try {
                    if (localName.equals("class")) {
                        String type = attrs.getValue("type");
                        Field fld = null;
                        Object container = null;
                        Object o = null;
                        if ((fieldName != null || arrPos != null) && (container = (Object)this.recursion.peek()) != null && fieldName != null) {
                            fld = container.getClass().getDeclaredField(fieldName);
                            fld.setAccessible(true);
                        }
                        if (type != null) {
                            try {
                                Class<?> classtype = Class.forName(type);
                                o = classtype.newInstance();
                                AccessibleObject[] fieldlist = classtype.getDeclaredFields();
                                AccessibleObject.setAccessible(fieldlist, true);
                                for (int i = 0; i < fieldlist.length; ++i) {
                                    AccessibleObject fld1 = fieldlist[i];
                                    if (Modifier.isFinal(((Field)fld1).getModifiers())) continue;
                                    if (((Field)fld1).getType().isPrimitive()) {
                                        if (((Field)fld1).getType().getName().equals("boolean")) {
                                            ((Field)fld1).set(o, new Boolean(false));
                                            continue;
                                        }
                                        ((Field)fld1).set(o, new Integer(0));
                                        continue;
                                    }
                                    ((Field)fld1).set(o, null);
                                }
                            }
                            catch (ClassNotFoundException e) {
                                System.err.println(e);
                            }
                            catch (InstantiationException e) {
                                System.err.println(e);
                            }
                        }
                        if (fld != null) {
                            fld.set(container, o);
                        }
                        if (arrPos != null) {
                            Array.set(container, Integer.parseInt(arrPos), o);
                        }
                        this.recursion.push(o);
                        break block70;
                    }
                    if (localName.equals("array")) {
                        String type = attrs.getValue("type");
                        int length = Integer.parseInt(attrs.getValue("size"));
                        Object[] array = null;
                        if (length > 0) {
                            Object container;
                            try {
                                array = (Object[])Array.newInstance(Class.forName(type), length);
                            }
                            catch (ClassNotFoundException e) {
                                System.err.println(e);
                            }
                            if ((fieldName != null || arrPos != null) && (container = this.recursion.peek()) != null) {
                                if (fieldName != null) {
                                    Field fld = container.getClass().getDeclaredField(fieldName);
                                    fld.setAccessible(true);
                                    fld.set(container, array);
                                } else if (arrPos != null) {
                                    Array.set(container, Integer.parseInt(arrPos), array);
                                }
                            }
                        }
                        this.recursion.push(array);
                        break block70;
                    }
                    Object container = this.recursion.peek();
                    if (container != null) {
                        Field fld = null;
                        if (fieldName != null) {
                            fld = container.getClass().getDeclaredField(fieldName);
                            fld.setAccessible(true);
                        }
                        if (localName.equals("int")) {
                            if (fieldName != null) {
                                fld.setInt(container, Integer.parseInt(attrs.getValue("value")));
                            } else if (arrPos != null) {
                                Array.setInt(container, Integer.parseInt(arrPos), Integer.parseInt(attrs.getValue("value")));
                            }
                        } else if (localName.equals("long")) {
                            if (fieldName != null) {
                                fld.setLong(container, Long.parseLong(attrs.getValue("value")));
                            } else if (arrPos != null) {
                                Array.setLong(container, Integer.parseInt(arrPos), Long.parseLong(attrs.getValue("value")));
                            }
                        } else if (localName.equals("float")) {
                            if (fieldName != null) {
                                fld.setFloat(container, Float.parseFloat(attrs.getValue("value")));
                            } else if (arrPos != null) {
                                Array.setFloat(container, Integer.parseInt(arrPos), Float.parseFloat(attrs.getValue("value")));
                            }
                        } else if (localName.equals("double")) {
                            if (fieldName != null) {
                                fld.setDouble(container, Double.parseDouble(attrs.getValue("value")));
                            } else if (arrPos != null) {
                                Array.setDouble(container, Integer.parseInt(arrPos), Double.parseDouble(attrs.getValue("value")));
                            }
                        } else if (localName.equals("boolean")) {
                            if (fieldName != null) {
                                fld.setBoolean(container, Boolean.getBoolean(attrs.getValue("value")));
                            } else if (arrPos != null) {
                                Array.setBoolean(container, Integer.parseInt(arrPos), Boolean.getBoolean(attrs.getValue("value")));
                            }
                        } else if (localName.equals("byte")) {
                            if (fieldName != null) {
                                fld.setByte(container, Byte.parseByte(attrs.getValue("value")));
                            } else if (arrPos != null) {
                                Array.setByte(container, Integer.parseInt(arrPos), Byte.parseByte(attrs.getValue("value")));
                            }
                        } else if (localName.equals("char")) {
                            if (fieldName != null) {
                                fld.setChar(container, attrs.getValue("value").charAt(0));
                            } else if (arrPos != null) {
                                Array.setChar(container, Integer.parseInt(arrPos), attrs.getValue("value").charAt(0));
                            }
                        } else if (localName.equals("short")) {
                            if (fieldName != null) {
                                fld.setShort(container, Short.parseShort(attrs.getValue("value")));
                            } else if (arrPos != null) {
                                Array.setShort(container, Integer.parseInt(arrPos), Short.parseShort(attrs.getValue("value")));
                            }
                        } else if (localName.equals("java.lang.String")) {
                            String str = attrs.getValue("value");
                            if (str != null) {
                                str = str.replace("#$%", "\"").replace("#%$", "\n").replace("$#%", "\t");
                            }
                            if (fieldName != null) {
                                fld.set(container, str);
                            } else if (arrPos != null) {
                                Array.set(container, Integer.parseInt(arrPos), str);
                            }
                        } else {
                            System.err.println("Found attribute with name '" + fld + "'!");
                        }
                    }
                }
                catch (NoSuchFieldException e) {
                    System.err.println("Could not resolve field " + fieldName);
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    System.err.println("Why an illegal Access?!??!");
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            System.out.println("end " + localName);
            if (localName.equals("class") || localName.equals("array")) {
                Object o = this.recursion.pop();
                if (this.recursion.empty()) {
                    this.object = o;
                }
            }
        }

        Object getParsedObject() {
            if (this.recursion.empty()) {
                return this.object;
            }
            return null;
        }
    }
}

