/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import projections.gui.JLongTextField;
import projections.gui.LabelPanel;
import projections.gui.MainWindow;
import projections.gui.Timeline.EntryMethodObject;
import projections.gui.Timeline.TimelineMessage;
import projections.gui.Util;

public class MessagePanel
extends JPanel {
    int myRun = 0;
    private JPanel headerPanel;
    private JTable dataTable;
    private JLabel epLabel;
    private JPanel beginTimeField;
    private JPanel endTimeField;
    private JPanel numMsgsField;
    private JPanel createdPEField;
    private JPanel executedPEField;
    private EntryMethodObject obj;
    private Set messages;
    private Object[][] tableData;
    private Object[] columnNames;
    private static final int NUM_FIELDS = 6;
    private DecimalFormat df;

    MessagePanel(EntryMethodObject obj) {
        this.obj = obj;
        this.messages = obj.getMessages();
        this.tableData = new Object[obj.getNumMsgs()][6];
        this.columnNames = new Object[6];
        this.df = new DecimalFormat();
        this.df.setGroupingUsed(true);
        this.df.setGroupingSize(3);
        this.setData();
        this.createLayout();
    }

    private void setData() {
        this.columnNames[0] = "Message #";
        this.columnNames[1] = "Message Size";
        this.columnNames[2] = "Time Sent";
        this.columnNames[3] = "Time since last Send";
        this.columnNames[4] = "Target EP";
        this.columnNames[5] = "Destination PE(s)";
        Iterator iter = this.messages.iterator();
        int row = 0;
        TimelineMessage msg = null;
        TimelineMessage prev = null;
        while (iter.hasNext()) {
            prev = msg;
            msg = (TimelineMessage)iter.next();
            this.tableData[row][0] = new Integer(row);
            this.tableData[row][1] = this.df.format(msg.MsgLen);
            this.tableData[row][2] = this.df.format(msg.Time);
            this.tableData[row][3] = this.df.format(row > 0 ? msg.Time - prev.Time : msg.Time - this.obj.getBeginTime());
            this.tableData[row][4] = MainWindow.runObject[this.myRun].getEntryNameByID(msg.Entry);
            this.tableData[row][5] = msg.destination(MainWindow.runObject[this.myRun].getNumProcessors());
            ++row;
        }
    }

    private void createLayout() {
        this.epLabel = new JLabel(MainWindow.runObject[this.myRun].getEntryFullNameByID(this.obj.getEntryID()), 0);
        this.beginTimeField = new LabelPanel("BEGIN TIME:", new JLongTextField(this.obj.getBeginTime(), 10));
        this.endTimeField = new LabelPanel("END TIME:", new JLongTextField(this.obj.getEndTime(), 10));
        this.numMsgsField = new LabelPanel("MSGS:", new JTextField("" + this.obj.getNumMsgs(), 10));
        this.createdPEField = new LabelPanel("CREATED BY:", new JTextField("Processor " + this.obj.getPCreation()));
        this.executedPEField = new LabelPanel("EXECUTED ON:", new JTextField("Processor " + this.obj.getPCurrent()));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(gbl);
        Util.gblAdd(this.headerPanel, this.epLabel, gbc, 0, 0, 3, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.beginTimeField, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.endTimeField, gbc, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.numMsgsField, gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.createdPEField, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.headerPanel, this.executedPEField, gbc, 1, 2, 1, 1, 1, 1);
        this.dataTable = new JTable(this.tableData, this.columnNames);
        JScrollPane scrollPane = new JScrollPane(this.dataTable);
        JPanel scrollPaneContainer = new JPanel();
        scrollPaneContainer.setLayout(new BoxLayout(scrollPaneContainer, 0));
        scrollPaneContainer.add(scrollPane);
        this.setLayout(gbl);
        Util.gblAdd(this, this.headerPanel, gbc, 0, 0, 1, 1, 1, 0);
        gbc.fill = 1;
        Util.gblAdd(this, scrollPaneContainer, gbc, 0, 1, 1, 1, 1, 1);
    }
}

