/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.Symbol;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PDisplayStyle;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.Slot;
import java.util.Collections;
import java.util.Vector;

public class MemoryPList {
    private Vector slots = new Vector();
    private Vector names = new Vector();
    public static final int HOLE_SIZE = 0x3200000;

    public int addRow(String name) {
        this.names.add(name);
        this.slots.add(new Vector());
        return this.slots.size() - 1;
    }

    public int addElement(int type, Slot s) {
        Vector t = (Vector)this.slots.elementAt(type);
        t.add(s);
        return t.size() - 1;
    }

    public int size() {
        return this.slots.size();
    }

    public int size(int type) {
        return ((Vector)this.slots.elementAt(type)).size();
    }

    public String getName(int type) {
        return (String)this.names.elementAt(type);
    }

    public Slot elementAt(int type, int index) {
        return (Slot)((Vector)this.slots.elementAt(type)).elementAt(index);
    }

    public void sort() {
        for (int type = 0; type < this.names.size(); ++type) {
            Collections.sort((Vector)this.slots.elementAt(type));
        }
    }

    public Hole[] findHoles() {
        Vector<Hole> list = new Vector<Hole>();
        Hole bookkeeper = new Hole(0L, 0L);
        list.add(bookkeeper);
        MemoryIterator iter = new MemoryIterator(this);
        Slot cur = iter.getNext();
        Slot next = iter.getNext();
        while (next != null) {
            long diff = next.getLocation() - (cur.getLocation() + (long)cur.getSize());
            if (diff > 0x3200000L) {
                list.add(new Hole(cur.getLocation() + (long)cur.getSize(), diff));
                ++bookkeeper.position;
                bookkeeper.size += diff;
            }
            cur = next;
            next = iter.getNext();
        }
        Hole[] result = new Hole[(int)bookkeeper.position + 1];
        result = list.toArray(result);
        return result;
    }

    public boolean needRefresh() {
        return true;
    }

    public void load(PList list) {
        this.slots.clear();
        this.names.clear();
        if (list == null) {
            System.out.println("list is null!");
        }
        for (PAbstract cur = list.elementAt(0); cur != null; cur = cur.getNext()) {
            PList lcur = (PList)cur;
            PString lstr = (PString)lcur.elementNamed("name");
            int type = this.addRow(lstr.getString());
            PList lst = (PList)lcur.elementNamed("slots");
            for (PAbstract lstcur = lst.elementAt(0); lstcur != null; lstcur = lstcur.getNext()) {
                PList llcur = (PList)lstcur;
                Slot sl = Inspector.is64bit() ? new Slot(((PNative)llcur.elementNamed("loc")).getLongValue(0)) : new Slot(((PNative)llcur.elementNamed("loc")).getIntValue(0));
                sl.setSize(((PNative)llcur.elementNamed("size")).getIntValue(0));
                int flags = ((PNative)llcur.elementNamed("flags")).getIntValue(0);
                sl.setChareID(((PNative)llcur.elementNamed("chare")).getIntValue(0));
                if ((flags & 8) != 0) {
                    sl.setLeak(true);
                }
                if ((flags & 0x10) != 0) {
                    sl.setNewBlock(true);
                }
                if ((flags & 0x20) != 0) {
                    sl.setModified(true);
                }
                PNative st = (PNative)llcur.elementNamed("stack");
                for (int i = 0; i < st.length(); ++i) {
                    long location = Inspector.is64bit() ? st.getLongValue(i) : (long)st.getIntValue(i);
                    Symbol s = Symbol.get(location);
                    sl.addTrace(s);
                }
                sl.setType(((PNative)llcur.elementNamed("flags")).getIntValue(0) & 7);
                this.addElement(type, sl);
            }
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("Lists:\n");
        for (int i = 0; i < this.names.size(); ++i) {
            ret.append(this.getName(i) + " {\n");
            for (int j = 0; j < this.size(i); ++j) {
                ret.append("\tloc=0x" + Long.toHexString(this.elementAt(i, j).getLocation()) + ", size=" + this.elementAt(i, j).getSize() + ", trace: {\n\t\t");
                for (int k = 0; k < this.elementAt(i, j).getTraceSize(); ++k) {
                    if (k > 0) {
                        ret.append(",\n\t\t");
                    }
                    ret.append((Symbol)this.elementAt(i, j).getTrace(k));
                }
                ret.append("\t}\n");
            }
            ret.append("}\n");
        }
        return ret.toString();
    }

    public boolean draw(PDisplayStyle p, int drawStyle) {
        for (int i = 0; i < this.names.size(); ++i) {
            System.out.println("List " + this.getName(i));
        }
        return true;
    }

    public class MemoryIterator {
        private Vector heads;
        private MemoryPList source;

        public MemoryIterator(MemoryPList list) {
            this.source = list;
            this.heads = new Vector(list.size());
            for (int i = 0; i < list.size(); ++i) {
                if (list.size(i) == 0) continue;
                this.add(new Holder(i, 0, list.elementAt(i, 0)));
            }
        }

        private void add(Holder h) {
            int j;
            for (j = 0; j < this.heads.size() && h.slot.getLocation() >= ((Holder)this.heads.elementAt((int)j)).slot.getLocation(); ++j) {
            }
            this.heads.add(j, h);
        }

        public Slot getNext() {
            if (this.heads.size() == 0) {
                return null;
            }
            Holder result = (Holder)this.heads.elementAt(0);
            this.heads.remove(0);
            int pos = result.position + 1;
            if (pos < this.source.size(result.type)) {
                this.add(new Holder(result.type, pos, this.source.elementAt(result.type, pos)));
            }
            return result.slot;
        }

        private class Holder {
            int type;
            int position;
            Slot slot;

            Holder(int t, int p, Slot s) {
                this.type = t;
                this.position = p;
                this.slot = s;
            }
        }
    }

    public class Hole {
        long position;
        long size;

        public Hole() {
            this.position = 0L;
            this.size = 0L;
        }

        public Hole(long p, long s) {
            this.position = p;
            this.size = s;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }
    }
}

