#ifndef IS_NETSIM_DEF_SIG
#define IS_NETSIM_DEF_SIG 1
using namespace std;
#include <stdlib.h>
#include <math.h>
#include <map>
#include <vector>
#include <string>
#include <deque>
#include <queue>
#include <set>
#include <algorithm>
#include <functional>
#include <utility>
#include <limits.h>

#include "bgstuff.h"

DataMesgEnv *ConvertAndInitiate(int sN, int mI, int id, int dN, int dT, int rT,
				int mS, int mxPktSz, int ts,int inSrc, int realDest);

class TaskData {
 public:
  int srcNode, msgID, index;
  int destNode, destTID, recvTime, msgSize;
  TaskData() { }
  TaskData(int sN, int mI, int id, int dN, int dT, int rT, int mS) {
    srcNode = sN; msgID = mI; index = id;
    destNode = dN; destTID = dT; recvTime = rT; msgSize = mS;
  }
  void set(int sN, int mI, int id, int dN, int dT, int rT, int mS) {
    srcNode = sN; msgID = mI; index = id;
    destNode = dN; destTID = dT; recvTime = rT; msgSize = mS;
  }
  TaskData &operator=(const TaskData& td) {
    srcNode = td.srcNode; msgID = td.msgID; index = td.index;
    destNode = td.destNode; destTID = td.destTID;
    recvTime = td.recvTime; msgSize = td.msgSize;
    return *this;
  }
  void pup(class PUP::er &p) { 
    p(srcNode); p(msgID); p(index); 
    p(destNode); p(destTID); p(recvTime); p(msgSize);
  } 
  void dump() {
    CkPrintf("TaskData: srcNode=%d msgID=%d index=%d destNode=%d destTID=%d recvTime=%d msgSize=%d\n", srcNode, msgID, index, destNode, destTID, recvTime, msgSize);
  }
};

//a path is a ordered vector of the node ID channel index pairs leading from source to destination
// the node and channel id pairs are  2 element 1d arrays
// path manipulation is pretty much the most common activity in the sim
// so everything must be either inlined or public;
class Label 
{
 public:
  unsigned int id; // large number for identifier
  int switchid;          // pe field ensures uniqueness across PEs
  Label() { id=1; switchid = 0;}          // basic initialization

  Label(int iid, int sid) :id(iid), switchid(sid) { }
  void resetLabel() { id = 0; }               // sets to init state
  Label &operator=(const Label& e) 
    { 
      id = e.id; 
      switchid = e.switchid;
      return *this;
    }
  bool operator<(const Label & obj) const {
//    return ((id < obj.id)|| (pe < obj.pe));
    return (id < obj.id) || (id==obj.id && switchid < obj.switchid);
  }

  bool operator==(const Label &obj) const
    {
      return ((id == obj.id) && (switchid == obj.switchid));
    }
  bool operator!=(const Label& obj) const {
    return !(operator==(obj));
  }
  void nullize()		// so they can have null label objects.
    {
      id = 0;
    }
  bool isnull()			// test null label objects.
    {
      return (id == 0);
    
    }
  void dump() { CkPrintf("|%d.%d", id, switchid); }    // print Label

  char* sndump(char *sout,int n) { snprintf(sout,n,"%d.%d", id, switchid);return sout;}    // print Label
  void pup(class PUP::er &p) {p(id); p(switchid); }  // pup Label
  int idAsInt()			//if someone wants our ID as a number
    {
      return id;
    }
  void incLabel()                            // get next value for Label
    {
      id++;
      if (id == 0)
	CkAbort("NOTE: event ID rollover occurred!\n");
    }
};


class OutnBack 
{
 public:
  int first;
  Label second;
  OutnBack()
    {
    }
  ~OutnBack()
    {
    }
  OutnBack(int ifi,Label is):first(ifi),second(is)
    {
    }
  bool operator<(const OutnBack& obj) const {
    return (first < obj.first);
    
  }
  bool operator==(const OutnBack& obj) const {
    return (first  == obj.first);
  }
  void pup(PUP::er &p) 
    {
      p(first);
      second.pup(p);
    }

  OutnBack& operator=(const OutnBack& obj) {
     /*  if(this == &obj) { //do nothing on self copy
      return *this;
      }*/
    first = obj.first;
    second = obj.second;
    return *this;
  }  
};

class Chandoublepair 
{
 public:
  int first;
  double second;
  Chandoublepair()
    {
    }
  ~Chandoublepair()
    {
    }
  Chandoublepair(int ifi,double is):first(ifi),second(is)
    {
    }
  
};

struct PairSecondComp:
  std::binary_function<Chandoublepair,Chandoublepair,bool> 
{
  
  bool operator()(const Chandoublepair& lhs,const Chandoublepair& rhs) const
  {
    if(lhs.second==rhs.second)
      return(lhs.first<rhs.first);
    else
      return lhs.second<rhs.second;
  }
};

// routeMap knows the geography of the nodes
// it knows how to map between x,y,z and node id.
class tridcoord
{
 public:
  int id;
  int x;
  int y;
  int z;
  void pup(PUP::er & p)
    {
      p(id);
      p(x);
      p(y);
      p(z);
    }
  
  tridcoord(int iid):id(iid)
    {
    }
  tridcoord(int iid,int ix,int iy,int iz):id(iid),x(ix),y(iy),z(iz)
    {
    }
  tridcoord()
    {
      id=x=y=z=0;
      
    }
  tridcoord& operator=(const tridcoord& obj) {
    /* if(this == &obj) { //do nothing on self copy
      return *this;
      }*/
    id=obj.id;
    x=obj.x;
    y=obj.y;
    z=obj.z;
    return *this;
  }
/*  gzheng
  bool operator==(const tridcoord& obj) const {// short circuit compares to just the id
    return (id == obj.id);
  }
  bool operator<(const tridcoord& obj) const {// short circuit compares to just the id
    return (id  < obj.id);
  }  
*/
  void dump()
    {
      CkPrintf("|tridcoord: x %d y %d z %d id %d|\n", x,y,z,id);
    }
  
};

class routeMap : public Group
{
  friend class Switch;
  friend class state_Switch;
 private:
  unsigned int netlength;
  unsigned int netheight;
  unsigned int netwidth;
  int idstart;
  unsigned int wrapcost;
  vector < tridcoord > idtocoord;  //sorted vector
 public:
  unsigned int size;
  tridcoord getCD(Label findid) {
    int index=findid.idAsInt()-idstart;
    CmiAssert(index >= 0);
    if((unsigned int) index < idtocoord.size()) 
      return idtocoord[index];
    else {
      CkPrintf("|ERROR: no index %d as findid %d -idstart %d within %d elements|\n",index,findid.idAsInt(),idstart,idtocoord.size());
      abort();
      return tridcoord();
    }
  }
  routeMap& operator=(const routeMap& obj) {
    netlength=obj.netlength;
    netheight=obj.netheight;
    netwidth=obj.netwidth;
    idstart=obj.idstart;
    wrapcost=obj.wrapcost;
    idtocoord=obj.idtocoord;
    size=obj.size;
    return *this;
  }
  void pup(PUP::er &p) {
    p(netlength);
    p(netheight);
    p(netwidth);
    p(idstart);
    p(wrapcost);
    p(size);
    size_t puppacknum;
    if(p.isPacking())
      puppacknum=idtocoord.size();
    p(puppacknum);
    if(p.isUnpacking())
      idtocoord.resize(puppacknum);
    p(&idtocoord[0],puppacknum); 
  }

  routeMap(unsigned int ilen,unsigned int iht,unsigned int iwd,int ist, unsigned int iwrapcost):
    netlength(ilen),netheight(iht),netwidth(iwd),idstart(ist),wrapcost(iwrapcost) {
    for (unsigned int l=0;l<netlength;l++)
      for(unsigned int h=0;h<netheight;h++)
	for(unsigned int w=0;w<netwidth;w++) {
	  tridcoord anode(idstart+l*netheight*netwidth+h*netwidth+w,l,h,w);
	  idtocoord.push_back(anode);
	}
    size=ilen*iht*iwd;
  }
  routeMap () {
    netlength=netheight=netwidth=wrapcost=size=0;
    idstart=0;
    idtocoord.clear();
  }
  double netdistance (Label here, Label  src, Label  dest) {
    // lookup x,y,z
    // sqrt((dx^2)+(dy^2)+(dz^2))
    tridcoord srcCD=getCD(src);
    tridcoord destCD=getCD(dest);
    double geometric_dist= sqrt(pow(double(abs((int)(srcCD.x-destCD.x))),2.0)+pow(double(abs((int)(srcCD.y-destCD.y))),2.0)+pow(double(abs((int)(srcCD.z-destCD.z))),2.0));
    if(network_model == MESH3D)
      return(geometric_dist);

    // now see if there is a shorter wrap path
    // wrap path = src distance to face+ dest distance to face + wrap cost
    // to determine we essentially stack the cubes into a prism
    // and find the distance from src in cube A to dest in cube B
    // need to test this for the 3 nearest faces
    // where nearest is simply determined by which side of the midpoint we're on
    // netlength-2x >0, netheight -2y>0 , netwidth -2z>0
    double thruface1, thruface2,thruface3;
    double mindist=geometric_dist;
    if(netlength-2*srcCD.x>0) {  //origin side translation is x-netlength
      thruface1= sqrt(pow(double(abs((int)(srcCD.x-destCD.x-netlength))),2.0)+pow(double(abs((int)(srcCD.y-destCD.y))),2.0)+pow(double(abs((int)(srcCD.z-destCD.z))),2.0))+wrapcost;
    }
    else {
      //far side translation is x+netlength
      thruface1= sqrt(pow(double(abs((int)(srcCD.x-destCD.x+netlength))),2.0)+pow(double(abs((int)(srcCD.y-destCD.y))),2.0)+pow(double(abs((int)(srcCD.z-destCD.z))),2.0))+wrapcost;
    }
    mindist=min(mindist,thruface1);
    if(netheight-2*srcCD.y>0) {  //origin side translation is y-netheight
      thruface2= sqrt(pow(double(abs((int)(srcCD.x-destCD.x))),2.0)+pow(double(abs((int)(srcCD.y-destCD.y-netheight))),2.0)+pow(double(abs((int)(srcCD.z-destCD.z))),2.0))+wrapcost;
    }
    else {
      //far side translation is y+netheight
      thruface2= sqrt(pow(double(abs((int)(srcCD.x-destCD.x))),2.0)+pow(double(abs((int)(srcCD.y-destCD.y+netheight))),2.0)+pow(double(abs((int)(srcCD.z-destCD.z))),2.0))+wrapcost;
    }
    mindist=min(mindist,thruface2);
    if(netwidth-2*srcCD.z>0) {  //origin side translation is z-netwidth
      thruface3=sqrt(pow(double(abs((int)(srcCD.x-destCD.x))),2.0)+pow(double(abs((int)(srcCD.y-destCD.y))),2.0)+pow(double(abs((int)(srcCD.z-destCD.z-netwidth))),2.0)) +wrapcost;
    }
    else {
      //far side translation is z+netwidth
      thruface3= sqrt(pow(double(abs((int)(srcCD.x-destCD.x))),2.0)+pow(double(abs((int)(srcCD.y-destCD.y))),2.0)+pow(double(abs((int)(srcCD.z-destCD.z+netwidth))),2.0)) +wrapcost;
    }
    mindist=min(mindist,thruface3);
    return mindist;
  }
  void dump() {
    CkPrintf("|routeMap: len %d ht %d wid %d idstart %d wrapcost %d, size %d|\n", netlength,netheight,netwidth,idstart,wrapcost,size);
    for_each(idtocoord.begin(),idtocoord.end(),mem_fun_ref(&tridcoord::dump));      
  }
};


// cmdOps have a path, the chanlock or unchanlock op, and the message id of the message 

// foo
class cmdOp
{
 public:
  cmdOperation cmdop;
  Label  mid;
  cmdOp& operator=(const cmdOp& obj) {
    cmdop=obj.cmdop;
    mid=obj.mid;
    return *this;
  }
  void dump () {
    char sout[80];
    CkPrintf("|cmdop %d, mid %s|\n",(int) cmdop,mid.sndump(sout,79));
  }
  void pup(PUP::er &p) {
    int c;
    if (p.isPacking()) c = (int)cmdop;
    p(c);
    if (p.isUnpacking()) cmdop = (cmdOperation)c;
    mid.pup(p);
  }
  cmdOp(cmdOperation icmd, Label  imid) :cmdop(icmd),mid(imid) { }
  cmdOp(cmdOperation icmd): cmdop(icmd) { }
  cmdOp() { }
  ~cmdOp() { }
};


//messages

// to rewrite messages so we don't have 2 versions of each class we
// have to split them.  

//the eventMsg <X> (e.g. Reply) remains and has the inner data <X>Bag
//(e.g conReply) as its sole member.  <X> will only have the methods
//necessary for eventMsg.

// <X>Bag will have all the data member fields currently found in <X>
// <X>Bag will have the methods necessary for containers and our operations

// container classes will have the <X>Bag type in them.

class ReplyBag{
 public:
  bool reply;
  Label  src;
  Label  dest;
  Label  intermed;
  Label  from;		// reply from which switch
  Label  mid;
  Label  cid;
  bool done;

  void pup(PUP::er &p) {
    p(reply);
    src.pup(p);
    dest.pup(p);
    intermed.pup(p);
    from.pup(p);
    mid.pup(p);  
    cid.pup(p);  
    p(done);  
  }

  ReplyBag() {
    src.nullize();
    dest.nullize();
    intermed.nullize();
    from.nullize();
    cid.nullize();
    mid.nullize();
    reply=false;
    done=false;
  }

  ReplyBag(bool ireply, Label isrc, Label idest,Label imed, Label ifrom,Label  imid, Label  icid, bool idone):reply(ireply),src(isrc),dest(idest),intermed(imed),from(ifrom),mid(imid),cid(icid),done(idone) { }

  ReplyBag(bool ireply,Label  imid):reply(ireply),mid(imid) { //for find
    src.nullize();
    dest.nullize();
    intermed.nullize();
    from.nullize();
    cid.nullize();
    done=false;
  }
  // use the mid
  bool operator<(const ReplyBag& obj) const {
    return (mid < obj.mid);
  }
  bool operator==(const ReplyBag& obj) const {
    return (mid == obj.mid);
  }
  bool operator!=(const ReplyBag& obj) const {
    return !(operator==(obj));
  }
  ReplyBag& operator=(const ReplyBag& obj) {  
    src=obj.src;
    dest=obj.dest;
    intermed=obj.intermed;
    from=obj.from;
    reply=obj.reply;
    mid=obj.mid;
    cid=obj.cid;
    done=obj.done;
    return *this;
  }
  void dump() {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("|reply %d src %s ",(int) reply,src.sndump(sout,79));
    CkPrintf(" dest %s",dest.sndump(sout,79));
    CkPrintf(" intermed %s",intermed.sndump(sout,79));
    CkPrintf(" from %s",from.sndump(sout,79));
    CkPrintf(" mid %s",from.sndump(sout,79));
    CkPrintf(" cid %s done %d\n",from.sndump(sout,79),(int) done);
  }
};


class Reply
{
 public:
  ReplyBag bag;

  Reply() { }
  Reply(ReplyBag &ibag) :bag(ibag) { }
  Reply& operator=(const Reply& obj) {  
    eventMsg::operator=(obj);
    bag=obj.bag;
    return *this;
  }
  void dump() {
    CkPrintf("|reply timestamp %d|\n",timestamp);
    bag.dump();
  }
};


class CommandBag
{
 public:
  Label  id;
  Label  src;
  Label  dest;
  Label  sender;
  cmdOp command; // most of the time we're just passing this along
  size_t numDataPackets;
  size_t packsize;
  TaskData td;
  CommandBag(Label  iid,Label  isrc, Label  idest,Label  isender, cmdOp icommand, size_t inumDataPackets,size_t ipacksize,TaskData itd):  id(iid),src(isrc),dest(idest),sender(isender),command(icommand), numDataPackets(inumDataPackets),packsize(ipacksize),td(itd) { }
  CommandBag(Label  iid):  id(iid) { } // initializer for find
  CommandBag() {}
  bool operator<(const CommandBag& obj) const {
    return (id < obj.id);
  }
  bool operator==(const CommandBag& obj) const {
    return (id == obj.id);
  }
  bool operator!=(const CommandBag& obj) const {
    return !(operator==(obj));
  }
  CommandBag& operator=(const CommandBag& obj) {
    id = obj.id;
    src=obj.src;
    dest=obj.dest;
    sender=obj.sender;
    command=obj.command;
    numDataPackets=obj.numDataPackets;
    packsize=obj.packsize;
    td = obj.td;
    return *this;
  }
  void pup(PUP::er &p) {
    id.pup(p);
    src.pup(p);
    dest.pup(p);
    sender.pup(p);
    command.pup(p);
    p(numDataPackets);
    p(packsize);
    td.pup(p);
  }
  void dump() {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("|CommandBag[%s]:",id.sndump(sout,79));
    CkPrintf(" src %s,", id.sndump(sout,79));
    CkPrintf(" dest %s,", id.sndump(sout,79));
    CkPrintf("numDataPackets %lu packsize %lu|\n",numDataPackets,packsize);
    command.dump();
  }
};


class Command
{
 public:
  CommandBag bag;
  Command() { }
  Command(CommandBag &iBag) : bag(iBag) { }
  Command& operator=(const Command& obj) {
    eventMsg::operator=(obj);
    bag= obj.bag;
    return *this;
  }
  void dump() {
    CkPrintf("|Command: timestamp %d|\n",timestamp);
    bag.dump();
  }
};


class PacketBag
{
  friend class Switch;
  friend class state_Switch;
  
 private:
  Label  id;
  Label  mid;
  unsigned long sequence;
  bool final;

 public:
  bool isFinal() {return final;}
  PacketBag(Label iid, Label imid, unsigned long isequence=0,bool ifinal=false)
    : id(iid),mid(imid),sequence(isequence),final(ifinal) { }
  PacketBag() { }
  PacketBag(Label iid) : id(iid) { }
  PacketBag& operator=(const PacketBag& obj) {
    id=obj.id;
    mid=obj.mid;
    sequence=obj.sequence;
    final=obj.final;
    return *this;
  }
  void pup(PUP::er &p) {
    id.pup(p);
    mid.pup(p);
    p(sequence);
    p(final);
  }
  bool operator==(const PacketBag& obj) const {
    return ((mid == obj.mid)&&(id==obj.id));
  }
  bool operator<(const PacketBag& obj) const {
    // ??????????   gzheng
    //return ((id  < obj.id)&&(mid <obj.mid));
    return (id  < obj.id) || (id == obj.id && mid <obj.mid);
  }
  void dump() {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("|PacketBag: id %s, ",id.sndump(sout,79));
    CkPrintf("mid %s, sequence %lu final %d|\n", mid.sndump(sout,79),sequence,(int) final);
  }    
};


class Packet
{
  friend class Switch;
  friend class state_Switch;
  friend class conPacket;
 private:
  PacketBag bag;

 public:
  Packet(PacketBag &iBag) : bag(iBag) { }
  Packet() { }
  Packet& operator=(const Packet& obj) {
    eventMsg::operator=(obj);
    bag=obj.bag;
    return *this;
  }
  void dump() {
    CkPrintf("|Packet: timestamp %d|\n",timestamp);
    bag.dump();
  }  
};

class DataMesg
{
 public:
  Label  id;
  size_t maxpacksize;
  size_t numpackets;
  size_t rcvdpacks;
  TaskData td;
  DataMesg(Label  iid, size_t ipacksize, size_t inumpackets,TaskData itd) :
    id(iid),maxpacksize(ipacksize),numpackets(inumpackets),td(itd){
    rcvdpacks=0;
  }
  DataMesg(Label  iid) :    id(iid) { //initializer for find
    rcvdpacks=0;
  }
  
  // need these for deque usage
  DataMesg() {id.nullize();}
  bool operator<(const DataMesg& obj) const {
    return (id < obj.id);
  }
  bool operator==(const DataMesg& obj) const {
    return (id  == obj.id);
  }
  bool operator!=(const DataMesg& obj) const {
    return !(operator==(obj));
  }

  DataMesg& operator=(const DataMesg& obj) {
    id = obj.id;
    numpackets=obj.numpackets;
    maxpacksize=obj.maxpacksize;
    rcvdpacks=obj.rcvdpacks;
    td = obj.td;
    return *this;
  }
  // for varsize packing/unpacking
  void pup(PUP::er &p) {
    id.pup(p);
    p(maxpacksize);
    p(numpackets);
    p(rcvdpacks);
    td.pup(p);
  }
  void dump() {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("|DataMesg: id %s, maxpacksize %lu, numpackets %lu, rcvdpacks %lu|\n",id.sndump(sout,79), maxpacksize,numpackets,rcvdpacks);
    td.dump();
  }  
};


//lock abstraction for channels

class Chanlock
{
 private:
  Label  id;
  Label  chanlockOwnerId;
  bool chanlock;
 public:
  Chanlock(Label iid) : id(iid) {
    chanlockOwnerId.nullize();chanlock=false;
  }
  Chanlock() {
    id.nullize(); chanlockOwnerId.nullize(); chanlock=false;
  }
  ~Chanlock() {}
  Chanlock& operator=(const Chanlock& obj) {
    id=obj.id;
    chanlockOwnerId=obj.chanlockOwnerId;
    chanlock=obj.chanlock;
    return *this;
  }
  bool test() { return chanlock; }
  bool testAndSet(Label requesterid) {
    if(!chanlock) {
      chanlock=true;
      chanlockOwnerId=requesterid;
      return true;
    }
    return false;
  }
  bool unchanlock(Label imid) {
    if ((chanlock==true) && (imid==chanlockOwnerId)) {
      chanlock=false;
      chanlockOwnerId.nullize();
      return true;
    }
    else if (!chanlockOwnerId.isnull()) return false;
    else return true;
  }
  bool unchanlock() {
    if (chanlock==true) {
      chanlock=false;
      chanlockOwnerId.nullize();
      return true;
    }
    else return false;
  }
  void pup(PUP::er &p) {
    id.pup(p);
    chanlockOwnerId.pup(p);
    p(chanlock);
  }
  void dump() {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("|chanlock[%s]:",id.sndump(sout,79));
    CkPrintf(" owner %s chanlock %d |\n",chanlockOwnerId.sndump(sout,79),(int) chanlock);
  }
};

//note: Channel has no ID
// We don't care about the channel so much as its dest
// so we use dest where Id might otherwise be used
class Channel
{
 public:
  Label  src;  
  Label  dest; 
  double bandwidth;
  Chanlock chanlock;
  unsigned int cost;
  void pup(PUP::er &p) {
    src.pup(p);
    dest.pup(p);
    p(bandwidth);
    chanlock.pup(p);
    p(cost);
  }
  Channel() {
    src.nullize(); dest.nullize(),bandwidth=0.0; chanlock.unchanlock(); cost=1;
  }
  Channel(Label isrc, Label idest,double iband, Chanlock ilock,unsigned int icost) : src(isrc),dest(idest),bandwidth(iband),chanlock(ilock),cost(icost)  {
    chanlock.unchanlock();
  }
  ~Channel() {}
  bool operator==(const Channel& obj) const { 
    // short circuit compares to just the id  ????? gzheng
    return ((dest == obj.dest)&&(cost==obj.cost));
    //return (dest == obj.dest);
  }
  bool operator<(const Channel& obj) const { 
    // short circuit compares to just the id
    if((dest  < obj.dest)&&(cost<obj.cost));
    // ???????  gzheng
    return (dest<obj.dest);
  }
  Channel& operator=(const Channel& obj) {
    src=obj.src;
    dest=obj.dest;
    bandwidth=obj.bandwidth;
    chanlock=obj.chanlock;
    cost=obj.cost;
    return *this;
  }
  void dump () {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("|channel: src %s", src.sndump(sout,79));
    CkPrintf(" dest %s bandwidth %f cost %d chanlock ", dest.sndump(sout,79),bandwidth,cost);
    chanlock.dump();
    CkPrintf("|\n");
  }
};


class SwitchInit { // Switch object constructor message
 public:
  Label  id;
  unsigned int netLength;
  unsigned int netHeight;
  unsigned int netWidth;
  int idstart;
  tridcoord position;
  unsigned int wrapcost;
  double bandwidth;
  CkGroupID groupID;
  SwitchInit() { id.nullize(); }
  void pup(PUP::er &p) {
    id.pup(p);
    p(idstart);
    p(netLength);
    p(netHeight);
    p(netWidth);
    p(wrapcost);
    p(bandwidth);
    p|groupID;
    position.pup(p);
  }
  SwitchInit(Label  iid ) :  id(iid) { }
  SwitchInit(Label  iid,  unsigned int ilen,unsigned int ihei,unsigned int iwid, int iidstart,tridcoord ipos,unsigned int iwrapcost,double iband, CkGroupID igroupID):
    id(iid),netLength(ilen),netHeight(ihei),netWidth(iwid),idstart(iidstart),position(ipos),wrapcost(iwrapcost),bandwidth(iband),groupID(igroupID) { }
  SwitchInit& operator=(const SwitchInit& obj) {
    eventMsg::operator=(obj);
    id = obj.id;
    idstart=obj.idstart;
    netLength=obj.netLength;
    netHeight=obj.netHeight;
    netWidth=obj.netWidth;
    position=obj.position;
    wrapcost=obj.wrapcost;
    bandwidth=obj.bandwidth;
    groupID=obj.groupID;
    return *this;
  }
};

// envelope of src dest and timestamp for messages
// just a convenience class for the distributo
class DataMesgEnvBag
{
 public:
  int ltimestamp;
  Label  src;
  Label  dest;
  Label  mid;
  DataMesg mesg;
  DataMesgEnvBag& operator=(const DataMesgEnvBag& obj) {
    ltimestamp=obj.ltimestamp;
    src=obj.src;
    dest=obj.dest;
    mid=obj.mid;
    mesg=obj.mesg;
    return *this;
  }
  bool operator==(const DataMesgEnvBag& obj) const {
    // short circuit compares to just the mid
    return (mid == obj.mid);
  }
  bool operator!=(const DataMesgEnvBag& obj) const {
    return !(operator==(obj));
  }
  bool operator<(const DataMesgEnvBag& obj) const {
    // short circuit compares to just the mid
    return (mid  < obj.mid);
  }
  DataMesgEnvBag(int itime,Label  isrc, Label  idest,  DataMesg& imesg) :ltimestamp(itime),src(isrc),dest(idest),mesg(imesg) {
    mid=imesg.id;
  }
  DataMesgEnvBag(int itime, DataMesg& imesg) :ltimestamp(itime),mesg(imesg) { 
    mid=imesg.id;
  }
  DataMesgEnvBag(DataMesg& imesg) :mesg(imesg) { 
    ltimestamp=0;
    mid=imesg.id;
  }
  DataMesgEnvBag(Label iid): mid(iid) { ltimestamp=0; }
  DataMesgEnvBag() {}
  ~DataMesgEnvBag() {}
  void pup(PUP::er &p) {
    p(ltimestamp);
    src.pup(p);
    dest.pup(p);
    mid.pup(p);
    mesg.pup(p);
  }
  void dump() {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("|DataMesgEnvBag[%s]:",mid.sndump(sout,79));
    CkPrintf(" src %s dest %s ltimestamp %d|\n",src.sndump(sout,79));
    CkPrintf(" dest %s ltimestamp %d|\n",dest.sndump(sout,79),ltimestamp);
    mesg.dump();
  }
};

class DataMesgEnv
{
 public:
  DataMesgEnvBag bag;
  DataMesgEnv& operator=(const DataMesgEnv& obj) {
    eventMsg::operator=(obj);
    bag=obj.bag;
    return *this;
  }
  DataMesgEnv() { }
  DataMesgEnv(DataMesgEnvBag &iBag) : bag(iBag) { }
  void dump() {
    CkPrintf("|DataMesgEnv:  timestamp %d|\n",timestamp);
    bag.dump();
  }
};


// posers
class Switch {
 private: 
  Label  id;  
  Channel channels[6]; 
  int lastChannel;
  Label  curLabel;		// globally unique ID, also for checkpoint
  deque < DataMesgEnvBag > outMesgQ; 
  deque < DataMesg > inMesgQ;
  deque < ReplyBag > replyQ;
  deque < CommandBag > cmdMesgQ;
  deque < Label > connectReqQ;
  // we don't want a priority queue here, POSE does that.  FIFO is the way
  //  priority_queue<ConnectRequest, vector<ConnectRequest>,RequestComp> connectReqQ2;
  map < Label, OutnBack > packetroute;
  CkGroupID groupID;
  routeMap *nodemap;
 public:
  // The Essentials
  Switch();
  Switch(CkMigrateMessage *){}
  Switch(SwitchInit *m);
  ~Switch() {}
  void terminus();
  Switch& operator=(const Switch& obj) {
    rep::operator=(obj);
    id = obj.id;
    for (int i=0;i < 6; i++){channels[i] = obj.channels[i];}
    lastChannel = obj.lastChannel;
    curLabel = obj.curLabel;
    outMesgQ = obj.outMesgQ;
    inMesgQ = obj.inMesgQ;
    cmdMesgQ = obj.cmdMesgQ;
    connectReqQ = obj.connectReqQ;
    replyQ = obj.replyQ;
    packetroute = obj.packetroute;
    groupID=obj.groupID;
    CProxy_routeMap nodemap_proxy(groupID);
    nodemap= nodemap_proxy.ckLocalBranch();
    return *this;
  }
  
  bool operator==(const Switch& obj) const {
    // short circuit compares to just the id
    return (id == obj.id);
  }
  void pup(PUP::er &p) {
    chpt < state_Switch >::pup(p);
    id.pup(p);
    groupID.pup(p);
    size_t pupoutsize;
    size_t pupinsize;
    size_t pupcmdsize;
    size_t pupconnectsize;
    size_t pupreplysize;
    size_t puproutesize;
    p((void *)&channels[0],6*sizeof(Channel));
    p(lastChannel);
    curLabel.pup(p);
    if(p.isUnpacking()) { // new deques,  vector->deque
      CProxy_routeMap nodemap_proxy(groupID);
      nodemap= nodemap_proxy.ckLocalBranch();
      p(pupoutsize);
      p(pupinsize);
      p(pupcmdsize);
      p(pupconnectsize);
      p(pupreplysize);
      p(puproutesize);
      // groupID unpacked, remake proxy and localbranch 
      if(pupoutsize) {
	vector < DataMesgEnvBag > pupOutMesgQ(pupoutsize);  //short lived interim vector for array compatability
	p((void *) &pupOutMesgQ[0],pupoutsize*sizeof(DataMesgEnvBag));
	outMesgQ.assign(pupOutMesgQ.begin(),pupOutMesgQ.end());
      }
      if(pupinsize) {
	vector < DataMesg > pupInMesgQ(pupinsize);
	p((void *)&pupInMesgQ[0],pupinsize*sizeof(DataMesg));
	inMesgQ.assign(pupInMesgQ.begin(),pupInMesgQ.end());
      }
      if(pupcmdsize) {
	vector < CommandBag > pupCmdMesgQ(pupcmdsize);
	p((void *) &pupCmdMesgQ[0],pupcmdsize*sizeof(CommandBag));
	cmdMesgQ.assign(pupCmdMesgQ.begin(),pupCmdMesgQ.end());
      }
      if(pupconnectsize) {
	vector < Label > pupCnnctReqQ(pupcmdsize);
	p((void *) &pupCnnctReqQ[0],pupconnectsize*sizeof(Label));
	connectReqQ.assign(pupCnnctReqQ.begin(),pupCnnctReqQ.end());
      }
      if(pupreplysize) {
	vector < ReplyBag > pupreplyQ(pupreplysize);
	p((void *)&pupreplyQ[0],pupreplysize*sizeof(ReplyBag));
	replyQ.assign(pupreplyQ.begin(),pupreplyQ.end());
      }
      if(puproutesize) {
	// need something a bit fancier and slower for the map
	packetroute.clear();
	Label key,v2;
	int v1;
	for(;puproutesize>0;puproutesize--) {
	  key.pup(p);
	  p(v1);
	  v2.pup(p);
	  packetroute.insert(map < Label, OutnBack>::value_type(key,OutnBack(v1,v2)));
	}
      }
    }
    else { //copy from deque->vector, then pretend its an array
      pupoutsize=outMesgQ.size();
      pupinsize=inMesgQ.size();
      pupcmdsize=cmdMesgQ.size();
      pupreplysize=replyQ.size();
      puproutesize=packetroute.size();
      p(pupoutsize);
      p(pupinsize);
      p(pupcmdsize);
      p(pupconnectsize);
      p(pupreplysize);
      p(puproutesize);
      if(pupoutsize) {
	vector < DataMesgEnvBag > pupOutMesgQ(outMesgQ.begin(),outMesgQ.end()); 
	p((void *) &pupOutMesgQ[0],pupoutsize*sizeof(DataMesgEnvBag));
      }
      if(pupinsize) {
	vector < DataMesg > pupInMesgQ(inMesgQ.begin(),inMesgQ.end()); 
	p((void *)&pupInMesgQ[0],pupinsize*sizeof(DataMesg));
      }
      if(pupcmdsize) {
	vector < CommandBag > pupCmdMesgQ(cmdMesgQ.begin(),cmdMesgQ.end()); 
	p((void *) &pupCmdMesgQ[0],pupcmdsize*sizeof(CommandBag));
      }
      if(pupconnectsize) {
	vector < Label > pupCnnctReqQ(connectReqQ.begin(),connectReqQ.end()); 
	p((void *) &pupCnnctReqQ[0],pupconnectsize*sizeof(Label));
      }
      if(pupreplysize) {
	vector < ReplyBag > pupreplyQ(replyQ.begin(),replyQ.end()); 
	p((void *)&pupreplyQ[0],pupreplysize*sizeof(ReplyBag));
      }
      if(puproutesize) {
	map < Label, OutnBack >::iterator iter=packetroute.begin();
	Label key;
	while(iter != packetroute.end()) {
	  key=(*iter).first;
	  OutnBack value=(*iter).second;
	  key.pup(p);
	  p(value.first);
	  value.second.pup(p);
	  iter++;
	}
      }
    }
  }
  int getchannel(Label dest) {
    int i=0;
    for(i=0;i<6;i++)
      if(channels[i].dest==dest) return i; 
    char sout[80];
    memset(sout,0,80);
    parent->CommitPrintf ("ERROR! getchannel no can find %s",id.sndump(sout,79));
    parent->CommitPrintf (" %s\n",dest.sndump(sout,79));
    return 7;
  }
  int getcost(Label  dest) {
    if(id==dest) return(0); //talking to yourself is free
    int i=0;
    for(i=0;i<6;i++)
      if(channels[i].dest==dest) return channels[i].cost; 
    char sout[80];
    memset(sout,0,80);
    parent->CommitPrintf("ERROR! getcost no can find %s",id.sndump(sout,79));
    parent->CommitPrintf(" %s\n",dest.sndump(sout,79));
    return 7;
  }
  void channelAvailable();
  int findTheChannel(Label,Label);
  bool sendMesg(Label  mid);
  void netconnect(Label  mid);
  void lockAndSend(int dchannel, Command *cmd);
  // Event methods
  void recv(Packet *m);
  void recv_anti(Packet *);
  void recv_commit(Packet *m) { }
  void initiate(DataMesgEnv *m);
  void initiate_anti(DataMesgEnv *) { restore(this); }
  void initiate_commit(DataMesgEnv *m) { }
  void recv(Command *m);
  void recv_anti(Command *m);
  void recv_commit(Command *m) { }
  void recv(Reply *m);
  void recv_anti(Reply *m);
  void recv_commit(Reply *m) { }
  void dump() {
    char sout[80];
    memset(sout,0,80);
    CkPrintf("Switch[%s]: has \n",id.sndump(sout,79));
    for_each(&channels[0],&channels[6], mem_fun_ref(&Channel::dump));
    CkPrintf("outQ \n");
    for_each(outMesgQ.begin(),outMesgQ.end(),
	     mem_fun_ref(&DataMesgEnvBag::dump));
    CkPrintf("inQ: \n");
    for_each(inMesgQ.begin(),inMesgQ.end(), mem_fun_ref(&DataMesg::dump));
    CkPrintf("replyQ \n");
    for_each(replyQ.begin(),replyQ.end(), mem_fun_ref(&ReplyBag::dump));
    CkPrintf("cmdMesgQ \n");
    for_each(cmdMesgQ.begin(),cmdMesgQ.end(), mem_fun_ref(&CommandBag::dump));
    CkPrintf("connectReqQ \n");
    for_each(connectReqQ.begin(),connectReqQ.end(), mem_fun_ref(&Label::dump));
    CkPrintf("routemap has %d routes\n",packetroute.size());
    map < Label, OutnBack >::iterator iter=packetroute.begin();
    Label key;
    while(iter != packetroute.end()) {
      key=(*iter).first;
      OutnBack value=(*iter).second;
      CkPrintf("k= %s v= %d", key.sndump(sout,79), value.first);
      CkPrintf(" %s\n",  value.second.sndump(sout,79));
      iter++;
    }
  }
  void qdump() {
    char sout[80];
    memset(sout,0,80);
    if((outMesgQ.size()>0) ||(inMesgQ.size()>0) ||(replyQ.size()>0)||(cmdMesgQ.size()>0)||(connectReqQ.size()>0)||(packetroute.size()>0))
      {
	CkPrintf("Switch[%s]: has \n",id.sndump(sout,79));
	CkPrintf("outQ \n");
	for_each(outMesgQ.begin(),outMesgQ.end(),
		 mem_fun_ref(&DataMesgEnvBag::dump));
	CkPrintf("inQ: \n");
	for_each(inMesgQ.begin(),inMesgQ.end(), mem_fun_ref(&DataMesg::dump));
	CkPrintf("replyQ \n");
	for_each(replyQ.begin(),replyQ.end(), mem_fun_ref(&ReplyBag::dump));
	CkPrintf("cmdMesgQ \n");
	for_each(cmdMesgQ.begin(),cmdMesgQ.end(), mem_fun_ref(&CommandBag::dump));
	CkPrintf("connectReqQ \n");
	for_each(connectReqQ.begin(),connectReqQ.end(), mem_fun_ref(&Label::dump));
	CkPrintf("routemap has %d routes\n",packetroute.size());
	map < Label, OutnBack >::iterator iter=packetroute.begin();
	Label key;
	while(iter != packetroute.end()) {
	  key=(*iter).first;
	  OutnBack value=(*iter).second;
	  CkPrintf("k= %s v= %d", key.sndump(sout,79), value.first);
	  CkPrintf(" %s\n",  value.second.sndump(sout,79));
	  iter++;
	}
      }
  }
  static int switchPIDToNodePID(int switchpid);
  Label GetLabel()  {                   // generates unique event IDs
    curLabel.incLabel();    
    return curLabel;
  }
};

int nodeToSwitchPID(int destnode);
int switchPIDToNode(int switchpid);


#endif


