/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.ColorPanel;
import projections.gui.ColorSelectable;
import projections.gui.GrayPanel;
import projections.gui.Util;

public class EntrySelectionDialog
extends Frame
implements ActionListener {
    private ColorSelectable callbackTarget;
    private ColorPanel[][] entryPointColors;
    private Checkbox[][] entryPointSelection;
    private ColorPanel selectedCP;
    private Button bAll;
    private Button bClear;
    private Button bSave;
    private Button bCancel;
    private int numTypes;
    private String[] typeLabelStrings;
    private int numEPs;
    private boolean[][] stateArray;
    private Color[][] colorArray;
    private boolean[][] existsArray;
    private String[] entryNames;
    private boolean layoutComplete = false;

    public EntrySelectionDialog(Frame parent, ColorSelectable callbackTarget, String[] typeLabelStrings, boolean[][] stateArray, Color[][] colorArray, boolean[][] existsArray, String[] entryNames) {
        this.callbackTarget = callbackTarget;
        this.numTypes = typeLabelStrings.length;
        this.typeLabelStrings = typeLabelStrings;
        this.numEPs = stateArray[this.numTypes - 1].length;
        this.stateArray = stateArray;
        this.colorArray = colorArray;
        this.existsArray = existsArray;
        this.entryNames = entryNames;
        this.entryPointColors = new ColorPanel[this.numTypes][this.numEPs];
        this.entryPointSelection = new Checkbox[this.numTypes][this.numEPs];
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EntrySelectionDialog.this.closeDialog();
            }
        });
    }

    public void showDialog() {
        if (this.layoutComplete) {
            this.setVisible(true);
        } else {
            this.setBackground(Color.lightGray);
            this.setTitle("Select Display Items");
            this.setLocation(0, 0);
            this.createLayout();
            this.pack();
            this.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof ColorPanel) {
            this.selectedCP = (ColorPanel)evt.getSource();
            String selectTitle = "";
            selectTitle = this.entryNames[this.selectedCP.getIndex()];
            selectTitle = selectTitle + " : " + this.typeLabelStrings[this.selectedCP.getType()];
            JColorChooser colorWindow = new JColorChooser();
            Color returnColor = JColorChooser.showDialog(this, selectTitle, this.selectedCP.getColor());
            if (returnColor != null) {
                this.selectedCP.setColor(returnColor);
            }
        } else if (evt.getSource() instanceof Button) {
            Button b = (Button)evt.getSource();
            if (b == this.bAll || b == this.bClear) {
                boolean dest = b == this.bAll;
                for (int type = 0; type < this.numTypes; ++type) {
                    for (int ep = 0; ep < this.numEPs; ++ep) {
                        if (!this.existsArray[type][ep]) continue;
                        this.entryPointSelection[type][ep].setState(dest);
                    }
                }
            } else if (b == this.bCancel) {
                this.closeDialog();
            } else if (b == this.bSave) {
                for (int type = 0; type < this.numTypes; ++type) {
                    for (int ep = 0; ep < this.numEPs; ++ep) {
                        if (!this.existsArray[type][ep]) continue;
                        this.colorArray[type][ep] = this.entryPointColors[type][ep].getColor();
                        this.stateArray[type][ep] = this.entryPointSelection[type][ep].getState();
                    }
                }
                if (this.callbackTarget != null) {
                    this.callbackTarget.applyDialogColors();
                }
                this.setVisible(false);
            }
        }
    }

    void closeDialog() {
        this.setVisible(false);
        for (int type = 0; type < this.numTypes; ++type) {
            for (int ep = 0; ep < this.numEPs; ++ep) {
                if (!this.existsArray[type][ep]) continue;
                this.entryPointSelection[type][ep].setState(this.stateArray[type][ep]);
                this.entryPointColors[type][ep].setColor(this.colorArray[type][ep]);
            }
        }
        this.dispose();
    }

    private void createLayout() {
        for (int type = 0; type < this.numTypes; ++type) {
            for (int ep = 0; ep < this.numEPs; ++ep) {
                if (!this.existsArray[type][ep]) continue;
                this.entryPointSelection[type][ep] = new Checkbox();
                this.entryPointSelection[type][ep].setState(this.stateArray[type][ep]);
                this.entryPointColors[type][ep] = new ColorPanel(type, ep, this.colorArray[type][ep]);
                this.entryPointColors[type][ep].addActionListener(this);
            }
        }
        Panel mainPanel = new Panel();
        this.add("Center", mainPanel);
        mainPanel.setBackground(Color.gray);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        mainPanel.setLayout(gbl);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 2, 0, 2);
        Label lNote0 = new Label("USAGE NOTES:");
        Label lNote1 = new Label("- Modify colors by clicking on color button.");
        Label lNote2 = new Label("- Click on check box to select an EP to display.");
        Label lNote3 = new Label("- EPs that are not used during execution are not presented here.");
        lNote0.setFont(new Font("SansSerif", 0, 10));
        lNote1.setFont(new Font("SansSerif", 0, 10));
        lNote2.setFont(new Font("SansSerif", 0, 10));
        lNote3.setFont(new Font("SansSerif", 0, 10));
        ScrollPane sp = new ScrollPane();
        GrayPanel displayPanel = new GrayPanel();
        displayPanel.setLayout(gbl);
        Util.gblAdd(displayPanel, sp, gbc, 0, 0, 1, 1, 1, 1, 5, 5, 0, 5);
        Util.gblAdd(displayPanel, lNote0, gbc, 0, 1, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(displayPanel, lNote1, gbc, 0, 2, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(displayPanel, lNote2, gbc, 0, 3, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(displayPanel, lNote3, gbc, 0, 4, 1, 1, 1, 0, 0, 5, 5, 5);
        Label[] typeLabels = new Label[this.numTypes];
        for (int type = 0; type < this.numTypes; ++type) {
            typeLabels[type] = new Label(this.typeLabelStrings[type], 1);
        }
        Panel contentPanel = new Panel();
        sp.add(contentPanel);
        contentPanel.setLayout(gbl);
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 2, 0, 2);
        for (int type = 0; type < this.numTypes; ++type) {
            Util.gblAdd(contentPanel, typeLabels[type], gbc, 1 + 2 * type, 0, 2, 1, 1, 0);
        }
        int ypos = 1;
        gbc.fill = 1;
        for (int ep = 0; ep < this.numEPs; ++ep) {
            int xpos = 0;
            if (!this.someExists(ep)) continue;
            gbc.anchor = 10;
            gbc.fill = 1;
            Label tempLabel = new Label(this.entryNames[ep], 2);
            Util.gblAdd(contentPanel, tempLabel, gbc, xpos++, ypos, 1, 1, 1, 0, 0, 2, 0, 5);
            for (int type = 0; type < this.numTypes; ++type) {
                if (this.existsArray[type][ep]) {
                    gbc.fill = 3;
                    gbc.anchor = 13;
                    Util.gblAdd(contentPanel, this.entryPointSelection[type][ep], gbc, xpos++, ypos, 1, 1, 1, 0, 0, 0, 0, 0);
                    gbc.anchor = 17;
                    Util.gblAdd(contentPanel, this.entryPointColors[type][ep], gbc, xpos++, ypos, 1, 1, 1, 0, 0, 0, 0, 0);
                    continue;
                }
                xpos += 2;
            }
            ++ypos;
        }
        sp.validate();
        GrayPanel buttonPanel = new GrayPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.bAll = new Button("Select All");
        this.bClear = new Button("Clear All");
        this.bSave = new Button("Save and Exit");
        this.bCancel = new Button("Cancel");
        this.bAll.addActionListener(this);
        this.bClear.addActionListener(this);
        this.bSave.addActionListener(this);
        this.bCancel.addActionListener(this);
        buttonPanel.add(this.bAll);
        buttonPanel.add(this.bClear);
        buttonPanel.add(this.bSave);
        buttonPanel.add(this.bCancel);
        gbc.fill = 1;
        Util.gblAdd(mainPanel, displayPanel, gbc, 0, 0, 1, 1, 1, 1, 4, 4, 2, 4);
        Util.gblAdd(mainPanel, buttonPanel, gbc, 0, 1, 1, 1, 1, 0, 2, 4, 4, 4);
        this.layoutComplete = true;
    }

    private boolean someExists(int epIdx) {
        for (int type = 0; type < this.numTypes; ++type) {
            if (!this.existsArray[type][epIdx]) continue;
            return true;
        }
        return false;
    }
}

