/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import projections.gui.graph.YAxis;

public class MultiRunYAxis
extends YAxis {
    public static final int TIME = 1;
    public static final int MSG = 2;
    public static final int FP_NUMBER = 3;
    private int mode = 1;
    private String title;
    private double max;
    private double min = 0.0;

    public MultiRunYAxis(int Nmode, String Ntitle, double Nmax) {
        this.mode = Nmode;
        this.title = Ntitle;
        this.max = Nmax;
    }

    public MultiRunYAxis(int Nmode, String Ntitle, double Nmax, double Nmin) {
        this.mode = Nmode;
        this.title = Ntitle;
        this.max = Nmax;
        this.min = Nmin;
    }

    public String getTitle() {
        return this.title;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        if (this.max > this.min) {
            return this.max;
        }
        return this.min;
    }

    public double getDifference() {
        return 0.01 * (this.getMax() - this.getMin());
    }

    public String getValueName(double value) {
        if (this.mode == 1) {
            return Long.toString((long)value) + "us";
        }
        if (this.mode == 2) {
            return Long.toString((long)value);
        }
        if (this.mode == 3) {
            return Double.toString(value);
        }
        return null;
    }
}

