/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

public class BuildDependencyGenerator {
    protected String grammarFileName;
    protected Tool tool;
    protected Grammar grammar;
    protected CodeGenerator generator;
    protected StringTemplateGroup templates;

    public BuildDependencyGenerator(Tool tool, String string) throws IOException, TokenStreamException, RecognitionException {
        this.tool = tool;
        this.grammarFileName = string;
        this.grammar = tool.getGrammar(string);
        String string2 = (String)this.grammar.getOption("language");
        this.generator = new CodeGenerator(tool, this.grammar, string2);
        this.generator.loadTemplates(string2);
    }

    public List getGeneratedFileList() {
        String string;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = this.tool.getOutputDirectory(this.grammarFileName);
        if (file.getName().equals(".")) {
            file = null;
        } else if (file.getName().indexOf(32) >= 0) {
            string = Utils.replace(file.toString(), " ", "\\ ");
            file = new File(string);
        }
        string = this.generator.getRecognizerFileName(this.grammar.name, this.grammar.type);
        arrayList.add(new File(file, string));
        arrayList.add(new File(file, this.generator.getVocabFileName()));
        StringTemplate stringTemplate = null;
        if (this.generator.getTemplates().isDefined("headerFile")) {
            stringTemplate = this.generator.getTemplates().getInstanceOf("headerFileExtension");
            arrayList.add(new File(file, stringTemplate.toString()));
        }
        if (this.grammar.type == 4) {
            String string2 = this.generator.getRecognizerFileName(this.grammar.name, 1);
            arrayList.add(new File(file, string2));
            String string3 = Grammar.grammarTypeToFileNameSuffix[1];
            if (stringTemplate != null) {
                String string4 = this.grammar.name + string3 + stringTemplate.toString();
                arrayList.add(new File(file, string4));
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public List getDependenciesFileList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = (String)this.grammar.getOption("tokenVocab");
        if (string == null) {
            return null;
        }
        File file = this.grammar.getImportedVocabFileName(string);
        File file2 = file.getParentFile();
        if (file2.getName().equals(".")) {
            arrayList.add(file.getName());
        } else if (file2.getName().indexOf(32) >= 0) {
            String string2 = Utils.replace(file2.toString(), " ", "\\ ");
            file2 = new File(string2);
            arrayList.add(new File(file2, file.getName()));
        } else {
            arrayList.add(file);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public StringTemplate getDependencies() {
        this.loadDependencyTemplates();
        StringTemplate stringTemplate = this.templates.getInstanceOf("dependencies");
        stringTemplate.setAttribute("in", (Object)this.getDependenciesFileList());
        stringTemplate.setAttribute("out", (Object)this.getGeneratedFileList());
        stringTemplate.setAttribute("grammarFileName", (Object)this.grammar.fileName);
        return stringTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDependencyTemplates() {
        if (this.templates != null) {
            return;
        }
        String string = "org/antlr/tool/templates/depend.stg";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            classLoader = ErrorManager.class.getClassLoader();
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            ErrorManager.internalError("Can't load dependency templates: " + string);
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.templates = new StringTemplateGroup((Reader)bufferedReader, AngleBracketTemplateLexer.class);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            ErrorManager.internalError("error reading dependency templates file " + string, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    ErrorManager.internalError("cannot close dependency templates file " + string, iOException);
                }
            }
        }
    }
}

