/**
 * XAxisFixed-- a simple static implementation of XAxis.
 * Orion Sky Lawlor, olawlor@acm.org, 4/2/2002.
 */

package projections.gui.graph;
import projections.gui.*;

public class YAxisFixedValue extends YAxis
{
  private String title;
  private String units;
  private double min;
  private double max;

  public void setMin(double min) { this.min = min; }
  public void setMax(double max) { this.max = max; }

  public int getAxisType() { return Axis.CONTINUOUS; }

  public YAxisFixedValue(String title_,String units_, double min, double max) {
    title=title_; 
    units=units_;
    this.min=min;
    this.max=max;
  }
  
  public String getTitle() { return title; }
  public String getUnits() { return units; }
  public double getMin() { return min; }
  public double getMax() { return max; }
  public int getMinIndex() { return (int)min; }
  public int getMaxIndex() { return (int)max; }
}



