/* 
tkAppInit.c --

  Main file for SARview application: initializes Tcl/Tk.

  Orion Lawlor, 5/6/99

This file registers the shared variables between Tcl and C,
registers the Tcl-callable C routines, and calls the Tcl
scripts.
*/
#include "mytk.h"

/* The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
extern int matherr();
int *tclDummyMathPtr = (int *) matherr;
 */

static char **stashed_argv;

/*Application main routine: just passes control off to Tcl/Tk,
which will return the favor immediately by calling Tcl_AppInit.*/
int main(int argc,char *argv[])
{
    stashed_argv=argv;
    argc=1;//Tcl seems confused by our arguments
    Tk_Main(argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}

/**********************************************
Application Initialization routine.  Loads up linked 
variables, registers Tcl-callable C routines, and
runs the initialization and main TCL scripts.
*/
extern "C" int Vtkcommontcl_Init(Tcl_Interp *interp);
extern "C" int Vtkgraphicstcl_Init(Tcl_Interp *interp);
extern "C" int Vtktkrenderwidget_Init(Tcl_Interp *interp);
extern "C" int Vtkimagingtcl_Init(Tcl_Interp *interp);
extern "C" int Vtktkimageviewerwidget_Init(Tcl_Interp *interp);
extern "C" int Vtktkimagewindowwidget_Init(Tcl_Interp *interp);
extern "C" int Vtkpatentedtcl_Init(Tcl_Interp *interp);
extern "C" int Vtkcontribtcl_Init(Tcl_Interp *interp);


Tcl_Interp *interp=NULL;
int Tcl_AppInit(Tcl_Interp *loc_interp)		/* Interpreter for application. */
{
/*Initialize the Tcl libraries we'll use*/
	interp=loc_interp;
	if (Tcl_Init(interp) == TCL_ERROR)  return TCL_ERROR;
	if (Tk_Init(interp) == TCL_ERROR)  return TCL_ERROR;
	Tcl_StaticPackage(interp, "Tk", Tk_Init, Tk_SafeInit);
	
/*Initialize my Tcl commands*/
	tkMyAppInit(interp);
	if (Tcl_Eval(interp,
#include "tk_init.h"
		)==TCL_ERROR) return TCL_ERROR;

/*Start the app.*/
	tkMyAppStart(interp,stashed_argv);
	
	return TCL_OK;
}
