/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import projections.analysis.CallGraph;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;

public class CommTimeWindow
extends GenericGraphWindow
implements ItemListener,
ActionListener,
ColorSelectable {
    static int myRun = 0;
    CommTimeWindow thisWindow;
    private EntrySelectionDialog entryDialog;
    private JPanel mainPanel;
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private JPanel controlPanel;
    private JButton setRanges;
    private JButton epSelection;
    private JButton saveColors;
    private JButton loadColors;
    CheckboxGroup cbg;
    private Checkbox sentMsgs;
    private Checkbox sentBytes;
    private Checkbox receivedMsgs;
    private Checkbox receivedBytes;
    private Checkbox receivedExternalMsgs;
    private Checkbox receivedExternalBytes;
    private int startInterval;
    private int endInterval;
    private int numIntervals;
    private int numEPs;
    private long intervalSize;
    private OrderedIntList processorList;
    private String currentArrayName;
    private String[] typeLabelNames = new String[]{"Entry Points"};
    private boolean[][] stateArray;
    private boolean[][] existsArray;
    private Color[][] colorArray;
    private String[] entryNames;
    private double[][] sentMsgCount;
    private double[][] sentByteCount;
    private double[][] receivedMsgCount;
    private double[][] receivedByteCount;
    private double[][] receivedExternalMsgCount;
    private double[][] receivedExternalByteCount;
    private Color[] outColors;
    private double[][] sentMsgOutput;
    private double[][] sentByteOutput;
    private double[][] receivedMsgOutput;
    private double[][] receivedByteOutput;
    private double[][] receivedExternalMsgOutput;
    private double[][] receivedExternalByteOutput;
    private boolean startFlag;
    private DecimalFormat _format;

    protected void windowInit() {
        super.windowInit();
        this.intervalSize = 1000L;
        this.startInterval = 0;
        this.endInterval = this.endTime % this.intervalSize == 0L ? (int)(this.endTime / this.intervalSize - 1L) : (int)(this.endTime / this.intervalSize);
        this.numIntervals = this.endInterval - this.startInterval + 1;
        this.processorList = MainWindow.runObject[myRun].getValidProcessorList();
    }

    public CommTimeWindow(MainWindow mainWindow) {
        super("Projections Communication vs Time Graph - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.setGraphSpecificData();
        this.numEPs = MainWindow.runObject[myRun].getNumUserEntries();
        this.stateArray = new boolean[1][this.numEPs];
        this.existsArray = new boolean[1][this.numEPs];
        this.colorArray = new Color[1][this.numEPs];
        this.entryNames = new String[this.numEPs];
        for (int ep = 0; ep < this.numEPs; ++ep) {
            this.colorArray[0][ep] = MainWindow.runObject[myRun].getEntryColor(ep);
            this.entryNames[ep] = MainWindow.runObject[myRun].getEntryNameByIndex(ep);
        }
        this.mainPanel = new JPanel();
        this._format = new DecimalFormat("###,###.###");
        this.setLayout(this.mainPanel);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.startFlag = true;
        this.showDialog();
    }

    protected void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(mbar);
    }

    protected void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.cbg = new CheckboxGroup();
        this.sentMsgs = new Checkbox("Msgs Sent To", this.cbg, true);
        this.sentMsgs.addItemListener(this);
        this.sentBytes = new Checkbox("Bytes Sent To", this.cbg, false);
        this.sentBytes.addItemListener(this);
        this.receivedMsgs = new Checkbox("Msgs Recv By", this.cbg, false);
        this.receivedMsgs.addItemListener(this);
        this.receivedBytes = new Checkbox("Bytes Recv By", this.cbg, false);
        this.receivedBytes.addItemListener(this);
        this.receivedExternalMsgs = new Checkbox("External Msgs Recv By", this.cbg, false);
        this.receivedExternalMsgs.addItemListener(this);
        this.receivedExternalBytes = new Checkbox("External Bytes Recv By", this.cbg, false);
        this.receivedExternalBytes.addItemListener(this);
        this.checkBoxPanel = new JPanel();
        Util.gblAdd(this.checkBoxPanel, this.sentMsgs, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedMsgs, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedBytes, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalMsgs, gbc, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalBytes, gbc, 5, 0, 1, 1, 1, 1);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.epSelection = new JButton("Select Entry Points");
        this.epSelection.addActionListener(this);
        this.saveColors = new JButton("Save Entry Colors");
        this.saveColors.addActionListener(this);
        this.loadColors = new JButton("Load Entry Colors");
        this.loadColors.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.epSelection, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.saveColors, gbc, 2, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.loadColors, gbc, 3, 0, 1, 1, 0, 0);
        this.graphPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, this.graphPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gbc, 0, 2, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 3, 1, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent ae) {
        if (ae.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox cb = (Checkbox)ae.getSource();
            this.setCheckboxData(cb);
            this.setCursor(new Cursor(0));
        }
    }

    public void setCheckboxData(Checkbox cb) {
        if (cb == this.sentMsgs) {
            this.setDataSource("Communication vs Time", this.sentMsgOutput, this.outColors, this);
            this.setPopupText("sentMsgCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Messages Sent", "");
            super.refreshGraph();
        } else if (cb == this.sentBytes) {
            this.setDataSource("Communication vs Time", this.sentByteOutput, this.outColors, this);
            this.setPopupText("sentByteCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Bytes Sent", "");
            super.refreshGraph();
        } else if (cb == this.receivedMsgs) {
            this.setDataSource("Communication vs Time", this.receivedMsgOutput, this.outColors, this);
            this.setPopupText("receivedMsgCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Messages Received", "");
            super.refreshGraph();
        } else if (cb == this.receivedBytes) {
            this.setDataSource("Communication vs Time", this.receivedByteOutput, this.outColors, this);
            this.setPopupText("receivedByteCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Bytes Received", "");
            super.refreshGraph();
        } else if (cb == this.receivedExternalMsgs) {
            this.setDataSource("Communication vs Time", this.receivedExternalMsgOutput, this.outColors, this);
            this.setPopupText("receivedExternalMsgCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Messages Received Externally", "");
            super.refreshGraph();
        } else if (cb == this.receivedExternalBytes) {
            this.setDataSource("Communication vs Time", this.receivedExternalByteOutput, this.outColors, this);
            this.setPopupText("receivedExternalByteCount");
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Bytes Received Externally", "");
            super.refreshGraph();
        }
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Time", "");
        this.setYAxis("Count", "");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    CommTimeWindow.this.fillGraphData();
                    return null;
                }

                public void finished() {
                    CommTimeWindow.this.setOutputGraphData();
                    Checkbox cb = CommTimeWindow.this.cbg.getSelectedCheckbox();
                    CommTimeWindow.this.setCheckboxData(cb);
                    CommTimeWindow.this.thisWindow.setVisible(true);
                    CommTimeWindow.this.thisWindow.repaint();
                }
            };
            worker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = dialog.getIntervalSize();
        this.startInterval = (int)dialog.getStartInterval();
        this.endInterval = (int)dialog.getEndInterval();
        this.numIntervals = this.endInterval - this.startInterval + 1;
        this.processorList = dialog.getValidProcessors();
    }

    public void setDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        dialog.setIntervalSize(this.intervalSize);
        dialog.setValidProcessors(this.processorList);
        super.setDialogData();
    }

    public void fillGraphData() {
        CallGraph cg = new CallGraph(this.startInterval, this.endInterval, this.intervalSize, this.processorList);
        cg.GatherData(this);
        double[][] messageArray = cg.getMessageArray();
        double[][] byteArray = cg.getByteArray();
        double[][] externalMessageArray = cg.getExternalMessageArray();
        double[][] externalByteArray = cg.getExternalByteArray();
        this.sentMsgCount = new double[this.numIntervals][this.numEPs];
        this.sentByteCount = new double[this.numIntervals][this.numEPs];
        this.receivedMsgCount = new double[this.numIntervals][this.numEPs];
        this.receivedByteCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalMsgCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalByteCount = new double[this.numIntervals][this.numEPs];
        for (int interval = 0; interval < this.numIntervals; ++interval) {
            for (int ep = 0; ep < this.numEPs; ++ep) {
                this.sentMsgCount[interval][ep] = messageArray[interval][ep];
                this.sentByteCount[interval][ep] = byteArray[interval][ep];
                this.receivedMsgCount[interval][ep] = messageArray[interval][ep + this.numEPs];
                this.receivedByteCount[interval][ep] = byteArray[interval][ep + this.numEPs];
                this.receivedExternalMsgCount[interval][ep] = externalMessageArray[interval][ep + this.numEPs];
                this.receivedExternalByteCount[interval][ep] = externalByteArray[interval][ep + this.numEPs];
            }
        }
        if (this.startFlag) {
            block2: for (int ep = 0; ep < this.numEPs; ++ep) {
                for (int interval = 0; interval < this.numIntervals; ++interval) {
                    if (!(messageArray[interval][ep] > 0.0) && !(messageArray[interval][ep + this.numEPs] > 0.0)) continue;
                    this.existsArray[0][ep] = true;
                    this.stateArray[0][ep] = true;
                    continue block2;
                }
            }
            this.startFlag = false;
        }
    }

    public void applyDialogColors() {
        this.setOutputGraphData();
        this.repaint();
    }

    void setOutputGraphData() {
        int outSize = 0;
        for (int ep = 0; ep < this.numEPs; ++ep) {
            if (!this.stateArray[0][ep]) continue;
            ++outSize;
        }
        if (outSize != 0) {
            this.sentMsgOutput = new double[this.numIntervals][outSize];
            this.sentByteOutput = new double[this.numIntervals][outSize];
            this.receivedMsgOutput = new double[this.numIntervals][outSize];
            this.receivedByteOutput = new double[this.numIntervals][outSize];
            this.receivedExternalMsgOutput = new double[this.numIntervals][outSize];
            this.receivedExternalByteOutput = new double[this.numIntervals][outSize];
            this.outColors = new Color[outSize];
            int count = 0;
            for (int ep = 0; ep < this.numEPs; ++ep) {
                if (!this.stateArray[0][ep]) continue;
                for (int interval = 0; interval < this.numIntervals; ++interval) {
                    this.sentMsgOutput[interval][count] = this.sentMsgCount[interval][ep];
                    this.sentByteOutput[interval][count] = this.sentByteCount[interval][ep];
                    this.receivedMsgOutput[interval][count] = this.receivedMsgCount[interval][ep];
                    this.receivedByteOutput[interval][count] = this.receivedByteCount[interval][ep];
                    this.receivedExternalMsgOutput[interval][count] = this.receivedExternalMsgCount[interval][ep];
                    this.receivedExternalByteOutput[interval][count] = this.receivedExternalByteCount[interval][ep];
                }
                this.outColors[count++] = this.colorArray[0][ep];
            }
        }
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0 || this.currentArrayName == null) {
            return null;
        }
        int count = 0;
        String epName = "";
        String epClassName = "";
        for (int ep = 0; ep < this.numEPs; ++ep) {
            if (!this.stateArray[0][ep] || count++ != yVal) continue;
            epName = MainWindow.runObject[myRun].getEntryNameByIndex(ep);
            epClassName = MainWindow.runObject[myRun].getEntryChareNameByIndex(ep);
            break;
        }
        String[] rString = new String[4];
        rString[0] = "Time Interval: " + U.t((long)(xVal + this.startInterval) * this.intervalSize) + " to " + U.t((long)(xVal + this.startInterval + 1) * this.intervalSize);
        if (this.currentArrayName.equals("sentMsgCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Count = " + this._format.format(this.sentMsgOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("sentByteCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Bytes = " + this._format.format(this.sentByteOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedMsgCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Count = " + this._format.format(this.receivedMsgOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedByteCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Bytes = " + this._format.format(this.receivedByteOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedExternalMsgCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Count = " + this._format.format(this.receivedExternalMsgOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedExternalByteCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Bytes = " + this._format.format(this.receivedExternalByteOutput[xVal][yVal]);
        }
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton b = (JButton)e.getSource();
            if (b == this.epSelection) {
                if (this.entryDialog == null) {
                    this.entryDialog = new EntrySelectionDialog(this, this, this.typeLabelNames, this.stateArray, this.colorArray, this.existsArray, this.entryNames);
                }
                this.entryDialog.showDialog();
                this.setOutputGraphData();
                Checkbox cb = this.cbg.getSelectedCheckbox();
                this.setCheckboxData(cb);
            } else if (b == this.setRanges) {
                this.showDialog();
            } else if (b == this.saveColors) {
                MainWindow.runObject[myRun].saveColors();
            } else if (b == this.loadColors) {
                try {
                    ColorManager.loadActivityColors(0, this.colorArray[0]);
                    this.setOutputGraphData();
                }
                catch (IOException exception) {
                    System.err.println("Failed to load colors!!");
                }
            }
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void repaint() {
        super.refreshGraph();
    }

    private void setPopupText(String input) {
        this.currentArrayName = input;
    }
}

