/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.io.File;
import java.io.FilenameFilter;

public class ProjectionsFileMgr {
    private File[] stsFiles_ = null;
    private File[][] logFiles_ = null;
    String base_ = null;
    String extention_ = null;

    public ProjectionsFileMgr(String[] fileNames) {
        this.stsFiles_ = new File[fileNames.length];
        this.logFiles_ = new File[fileNames.length][];
        for (int i = 0; i < fileNames.length; ++i) {
            this.stsFiles_[i] = new File(fileNames[i]);
            this.logFiles_[i] = this.findFiles(fileNames[i]);
        }
    }

    private File[] findFiles(String stsPathName) {
        int lastDotIndex;
        File stsFile = new File(stsPathName);
        File stsDir = new File(stsFile.getParent());
        if (!stsDir.isDirectory()) {
            return null;
        }
        String stsFileName = stsFile.getName();
        int nextDotIndex = stsFileName.lastIndexOf(".", (lastDotIndex = stsFileName.lastIndexOf(".")) - 1);
        if (nextDotIndex != -1) {
            this.base_ = stsFileName.substring(0, nextDotIndex);
            this.extention_ = stsPathName.endsWith(".sts") ? stsFileName.substring(nextDotIndex + 1, lastDotIndex) : stsFileName.substring(lastDotIndex + 1, stsFileName.length());
        } else {
            this.base_ = stsFileName.substring(0, lastDotIndex - 1);
            this.extention_ = ".log";
        }
        String[] logFiles = stsDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(ProjectionsFileMgr.this.base_) && name.endsWith(ProjectionsFileMgr.this.extention_) && name.indexOf(".sts") == -1;
            }
        });
        File[] returnVal = new File[logFiles.length];
        for (int i = 0; i < returnVal.length; ++i) {
            returnVal[i] = new File(stsDir, logFiles[i]);
        }
        return returnVal;
    }
}

