/*
 * Decompiled with CFR 0.152.
 */
package charm.liveViz;

import charm.liveViz.CcsImagePanel;
import charm.util.Toolbar;
import charm.util.Vector3d;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Controller3d
implements MouseListener,
MouseMotionListener {
    CcsImagePanel master;
    Toolbar tools;
    int wid;
    int ht;
    double delZ;
    Vector3d o;
    Vector3d x;
    Vector3d y;
    Vector3d z;
    double u2pix;
    double pix2u;
    int rtsoX;
    int rtsoY;
    private static final int TOOL_SCROLL = 0;
    private static final int TOOL_ZOOM = 1;
    private static final int TOOL_ROTATE = 2;
    private static final int TOOL_SLICE = 3;
    private static final int TOOL_INFO = 4;
    private int lastX = -1;
    private int lastY = -1;
    private double starting_pix2u;
    private Vector3d starting_o;
    private boolean inDrag;

    public void updateSize(int n, int n2) {
        this.rtsoX += (n - this.wid) / 2;
        this.rtsoY += (n2 - this.ht) / 2;
        this.wid = n;
        this.ht = n2;
    }

    private void rebuildAxes() {
        this.x = this.x.normalize();
        this.z = this.x.cross(this.y).normalize();
        this.y = this.z.cross(this.x).normalize();
    }

    public Controller3d(CcsImagePanel ccsImagePanel, Toolbar toolbar, Vector3d vector3d, Vector3d vector3d2, int n, int n2) {
        this.master = ccsImagePanel;
        this.master.addMouseListener(this);
        this.master.addMouseMotionListener(this);
        this.tools = toolbar;
        if (n <= 0) {
            n = 200;
        }
        if (n2 <= 0) {
            n2 = 150;
        }
        this.wid = n;
        this.ht = n2;
        this.o = vector3d.plus(vector3d2).scaleBy(0.5);
        int n3 = this.wid;
        if (n3 > this.ht) {
            n3 = this.ht;
        }
        Vector3d vector3d3 = vector3d2.minus(vector3d);
        this.pix2u = vector3d3.x / (double)n3;
        this.u2pix = 1.0 / this.pix2u;
        this.x = new Vector3d(1.0, 0.0, 0.0);
        this.y = new Vector3d(0.0, 1.0, 0.0);
        this.rebuildAxes();
        this.rtsoX = this.wid / 2;
        this.rtsoY = this.ht / 2;
        this.delZ = vector3d3.z;
    }

    private void update() {
        this.master.requestImage();
        this.master.repaint(200L);
    }

    private Vector3d universe(double d, double d2) {
        return this.o.plus(this.x.scaleBy((d - (double)this.rtsoX) * this.pix2u).plus(this.y.scaleBy(-(d2 - (double)this.rtsoY) * this.pix2u)));
    }

    public ImageRequest3d get3dRequest() {
        ImageRequest3d imageRequest3d = new ImageRequest3d();
        imageRequest3d.wid = this.wid;
        imageRequest3d.ht = this.ht;
        imageRequest3d.x = this.x.scaleBy(this.u2pix);
        imageRequest3d.y = this.y.scaleBy(-this.u2pix);
        imageRequest3d.z = this.z;
        imageRequest3d.o = this.universe(0.0, 0.0);
        imageRequest3d.minZ = -this.delZ;
        imageRequest3d.maxZ = this.delZ;
        return imageRequest3d;
    }

    private void drawAxis(Graphics graphics, Dimension dimension, Vector3d vector3d, String string) {
        double d = 15.0;
        double d2 = 7.0;
        Vector3d vector3d2 = new Vector3d(vector3d.dot(this.x), -vector3d.dot(this.y), 0.0);
        Vector3d vector3d3 = vector3d2.scaleBy(d);
        Vector3d vector3d4 = vector3d2.scaleBy(d + d2);
        Font font = graphics.getFont();
        int n = (int)(2.0 * d);
        int n2 = (int)((double)dimension.height - 2.0 * d);
        graphics.drawLine(n, n2, (int)((double)n + vector3d3.x), (int)((double)n2 + vector3d3.y));
        graphics.drawString(string, (int)((double)n + vector3d4.x), (int)((double)n2 + vector3d4.y));
    }

    public void paint(Graphics graphics, Dimension dimension) {
        graphics.setColor(Color.red);
        this.drawAxis(graphics, dimension, new Vector3d(1.0, 0.0, 0.0), "X");
        graphics.setColor(Color.green);
        this.drawAxis(graphics, dimension, new Vector3d(0.0, 1.0, 0.0), "Y");
        graphics.setColor(new Color(70, 70, 255));
        this.drawAxis(graphics, dimension, new Vector3d(0.0, 0.0, 1.0), "Z");
    }

    private void pointInfo(int n, int n2) {
        Vector3d vector3d = this.universe(n, n2);
        System.out.println("Clicked at " + vector3d);
    }

    private void updatePoint(MouseEvent mouseEvent, boolean bl) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (bl) {
            this.o = this.universe(n, n2);
            this.rtsoX = n;
            this.rtsoY = n2;
            this.starting_o = this.o;
            this.starting_pix2u = this.pix2u;
            if (this.tools.getTool() == 4) {
                this.pointInfo(n, n2);
            }
        } else if (this.lastX != n || this.lastY != n2) {
            switch (this.tools.getTool()) {
                case 0: {
                    this.rtsoX = n;
                    this.rtsoY = n2;
                    this.update();
                    break;
                }
                case 1: {
                    double d = 0.02;
                    int n3 = n - this.rtsoX + (n2 - this.rtsoY);
                    this.pix2u = this.starting_pix2u / Math.pow(2.0, (double)n3 * d);
                    this.u2pix = 1.0 / this.pix2u;
                    this.update();
                    break;
                }
                case 2: {
                    double d = 0.02;
                    double d2 = n - this.lastX;
                    double d3 = -(n2 - this.lastY);
                    this.x = this.x.plus(this.z.scaleBy(-d2 * d));
                    this.y = this.y.plus(this.z.scaleBy(-d3 * d));
                    this.rebuildAxes();
                    this.update();
                    break;
                }
                case 3: {
                    int n4 = n - this.rtsoX + (n2 - this.rtsoY);
                    this.o = this.starting_o.plus(this.z.scaleBy((double)n4 * this.pix2u));
                    this.update();
                    break;
                }
                case 4: {
                    this.pointInfo(n, n2);
                }
            }
        }
        this.lastX = n;
        this.lastY = n2;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.inDrag = true;
        this.updatePoint(mouseEvent, true);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updatePoint(mouseEvent, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updatePoint(mouseEvent, false);
        this.inDrag = false;
        this.lastX = -1;
        this.lastY = -1;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static class ImageRequest3d {
        public int wid;
        public int ht;
        public Vector3d x;
        public Vector3d y;
        public Vector3d z;
        public Vector3d o;
        public double minZ;
        public double maxZ;
    }
}

