/*
 * Decompiled with CFR 0.152.
 */
package projections.ccs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Random;

public class CcsServer {
    private Request lastRequest;
    private MessageDigest SHA;
    private final int SHA_len = 20;
    private boolean isAuth = false;
    private byte[] key;
    private int level;
    private Random rand;
    protected int clientID;
    protected int clientSalt;
    protected InetAddress hostIP;
    protected int hostPort;
    protected int numNodes;
    protected int numPes;
    protected int[] nodeFirst;
    protected int[] nodeSize;
    protected static boolean printDebug = false;

    public CcsServer(InetAddress address, int port, byte[] secretKey) throws IOException {
        this.connect(address, port, secretKey);
    }

    public CcsServer(String host, int port, byte[] secretKey) throws IOException, UnknownHostException {
        InetAddress ip = InetAddress.getByName(host);
        this.connect(ip, port, secretKey);
    }

    public CcsServer(InetAddress address, int port) throws IOException {
        this(address, port, null);
    }

    public CcsServer(String host, int port) throws IOException, UnknownHostException {
        this(host, port, null);
    }

    public CcsServer(String init, byte[] secretKey) throws IOException, NumberFormatException {
        int firstEq = init.indexOf("=");
        int secondEq = init.indexOf("=", firstEq + 1);
        String ip_str = init.substring(firstEq + 1, init.indexOf(",")).trim();
        String port_str = init.substring(secondEq + 1, init.indexOf("$")).trim();
        long ip_int = Long.parseLong(ip_str);
        int port = Integer.parseInt(port_str);
        if (ip_int < 0L) {
            ip_int += 0x100000000L;
        }
        String ip_dot = "";
        for (int b = 3; b >= 0; --b) {
            Long l = new Long(0xFFL & ip_int >> 8 * b);
            ip_dot = ip_dot + l.toString();
            if (b <= 0) continue;
            ip_dot = ip_dot + ".";
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(ip_dot);
        }
        catch (UnknownHostException e) {
            throw new NumberFormatException(e.toString());
        }
        this.connect(ip, port, secretKey);
    }

    public Request sendRequest(String handlerName, int destPe) throws IOException {
        return this.sendRequest(handlerName, destPe, null);
    }

    public Request sendRequest(String handlerName, int destPe, byte[] data) throws IOException {
        Request r;
        CcsServer.debug("  Connecting for request '" + handlerName + "'");
        Socket sock = new Socket(this.hostIP, this.hostPort);
        CcsServer.debug("  Connected.  Sending header");
        DataOutputStream o = new DataOutputStream(sock.getOutputStream());
        int dataLen = 0;
        if (data != null) {
            dataLen = data.length;
        }
        int handlerOff = 8;
        int handlerMAX = 32;
        int headerLen = handlerOff + handlerMAX;
        byte[] header = new byte[headerLen];
        CcsServer.writeInt(header, 0, dataLen);
        CcsServer.writeInt(header, 4, destPe);
        CcsServer.writeString(header, 8, handlerMAX, handlerName);
        int salt = 0;
        if (this.isAuth) {
            CcsServer.debug("  Sending authentication for level " + this.level);
            o.writeInt(Integer.MIN_VALUE | this.level);
            salt = this.rand.nextInt();
            o.writeInt(this.clientID);
            o.writeInt(salt);
            o.write(this.SHA_makeHash(this.key, this.clientSalt++, header));
        }
        o.write(header, 0, headerLen);
        CcsServer.debug("  Header sent.  Sending " + dataLen + " bytes of request data");
        if (data != null) {
            o.write(data);
        }
        o.flush();
        CcsServer.debug("  Request sent");
        this.lastRequest = r = new Request(sock, salt);
        return r;
    }

    public byte[] recvResponse() throws IOException {
        return this.recvResponse(this.lastRequest);
    }

    public byte[] recvResponse(Request r) throws IOException {
        CcsServer.debug("  Waiting for response");
        DataInputStream i = new DataInputStream(r.sock.getInputStream());
        if (this.isAuth) {
            byte[] hash = new byte[20];
            i.readFully(hash);
            if (!this.SHA_checkHash(this.key, r.salt, null, hash)) {
                CcsServer.abort("Server's key does not match ours (during response)!");
            }
        }
        int replyLen = i.readInt();
        CcsServer.debug("  Response will be " + replyLen + " bytes");
        byte[] reply = new byte[replyLen];
        i.readFully(reply);
        CcsServer.debug("  Got entire response");
        r.sock.close();
        r.sock = null;
        return reply;
    }

    public boolean hasResponse(Request r) throws IOException {
        return r.sock.getInputStream().available() > 0;
    }

    public void close(Request r) {
        if (r.sock != null) {
            try {
                r.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            r.sock = null;
        }
    }

    public void close() {
        this.close(this.lastRequest);
        this.lastRequest = null;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumPes() {
        return this.numPes;
    }

    public int getNodeFirst(int node) {
        return this.nodeFirst[node];
    }

    public int getNodeSize(int node) {
        return this.nodeSize[node];
    }

    public static final int readInt(byte[] src, int srcStart) {
        return ((0xFF & src[srcStart + 0]) << 24) + ((0xFF & src[srcStart + 1]) << 16) + ((0xFF & src[srcStart + 2]) << 8) + ((0xFF & src[srcStart + 3]) << 0);
    }

    public static final float readFloat(byte[] src, int srcStart) {
        return Float.intBitsToFloat(CcsServer.readInt(src, srcStart));
    }

    public static final long readLong(byte[] src, int srcStart) {
        return ((0xFFL & (long)src[srcStart + 0]) << 56) + ((0xFFL & (long)src[srcStart + 1]) << 48) + ((0xFFL & (long)src[srcStart + 2]) << 40) + ((0xFFL & (long)src[srcStart + 3]) << 32) + ((0xFFL & (long)src[srcStart + 4]) << 24) + ((0xFFL & (long)src[srcStart + 5]) << 16) + ((0xFFL & (long)src[srcStart + 6]) << 8) + ((0xFFL & (long)src[srcStart + 7]) << 0);
    }

    public static final double readDouble(byte[] src, int srcStart) {
        return Double.longBitsToDouble(CcsServer.readLong(src, srcStart));
    }

    public static final void writeInt(byte[] dest, int destStart, int val) {
        dest[destStart + 0] = (byte)(val >>> 24);
        dest[destStart + 1] = (byte)(val >>> 16);
        dest[destStart + 2] = (byte)(val >>> 8);
        dest[destStart + 3] = (byte)(val >>> 0);
    }

    public static final void writeFloat(byte[] dest, int destStart, float val) {
        CcsServer.writeInt(dest, destStart, Float.floatToRawIntBits(val));
    }

    public static final void writeLong(byte[] dest, int destStart, long val) {
        dest[destStart + 0] = (byte)(val >>> 56);
        dest[destStart + 1] = (byte)(val >>> 48);
        dest[destStart + 2] = (byte)(val >>> 40);
        dest[destStart + 3] = (byte)(val >>> 32);
        dest[destStart + 4] = (byte)(val >>> 24);
        dest[destStart + 5] = (byte)(val >>> 16);
        dest[destStart + 6] = (byte)(val >>> 8);
        dest[destStart + 7] = (byte)(val >>> 0);
    }

    public static final void writeDouble(byte[] dest, int destStart, double val) {
        CcsServer.writeLong(dest, destStart, Double.doubleToRawLongBits(val));
    }

    public static final void writeBytes(byte[] dest, int destStart, int len, byte[] src) {
        int i;
        int copyLen = len;
        if (copyLen > src.length) {
            copyLen = src.length;
        }
        for (i = 0; i < copyLen; ++i) {
            dest[destStart + i] = src[i];
        }
        for (i = copyLen; i < len; ++i) {
            dest[destStart + i] = 0;
        }
    }

    public static final void writeString(byte[] dest, int destStart, int len, String src) {
        int i;
        int copyLen = len;
        if (copyLen > src.length()) {
            copyLen = src.length();
        }
        for (i = 0; i < copyLen; ++i) {
            dest[destStart + i] = (byte)src.charAt(i);
        }
        for (i = copyLen; i < len; ++i) {
            dest[destStart + i] = 0;
        }
    }

    private final byte[] SHA_makeMessage() {
        return new byte[52];
    }

    private byte[] SHA_digestMessage(byte[] message2) {
        this.SHA.reset();
        this.SHA.update(message2);
        return this.SHA.digest();
    }

    private byte[] SHA_makeHash(byte[] secretKey, int salt, byte[] header) {
        byte[] message2 = this.SHA_makeMessage();
        CcsServer.writeBytes(message2, 0, 16, secretKey);
        CcsServer.writeInt(message2, 16, salt);
        if (header != null) {
            CcsServer.writeBytes(message2, 20, 16, header);
        }
        byte[] digest = this.SHA_digestMessage(message2);
        return digest;
    }

    private boolean SHA_checkHash(byte[] secretKey, int salt, byte[] header, byte[] hash) {
        byte[] h2 = this.SHA_makeHash(secretKey, salt, header);
        for (int i = 0; i < 20; ++i) {
            if (hash[i] == h2[i]) continue;
            return false;
        }
        return true;
    }

    protected void authenticate(byte[] secretKey) throws IOException {
        int i;
        this.isAuth = true;
        long seed = System.currentTimeMillis();
        this.key = new byte[16];
        for (i = 0; i < secretKey.length; ++i) {
            this.key[i] = secretKey[i];
            seed ^= (long)(this.key[i] << i);
        }
        this.rand = new Random(seed);
        i = 0;
        while ((long)i < (long)(10 + secretKey.length) + (seed & 0xFL)) {
            this.rand.nextInt();
            ++i;
        }
        try {
            this.SHA = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            CcsServer.abort("Couldn't load SHA hash code!");
        }
        this.level = 0;
        CcsServer.debug("  Connecting for authentication");
        Socket s = new Socket(this.hostIP, this.hostPort);
        CcsServer.debug("  Connected.  Sending request");
        DataOutputStream o = new DataOutputStream(s.getOutputStream());
        DataInputStream i2 = new DataInputStream(s.getInputStream());
        int s1 = this.rand.nextInt();
        int s2 = 0;
        try {
            o.writeInt(0x80000100 | this.level);
            o.writeInt(s1);
            s2 = i2.readInt();
        }
        catch (IOException e) {
            CcsServer.abort("Server does not use authentication!");
        }
        byte[] s1hash = new byte[20];
        try {
            o.write(this.SHA_makeHash(this.key, s2, null));
            i2.readFully(s1hash);
        }
        catch (EOFException e) {
            CcsServer.abort("Server does not accept our key!");
        }
        if (!this.SHA_checkHash(this.key, s1, null, s1hash)) {
            CcsServer.abort("Server's key does not match ours (during initial check)!");
        }
        this.clientID = i2.readInt();
        this.clientSalt = i2.readInt();
        CcsServer.debug("  I am client " + this.clientID + ".  My first salt is " + this.clientSalt + ".");
        s.close();
        CcsServer.debug("  Authentication complete");
    }

    protected void connect(InetAddress address, int port, byte[] secretKey) throws IOException {
        this.hostIP = address;
        this.hostPort = port;
        CcsServer.debug("Connecting...");
        if (secretKey != null) {
            this.authenticate(secretKey);
        }
        this.sendRequest("ccs_getinfo", 0);
        CcsServer.debug("Connected.  Getting machine info.");
        DataInputStream mach_info = new DataInputStream(new ByteArrayInputStream(this.recvResponse()));
        CcsServer.debug("Parsing machine info");
        this.numNodes = mach_info.readInt();
        this.nodeFirst = new int[this.numNodes];
        this.nodeSize = new int[this.numNodes];
        this.numPes = 0;
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodeFirst[i] = this.numPes;
            this.nodeSize[i] = mach_info.readInt();
            this.numPes += this.nodeSize[i];
        }
    }

    protected static void debug(String s) {
        if (printDebug) {
            System.out.println("CcsServer: " + s);
        }
    }

    protected static void abort(String s) {
        System.out.println("CcsServer FATAL ERROR: " + s);
        System.exit(1);
    }

    public static byte[] parseKey(String s) {
        byte[] k = new byte[(s.length() + 1) / 2];
        for (int i = 0; i < s.length(); ++i) {
            int shift = 16;
            if (i % 2 == 1) {
                shift = 1;
            }
            int n = i / 2;
            k[n] = (byte)(k[n] + (byte)(shift * Character.digit(s.charAt(i), 16)));
        }
        return k;
    }

    public static CcsServer create(String[] args, boolean withDebug) {
        CcsServer c = null;
        if (args.length < 2) {
            System.out.println("Usage: CcsServer <server DNS name or IP> <port> [ <authentication key>]");
        } else {
            printDebug = withDebug;
            String host = args[0];
            int port = 0;
            try {
                port = Integer.parseInt(args[1]);
            }
            catch (Exception E) {
                CcsServer.abort("Couldn't parse port number");
            }
            byte[] key = null;
            if (args.length > 2) {
                key = CcsServer.parseKey(args[2]);
            }
            try {
                c = new CcsServer(host, port, key);
            }
            catch (Exception E) {
                CcsServer.abort("Error connecting to host:" + E);
            }
        }
        return c;
    }

    public static void main(String[] args) {
        CcsServer c = CcsServer.create(args, true);
        System.out.println("The CCS server has " + c.getNumPes() + " processors.");
    }

    public static class Request {
        protected Socket sock;
        protected int salt;

        protected Request(Socket sock_, int salt_) {
            this.sock = sock_;
            this.salt = salt_;
        }
    }
}

