/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PAbstract;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class PDisplayStyle {
    private Graphics g;
    private Font font;
    private FontMetrics fm;
    private int wid;
    private int ht;
    private int indent;
    private int indentDel;
    private int pitch;
    private int spaceWidth;
    private boolean measureMode;
    private int x;
    private int y;
    public static final int drawStyle_onerow = 0;
    public static final int drawStyle_multirow = 1;

    private void init(int n) {
        this.font = new Font("Serif", 0, 12);
        this.g.setFont(this.font);
        this.fm = this.g.getFontMetrics();
        this.wid = n;
        this.ht = 0;
        this.pitch = this.fm.getHeight();
        this.spaceWidth = this.fm.stringWidth(" ");
        this.indentDel = 2 * this.pitch;
        this.x = this.indent = 10;
        this.y = this.pitch;
        this.measureMode = false;
    }

    public PDisplayStyle(Graphics graphics, int n, boolean bl) {
        this.g = graphics;
        this.init(n);
        this.g = null;
    }

    public PDisplayStyle(Graphics graphics, int n) {
        this.g = graphics;
        this.init(n);
        this.g.setFont(this.font);
    }

    public int getRowHeight() {
        return this.pitch;
    }

    public int getWidth(String string) {
        return this.fm.stringWidth(string) + this.spaceWidth;
    }

    private int measureWidth(PAbstract pAbstract) {
        this.measureMode = true;
        int n = this.x;
        int n2 = this.y;
        this.x = 0;
        this.y = 0;
        pAbstract.draw(this, 0);
        int n3 = this.x;
        this.x = n;
        this.y = n2;
        this.measureMode = false;
        return n3;
    }

    public int getDrawStyle(PAbstract pAbstract) {
        int n = 0;
        if (this.measureMode) {
            return n;
        }
        int n2 = this.measureWidth(pAbstract);
        if (this.x + n2 >= this.wid) {
            if (this.x != this.indent) {
                this.newRow();
            }
            if (this.x + n2 >= this.wid) {
                n = 1;
            }
        }
        return n;
    }

    public boolean drawString(String string) {
        if (this.x >= this.wid) {
            return false;
        }
        int n = this.getWidth(string);
        if (this.x + n >= this.wid) {
            if (!this.measureMode && this.g != null) {
                this.g.drawString("...", this.x, this.y);
            }
            this.x = this.wid;
            return false;
        }
        if (!this.measureMode && this.g != null) {
            this.g.drawString(string, this.x, this.y);
        }
        this.x += n;
        return true;
    }

    public void newRow() {
        this.y += this.pitch;
        this.x = this.indent;
    }

    public void addIndent(int n) {
        this.indent += this.indentDel * n;
        this.newRow();
    }

    public int getHeight() {
        return this.y + this.pitch;
    }
}

