/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.PeSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Processor
implements Comparable {
    public static final int RUNNING = 1;
    public static final int FROZEN = 2;
    public static final int REQUESTED_FREEZE = 3;
    public static final int DEAD = 4;
    int status;
    int id;
    Set sets;

    public Processor(int i) {
        this.id = i;
        this.status = 2;
        this.sets = new HashSet();
    }

    public void addToSet(PeSet p) {
        this.sets.add(p);
    }

    public int compareTo(Object o) {
        Processor p = (Processor)o;
        return this.id - p.id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isFrozen() {
        return this.status == 2;
    }

    public boolean isRunning() {
        return this.status == 1;
    }

    public boolean isFreezing() {
        return this.status == 3;
    }

    public boolean isDead() {
        return this.status == 4;
    }

    public void setFrozen() {
        if (this.status != 4) {
            this.status = 2;
            Iterator iter = this.sets.iterator();
            while (iter.hasNext()) {
                ((PeSet)iter.next()).setFrozen();
            }
        }
    }

    public void setRunning() {
        this.status = 1;
        Iterator iter = this.sets.iterator();
        while (iter.hasNext()) {
            ((PeSet)iter.next()).setRunning();
        }
    }

    public void setFreezing() {
        this.status = 3;
    }

    public void setDead() {
        for (PeSet p : this.sets) {
            if (!this.isFrozen()) {
                p.setFrozen();
            }
            p.setDead();
        }
        this.status = 4;
    }

    public String toString() {
        return "" + this.id + "(" + (this.status == 1 ? "R" : (this.status == 4 ? "D" : (this.status == 2 ? "F" : "f"))) + ")";
    }
}

