/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.inspect.Inspector;
import charm.debug.pdata.ChareInfo;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpPList;
import charm.debug.pdata.GenericPList;
import charm.debug.pdata.MsgTypePList;
import java.nio.ByteBuffer;

public class CharePList
extends GenericPList {
    EpPList epList;
    MsgTypePList msgList;
    ChareTypePList chareList;

    public ChareInfo elementAt(int i) {
        if (i >= this.data.size()) {
            return null;
        }
        return (ChareInfo)this.data.elementAt(i);
    }

    @Override
    public boolean needRefresh() {
        return true;
    }

    public void setLookups(EpPList ep, MsgTypePList msg, ChareTypePList chare) {
        this.epList = ep;
        this.msgList = msg;
        this.chareList = chare;
    }

    @Override
    public void load(PList list) {
        this.data.clear();
        if (list == null) {
            System.out.println("list is null!");
        }
        for (PAbstract cur = list.elementAt(0); cur != null; cur = cur.getNext()) {
            PList lcur = (PList)cur;
            String name = ((PString)lcur.elementNamed("name")).getString();
            PAbstract info = lcur.elementNamed("id");
            byte[] id = null;
            if (info != null) {
                id = ((PString)info).getBytes();
            }
            String type = null;
            info = lcur.elementNamed("type");
            if (info != null) {
                type = ((PString)info).getString();
            }
            ByteBuffer buf = null;
            info = lcur.elementNamed("value");
            if (info != null) {
                buf = ByteBuffer.wrap(((PString)info).getBytes()).order(Inspector.getByteOrder());
            }
            int group = -1;
            info = lcur.elementNamed("group");
            if (info != null) {
                group = ((PNative)info).getIntValue(0);
            }
            this.data.add(new ChareInfo(name, id, type != null ? Inspector.getTypeCreate(type) : null, buf, group));
        }
    }
}

