/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT_Mixed;

public abstract class ComplexDoubleFFT {
    int n;

    public ComplexDoubleFFT(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The transform length must be >=0 : " + n);
        }
        this.n = n;
    }

    public ComplexDoubleFFT getInstance(int n) {
        return new ComplexDoubleFFT_Mixed(n);
    }

    protected void checkData(double[] data, int i0, int stride) {
        if (i0 < 0) {
            throw new IllegalArgumentException("The offset must be >=0 : " + i0);
        }
        if (stride < 2) {
            throw new IllegalArgumentException("The stride must be >=2 : " + stride);
        }
        if (i0 + stride * (this.n - 1) + 2 > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.n + ":" + "i0=" + i0 + " stride=" + stride + " data.length=" + data.length);
        }
    }

    public void transform(double[] data) {
        this.transform(data, 0, 2);
    }

    public abstract void transform(double[] var1, int var2, int var3);

    public double[] toWraparoundOrder(double[] data) {
        return data;
    }

    public double[] toWraparoundOrder(double[] data, int i0, int stride) {
        if (i0 == 0 && stride == 2) {
            return data;
        }
        double[] newdata = new double[2 * this.n];
        for (int i = 0; i < this.n; ++i) {
            newdata[2 * i] = data[i0 + stride * i];
            newdata[2 * i + 1] = data[i0 + stride * i + 1];
        }
        return newdata;
    }

    public void backtransform(double[] data) {
        this.backtransform(data, 0, 2);
    }

    public abstract void backtransform(double[] var1, int var2, int var3);

    public double normalization() {
        return 1.0 / (double)this.n;
    }

    public void inverse(double[] data) {
        this.inverse(data, 0, 2);
    }

    public void inverse(double[] data, int i0, int stride) {
        this.backtransform(data, i0, stride);
        double norm = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            int n = i0 + stride * i;
            data[n] = data[n] * norm;
            int n2 = i0 + stride * i + 1;
            data[n2] = data[n2] * norm;
        }
    }
}

