/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT_Mixed;

public abstract class ComplexFloatFFT {
    int n;

    public ComplexFloatFFT(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The transform length must be >=0 : " + n);
        }
        this.n = n;
    }

    public ComplexFloatFFT getInstance(int n) {
        return new ComplexFloatFFT_Mixed(n);
    }

    protected void checkData(float[] data, int i0, int stride) {
        if (i0 < 0) {
            throw new IllegalArgumentException("The offset must be >=0 : " + i0);
        }
        if (stride < 2) {
            throw new IllegalArgumentException("The stride must be >=2 : " + stride);
        }
        if (i0 + stride * (this.n - 1) + 2 > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.n + ":" + "i0=" + i0 + " stride=" + stride + " data.length=" + data.length);
        }
    }

    public void transform(float[] data) {
        this.transform(data, 0, 2);
    }

    public float[] toWraparoundOrder(float[] data) {
        return data;
    }

    public float[] toWraparoundOrder(float[] data, int i0, int stride) {
        if (i0 == 0 && stride == 2) {
            return data;
        }
        float[] newdata = new float[2 * this.n];
        for (int i = 0; i < this.n; ++i) {
            newdata[2 * i] = data[i0 + stride * i];
            newdata[2 * i + 1] = data[i0 + stride * i + 1];
        }
        return newdata;
    }

    public abstract void transform(float[] var1, int var2, int var3);

    public void backtransform(float[] data) {
        this.backtransform(data, 0, 2);
    }

    public abstract void backtransform(float[] var1, int var2, int var3);

    public float normalization() {
        return 1.0f / (float)this.n;
    }

    public void inverse(float[] data) {
        this.inverse(data, 0, 2);
    }

    public void inverse(float[] data, int i0, int stride) {
        this.backtransform(data, i0, stride);
        float norm = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            int n = i0 + stride * i;
            data[n] = data[n] * norm;
            int n2 = i0 + stride * i + 1;
            data[n2] = data[n2] * norm;
        }
    }
}

