/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.ComplexDoubleFFT_Mixed;
import jnt.FFT.RealDoubleFFT;

public class RealDoubleFFT_Even
extends RealDoubleFFT {
    ComplexDoubleFFT fft;

    public RealDoubleFFT_Even(int n) {
        super(n);
        if (n % 2 != 0) {
            throw new IllegalArgumentException(n + " is not even");
        }
        this.fft = new ComplexDoubleFFT_Mixed(n / 2);
    }

    public void transform(double[] data) {
        this.fft.transform(data);
        this.shuffle(data, 1);
    }

    public double[] toWraparoundOrder(double[] data) {
        double[] newdata = new double[2 * this.n];
        int nh = this.n / 2;
        newdata[0] = data[0];
        newdata[1] = 0.0;
        newdata[this.n] = data[1];
        newdata[this.n + 1] = 0.0;
        for (int i = 1; i < nh; ++i) {
            newdata[2 * i] = data[2 * i];
            newdata[2 * i + 1] = data[2 * i + 1];
            newdata[2 * (this.n - i)] = data[2 * i];
            newdata[2 * (this.n - i) + 1] = -data[2 * i + 1];
        }
        return newdata;
    }

    public double[] toWraparoundOrder(double[] data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public void backtransform(double[] data) {
        this.shuffle(data, -1);
        this.fft.backtransform(data);
    }

    private void shuffle(double[] data, int sign) {
        int nh = this.n / 2;
        int nq = this.n / 4;
        double c1 = 0.5;
        double c2 = -0.5 * (double)sign;
        double theta = (double)sign * Math.PI / (double)nh;
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = -Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        for (int i = 1; i < nq; ++i) {
            int i1 = 2 * i;
            int i3 = this.n - i1;
            double h1r = c1 * (data[i1] + data[i3]);
            double h1i = c1 * (data[i1 + 1] - data[i3 + 1]);
            double h2r = -c2 * (data[i1 + 1] + data[i3 + 1]);
            double h2i = c2 * (data[i1] - data[i3]);
            data[i1] = h1r + wr * h2r - wi * h2i;
            data[i1 + 1] = h1i + wr * h2i + wi * h2r;
            data[i3] = h1r - wr * h2r + wi * h2i;
            data[i3 + 1] = -h1i + wr * h2i + wi * h2r;
            wtemp = wr;
            wr += wtemp * wpr - wi * wpi;
            wi += wtemp * wpi + wi * wpr;
        }
        double d0 = data[0];
        if (sign == 1) {
            data[0] = d0 + data[1];
            data[1] = d0 - data[1];
        } else {
            data[0] = c1 * (d0 + data[1]);
            data[1] = c1 * (d0 - data[1]);
        }
        if (this.n % 4 == 0) {
            int n = nh + 1;
            data[n] = data[n] * -1.0;
        }
    }

    public void transform(double[] data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public void backtransform(double[] data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public void inverse(double[] data, int i0, int stride) {
        throw new Error("Not Implemented!");
    }

    public double normalization() {
        return 2.0 / (double)this.n;
    }

    public void inverse(double[] data) {
        this.backtransform(data);
        double norm = this.normalization();
        int i = 0;
        while (i < this.n) {
            int n = i++;
            data[n] = data[n] * norm;
        }
    }
}

