/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import org.jfree.util.Log;

public class LogContext {
    private String contextPrefix;

    public LogContext(String contextPrefix) {
        this.contextPrefix = contextPrefix;
    }

    public boolean isDebugEnabled() {
        return Log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return Log.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return Log.isWarningEnabled();
    }

    public boolean isErrorEnabled() {
        return Log.isErrorEnabled();
    }

    public void debug(Object message2) {
        this.log(3, message2);
    }

    public void debug(Object message2, Exception e) {
        this.log(3, message2, e);
    }

    public void info(Object message2) {
        this.log(2, message2);
    }

    public void info(Object message2, Exception e) {
        this.log(2, message2, e);
    }

    public void warn(Object message2) {
        this.log(1, message2);
    }

    public void warn(Object message2, Exception e) {
        this.log(1, message2, e);
    }

    public void error(Object message2) {
        this.log(0, message2);
    }

    public void error(Object message2, Exception e) {
        this.log(0, message2, e);
    }

    public void log(int level, Object message2) {
        if (this.contextPrefix != null) {
            Log.getInstance().doLog(level, new Log.SimpleMessage(this.contextPrefix, ":", message2));
        } else {
            Log.getInstance().doLog(level, message2);
        }
    }

    public void log(int level, Object message2, Exception e) {
        if (this.contextPrefix != null) {
            Log.getInstance().doLog(level, new Log.SimpleMessage(this.contextPrefix, ":", message2), e);
        } else {
            Log.getInstance().doLog(level, message2, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogContext)) {
            return false;
        }
        LogContext logContext = (LogContext)o;
        return !(this.contextPrefix != null ? !this.contextPrefix.equals(logContext.contextPrefix) : logContext.contextPrefix != null);
    }

    public int hashCode() {
        return this.contextPrefix != null ? this.contextPrefix.hashCode() : 0;
    }
}

