/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

public class IntervalUtils {
    private static int getDestIndex(long sourceTime, long startInterval, long destSize, boolean isStart) {
        if (!isStart && sourceTime % destSize == 0L) {
            return (int)(sourceTime / destSize - startInterval - 1L);
        }
        return (int)(sourceTime / destSize - startInterval);
    }

    public static void fillIntervals(double[] destData, long destSize, long destStartInterval, long sourceStartTime, long sourceEndTime, double sourceTotalValue, boolean discrete) {
        int endIndex;
        long destEndInterval = destStartInterval + (long)destData.length - 1L;
        long destStartTime = destStartInterval * destSize;
        long destEndTime = (destEndInterval + 1L) * destSize;
        long sourceTotalTime = sourceEndTime - sourceStartTime;
        double adjustedValue = 0.0;
        double fractionFromStart = 0.0;
        double fractionFromEnd = 0.0;
        double contribution = 0.0;
        if (sourceEndTime <= destStartTime || sourceStartTime >= destEndTime) {
            return;
        }
        if (sourceStartTime < destStartTime) {
            fractionFromStart = (double)(destStartTime - sourceStartTime) / (double)sourceTotalTime;
            sourceStartTime = destStartTime;
        }
        if (sourceEndTime > destEndTime) {
            fractionFromEnd = (double)(sourceEndTime - destEndTime) / (double)sourceTotalTime;
            sourceEndTime = destEndTime;
        }
        sourceTotalTime = sourceEndTime - sourceStartTime;
        adjustedValue = sourceTotalValue * (1.0 - fractionFromStart - fractionFromEnd);
        sourceTotalValue = discrete ? Math.rint(adjustedValue) : adjustedValue;
        int startIndex = IntervalUtils.getDestIndex(sourceStartTime, destStartInterval, destSize, true);
        if (startIndex == (endIndex = IntervalUtils.getDestIndex(sourceEndTime, destStartInterval, destSize, false))) {
            int n = startIndex;
            destData[n] = destData[n] + sourceTotalValue;
            return;
        }
        fractionFromStart = (double)(((long)startIndex + destStartInterval + 1L) * destSize - sourceStartTime) / (double)sourceTotalTime;
        fractionFromEnd = (double)(sourceEndTime - ((long)endIndex + destStartInterval) * destSize) / (double)sourceTotalTime;
        if (!discrete) {
            contribution += fractionFromStart * sourceTotalValue;
            int n = startIndex;
            destData[n] = destData[n] + fractionFromStart * sourceTotalValue;
            contribution += fractionFromEnd * sourceTotalValue;
            int n2 = endIndex;
            destData[n2] = destData[n2] + fractionFromEnd * sourceTotalValue;
            sourceTotalValue -= contribution;
            int remainingIntervals = endIndex - startIndex - 1;
            int i = startIndex + 1;
            while (i < endIndex) {
                int n3 = i++;
                destData[n3] = destData[n3] + sourceTotalValue / (double)remainingIntervals;
            }
        } else {
            double mainSectionValue = Math.rint(sourceTotalValue * (1.0 - fractionFromStart - fractionFromEnd));
            double startBoundaryValue = Math.rint((sourceTotalValue - mainSectionValue) * fractionFromStart);
            double endBoundaryValue = sourceTotalValue - mainSectionValue - startBoundaryValue;
            int n = startIndex;
            destData[n] = destData[n] + startBoundaryValue;
            int n4 = endIndex;
            destData[n4] = destData[n4] + endBoundaryValue;
            double offset = 0.0;
            contribution = mainSectionValue / (double)(endIndex - startIndex - 1);
            for (int i = startIndex + 1; i < endIndex; ++i) {
                int n5 = i;
                destData[n5] = destData[n5] + Math.floor(offset += contribution);
                offset -= Math.floor(offset);
                if (i != endIndex - 1) continue;
                int n6 = i;
                destData[n6] = destData[n6] + Math.rint(offset);
            }
        }
    }

    public static double utilToTime(double utilization, double timeRange) {
        return utilization * timeRange / 100.0;
    }

    public static double timeToUtil(double time, double timeRange) {
        return time / timeRange * 100.0;
    }

    public static void utilToTime(double[] data, double originalSize) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] * originalSize / 100.0;
        }
    }

    public static void timeToUtil(double[] data, double intervalSize) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] / intervalSize * 100.0;
        }
    }

    public static double getBestIntervalSize(double intervalSize, int numIntervals) {
        double bestSize = 1.0;
        int numSlices = 1;
        bestSize = Math.pow(10.0, Math.ceil(Math.log(intervalSize) / Math.log(10.0)));
        numSlices = (int)Math.ceil(intervalSize * (double)numIntervals / bestSize);
        while (!(numSlices > 10 && numSlices <= 1000 || numSlices <= 10 && bestSize == 1.0)) {
            if (numSlices <= 10) {
                numSlices *= 10;
                bestSize /= 10.0;
                continue;
            }
            numSlices /= 10;
            bestSize *= 10.0;
        }
        return bestSize;
    }

    public static double[] rebin(double[] data, double originalSize, int newNumIntervals) {
        double[] returnArray = new double[newNumIntervals];
        double newSize = (double)data.length * originalSize / (double)newNumIntervals;
        for (int i = 0; i < data.length; ++i) {
            int binEndIdx;
            int binStartIdx = (int)Math.floor((double)i * originalSize / newSize);
            if (binStartIdx == (binEndIdx = i == data.length - 1 ? newNumIntervals - 1 : (int)Math.floor((double)(i + 1) * originalSize / newSize))) {
                int n = binStartIdx;
                returnArray[n] = returnArray[n] + data[i];
                continue;
            }
            double startProportion = ((double)(binStartIdx + 1) * newSize - (double)i * originalSize) / originalSize;
            int n = binStartIdx;
            returnArray[n] = returnArray[n] + data[i] * startProportion;
            double endProportion = ((double)(i + 1) * originalSize - (double)binEndIdx * newSize) / originalSize;
            int n2 = binEndIdx;
            returnArray[n2] = returnArray[n2] + data[i] * endProportion;
            double remaining = data[i] * (1.0 - startProportion - endProportion);
            double pieSlice = 0.0;
            if (binEndIdx - binStartIdx - 1 > 0) {
                pieSlice = remaining / (double)(binEndIdx - binStartIdx - 1);
            }
            int j = binStartIdx + 1;
            while (j < binEndIdx) {
                int n3 = j++;
                returnArray[n3] = returnArray[n3] + pieSlice;
            }
        }
        return returnArray;
    }

    public static double[] rebin(double[] data, double originalSize, double newSize) {
        int newNumIntervals = (int)Math.ceil((double)data.length * originalSize / newSize);
        return IntervalUtils.rebin(data, originalSize, newNumIntervals);
    }

    public static int getBin(long intervalSize, long time) {
        return (int)(time / intervalSize);
    }

    public static void printArray(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            System.out.print(data[i] + " ");
        }
        System.out.println();
    }

    public static void main(String[] args) {
        long dataSize = 100L;
        long startTime = 150L;
        long endTime = 450L;
        double[] data = new double[10];
        IntervalUtils.fillIntervals(data, dataSize, 0L, startTime, endTime, endTime - startTime, false);
        IntervalUtils.printArray(data);
        data = new double[10];
        IntervalUtils.fillIntervals(data, dataSize, 10L, startTime, endTime, endTime - startTime, false);
        IntervalUtils.printArray(data);
        data = new double[10];
        IntervalUtils.fillIntervals(data, dataSize, 14L, startTime, endTime, endTime - startTime, false);
        IntervalUtils.printArray(data);
        data = new double[10];
        IntervalUtils.fillIntervals(data, dataSize, 15L, startTime, endTime, endTime - startTime, false);
        IntervalUtils.printArray(data);
        data = new double[10];
        IntervalUtils.fillIntervals(data, dataSize, 40L, startTime, endTime, endTime - startTime, false);
        IntervalUtils.printArray(data);
        data = new double[10];
        IntervalUtils.fillIntervals(data, dataSize, 44L, startTime, endTime, endTime - startTime, false);
        IntervalUtils.printArray(data);
        data = new double[10];
        IntervalUtils.fillIntervals(data, dataSize, 45L, startTime, endTime, endTime - startTime, false);
        IntervalUtils.printArray(data);
    }
}

