/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.Util;

public class ColorSelectWindow
extends Dialog
implements AdjustmentListener,
ActionListener {
    private Label lRed;
    private Label lGreen;
    private Label lBlue;
    private Scrollbar sbRed;
    private Scrollbar sbGreen;
    private Scrollbar sbBlue;
    private DisplayCanvas displayCanvas;
    private Button bOK;
    private Button bCancel;
    private TextField tfRed;
    private TextField tfGreen;
    private TextField tfBlue;
    private Color currentColor;
    String title;
    private Panel p1;
    private Panel p2;
    private Frame myParent;

    public ColorSelectWindow(Frame parent, Color currentColor, String s) {
        super(parent);
        this.setModal(true);
        this.currentColor = currentColor;
        this.myParent = parent;
        this.title = s;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ColorSelectWindow.this.dispose();
            }
        });
        this.setTitle("Select Color");
        this.setBackground(Color.gray);
        this.lRed = new Label("Red");
        this.lGreen = new Label("Green");
        this.lBlue = new Label("Blue");
        this.sbRed = new Scrollbar(0, currentColor.getRed(), 10, 0, 265);
        this.sbGreen = new Scrollbar(0, currentColor.getGreen(), 10, 0, 265);
        this.sbBlue = new Scrollbar(0, currentColor.getBlue(), 10, 0, 265);
        this.sbRed.setBlockIncrement(16);
        this.sbRed.addAdjustmentListener(this);
        this.sbGreen.setBlockIncrement(16);
        this.sbGreen.addAdjustmentListener(this);
        this.sbBlue.setBlockIncrement(16);
        this.sbBlue.addAdjustmentListener(this);
        this.tfRed = new TextField("" + currentColor.getRed(), 5);
        this.tfGreen = new TextField("" + currentColor.getGreen(), 5);
        this.tfBlue = new TextField("" + currentColor.getBlue(), 5);
        this.tfRed.setEditable(false);
        this.tfGreen.setEditable(false);
        this.tfBlue.setEditable(false);
        this.bOK = new Button("OK");
        this.bCancel = new Button("Cancel");
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.displayCanvas = new DisplayCanvas(currentColor);
        this.p1 = new Panel();
        this.p1.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.p1.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(this.p1, this.displayCanvas, gbc, 0, 0, 3, 1, 1, 1, 10, 10, 10, 10);
        Util.gblAdd(this.p1, this.lRed, gbc, 0, 1, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.lGreen, gbc, 0, 2, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.lBlue, gbc, 0, 3, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.sbRed, gbc, 1, 1, 1, 1, 1, 0);
        Util.gblAdd(this.p1, this.sbGreen, gbc, 1, 2, 1, 1, 1, 0);
        Util.gblAdd(this.p1, this.sbBlue, gbc, 1, 3, 1, 1, 1, 0);
        Util.gblAdd(this.p1, this.tfRed, gbc, 2, 1, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.tfGreen, gbc, 2, 2, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.tfBlue, gbc, 2, 3, 1, 1, 0, 0, 0, 2, 0, 2);
        this.p2 = new Panel();
        this.p2.setBackground(Color.lightGray);
        this.p2.setLayout(new FlowLayout());
        this.p2.add(this.bOK);
        this.p2.add(this.bCancel);
        this.setLayout(new GridBagLayout());
        Util.gblAdd(this, this.p1, gbc, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(this, this.p2, gbc, 0, 2, 1, 1, 1, 0, 2, 2, 2, 2);
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        Button b = (Button)evt.getSource();
        if (b == this.bOK) {
            this.myParent.setBackground(this.currentColor);
        }
        this.setVisible(false);
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        int r = this.sbRed.getValue();
        int g = this.sbGreen.getValue();
        int b = this.sbBlue.getValue();
        this.tfRed.setText("" + r);
        this.tfGreen.setText("" + g);
        this.tfBlue.setText("" + b);
        this.currentColor = new Color(r, g, b);
        this.displayCanvas.setColor(this.currentColor);
    }

    public void setColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        this.sbRed.setValue(r);
        this.sbGreen.setValue(g);
        this.sbBlue.setValue(b);
        this.tfRed.setText("" + r);
        this.tfGreen.setText("" + g);
        this.tfBlue.setText("" + b);
        this.currentColor = c;
        this.displayCanvas.setColor(c);
    }

    public void setString(String s) {
        this.displayCanvas.setString(s);
    }

    private class DisplayCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private Color foreground;
        int w;
        int h;
        private FontMetrics fm;
        private int titleHeight;
        private int titleWidth;

        public DisplayCanvas(Color c) {
            this.foreground = c;
            this.setBackground(Color.black);
        }

        public Dimension getMinimumSize() {
            return new Dimension(150, 50);
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 75);
        }

        public void setColor(Color c) {
            this.foreground = c;
            this.repaint();
        }

        public void setString(String s) {
            ColorSelectWindow.this.title = s;
            this.titleWidth = this.fm.stringWidth(ColorSelectWindow.this.title);
            Graphics g = this.getGraphics();
            g.clearRect(0, 0, this.w, this.h);
            this.repaint();
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (this.fm == null) {
                this.fm = g.getFontMetrics(g.getFont());
                this.titleHeight = this.fm.getHeight();
                this.titleWidth = this.fm.stringWidth(ColorSelectWindow.this.title);
            }
            this.w = this.getSize().width;
            this.h = this.getSize().height;
            g.setColor(this.foreground);
            g.drawString(ColorSelectWindow.this.title, (this.w - this.titleWidth) / 2, this.titleHeight);
            g.drawLine(0, this.h, this.w / 2, this.titleHeight + 10);
            g.fillRect(this.w / 2 + 20, this.h / 2, this.w / 4, this.h / 2);
            g.setColor(Color.gray);
            g.drawLine(0, 0, this.w, 0);
            g.drawLine(0, 1, this.w, 1);
            g.drawLine(0, 0, 0, this.h);
            g.drawLine(1, 0, 1, this.h);
            g.setColor(Color.white);
            g.drawLine(0, this.h, this.w, this.h);
            g.drawLine(0, this.h - 1, this.w, this.h - 1);
            g.drawLine(this.w, this.h, this.w, 0);
            g.drawLine(this.w - 1, this.h, this.w - 1, 0);
        }
    }
}

