/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class IntTextField
extends TextField
implements TextListener {
    private String lastValue;
    int lastCaretPosition;

    public IntTextField(int defval, int size) {
        super("" + defval, size);
        this.addTextListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                if (!('0' <= ch && ch <= '9' || Character.isISOControl(ch))) {
                    evt.consume();
                } else {
                    IntTextField.this.lastCaretPosition = IntTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + defval;
    }

    private void checkValue() {
        try {
            Integer.parseInt(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException e) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public int getValue() {
        this.checkValue();
        try {
            return Integer.parseInt(this.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setValue(int num) {
        this.lastValue = this.getText();
        this.setText(String.valueOf(num));
        this.checkValue();
    }

    public void textValueChanged(TextEvent evt) {
        this.checkValue();
    }
}

