/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.gui.JTimeTextField;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class IntervalRangeDialog
extends RangeDialog
implements ActionListener,
KeyListener,
FocusListener {
    JPanel sizePanel;
    JTimeTextField sizeField;
    JLabel numIntervalsLabel;
    JLabel validIntervalsLabel;
    JLabel startIntervalLabel;
    JLabel endIntervalLabel;
    public long intervalSize = -1L;
    private long validIntervals;

    public IntervalRangeDialog(ProjectionsWindow parentWindow, String titleString) {
        super(parentWindow, titleString);
        long initialIntervalSize = 1000L;
        this.validIntervals = this.totalValidTime / initialIntervalSize;
        if (this.totalValidTime % initialIntervalSize != 0L) {
            ++this.validIntervals;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b == this.bOK) {
                JTextField someField = this.checkConsistent();
                if (someField != null) {
                    someField.selectAll();
                    someField.requestFocus();
                    return;
                }
            } else if (b == this.bUpdate) {
                this.updateData(this.sizeField);
            }
        } else if (evt.getSource() instanceof JTextField) {
            this.updateData((JTextField)evt.getSource());
        }
        super.actionPerformed(evt);
    }

    JPanel createMainLayout() {
        JPanel inputPanel = new JPanel();
        JPanel baseMainPanel = super.createMainLayout();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.sizePanel = new JPanel();
        this.sizePanel.setLayout(gbl);
        JLabel sizeLabel = new JLabel("Interval Size :", 2);
        this.sizeField = new JTimeTextField(1000L, 12);
        this.sizeField.addActionListener(this);
        this.sizeField.addKeyListener(this);
        this.sizeField.addFocusListener(this);
        long startInterval = this.startTimeField.getValue() / this.sizeField.getValue();
        long endInterval = this.endTimeField.getValue() / this.sizeField.getValue();
        this.validIntervalsLabel = new JLabel("Valid Total Number of Intervals : " + this.validIntervals, 2);
        this.numIntervalsLabel = new JLabel("Selected Number of Intervals : " + (endInterval - startInterval + 1L), 2);
        this.startIntervalLabel = new JLabel("Start Interval : " + startInterval, 2);
        this.endIntervalLabel = new JLabel("End Interval : " + endInterval, 2);
        Util.gblAdd(this.sizePanel, sizeLabel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.sizeField, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.numIntervalsLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.validIntervalsLabel, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.startIntervalLabel, gbc, 0, 3, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.endIntervalLabel, gbc, 1, 3, 1, 1, 1, 1);
        inputPanel.setLayout(gbl);
        Util.gblAdd(inputPanel, baseMainPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(inputPanel, this.sizePanel, gbc, 0, 1, 1, 1, 1, 1);
        return inputPanel;
    }

    void updateData(JTextField field) {
        if (field instanceof JTimeTextField) {
            long temp = this.sizeField.getValue();
            long startInterval = this.startTimeField.getValue() / temp;
            long endInterval = this.endTimeField.getValue() / temp;
            if (field == this.sizeField) {
                long validIntervals = this.totalValidTime / temp;
                if (this.totalValidTime % temp != 0L) {
                    ++validIntervals;
                }
                this.validIntervalsLabel.setText("Total Valid Number of Intervals : " + validIntervals);
                this.numIntervalsLabel.setText("Selected Number of Intervals : " + (endInterval - startInterval + 1L));
                this.startIntervalLabel.setText("Start Interval : " + startInterval);
                this.endIntervalLabel.setText("End Interval : " + endInterval);
            } else if (field == this.startTimeField) {
                this.startIntervalLabel.setText("Start Interval : " + startInterval);
                this.numIntervalsLabel.setText("Selected Number of Intervals : " + (endInterval - startInterval + 1L));
            } else if (field == this.endTimeField) {
                this.endIntervalLabel.setText("End Interval : " + endInterval);
                this.numIntervalsLabel.setText("Selected Number of Intervals : " + (endInterval - startInterval + 1L));
            }
        }
        super.updateData(field);
    }

    JTextField checkConsistent() {
        if (this.sizeField.getValue() <= 0L || this.sizeField.getValue() > this.totalTime) {
            return this.sizeField;
        }
        return super.checkConsistent();
    }

    public boolean isModified() {
        return this.intervalSize != this.sizeField.getValue() || super.isModified();
    }

    void setParameters() {
        this.intervalSize = this.sizeField.getValue();
        super.setParameters();
    }

    void updateFields() {
        this.sizeField.setValue(this.intervalSize);
        super.updateFields();
        this.updateDerived();
    }

    void updateDerived() {
        long temp = this.sizeField.getValue();
        long startInterval = this.startTimeField.getValue() / temp;
        long endInterval = this.endTimeField.getValue() / temp;
        long validIntervals = this.totalValidTime / temp;
        if (this.totalValidTime % temp != 0L) {
            ++validIntervals;
        }
        this.validIntervalsLabel.setText("Total Valid Number of Intervals : " + validIntervals);
        this.numIntervalsLabel.setText("Selected Number of Intervals : " + (endInterval - startInterval + 1L));
        this.startIntervalLabel.setText("Start Interval : " + startInterval);
        this.endIntervalLabel.setText("End Interval : " + endInterval);
    }

    public long getIntervalSize() {
        return this.sizeField.getValue();
    }

    public void setIntervalSize(long size) {
        this.intervalSize = size;
    }

    public long getStartInterval() {
        return this.startTimeField.getValue() / this.sizeField.getValue();
    }

    public long getEndInterval() {
        return this.endTimeField.getValue() / this.sizeField.getValue();
    }
}

