/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.LogFileViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import projections.gui.LogFileViewer.LogFileViewerTextArea;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;

public class LogFileViewerWindow
extends ProjectionsWindow
implements ActionListener {
    static int myRun = 0;
    JTabbedPane tabbedPane;
    private JButton bOpen;
    OrderedIntList validPEs;
    long startTime;
    long endTime;

    public LogFileViewerWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.setTitle("Projections Log File Viewer - " + MainWindow.runObject[myRun].getFilename() + ".sts");
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        JLabel simpleLabel = new JLabel("<html><body><h1>Data is loading</h1></body></html>");
        this.tabbedPane.add("loading ...", simpleLabel);
        this.bOpen = new JButton("Load Different PE ...");
        this.bOpen.addActionListener(this);
        this.bOpen.setPreferredSize(new Dimension(200, 40));
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.bOpen, "South");
        this.pack();
        this.setVisible(true);
        this.showDialog();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.bOpen) {
            this.showDialog();
        }
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            this.setCursor(new Cursor(3));
            this.tabbedPane.removeAll();
            this.validPEs.reset();
            while (this.validPEs.hasMoreElements()) {
                int p = this.validPEs.nextElement();
                LogFileViewerTextArea textArea = new LogFileViewerTextArea();
                textArea.setPE(p, this.startTime, this.endTime);
                this.tabbedPane.add("PE " + p, textArea);
            }
            this.pack();
            this.setCursor(new Cursor(0));
        }
    }

    protected void windowInit() {
    }

    public void showWindow() {
    }

    public void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }
}

