/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import projections.gui.MultiRunWindow;
import projections.gui.Util;
import projections.misc.MultiRunData;

public class MultiRunControlPanel
extends JPanel {
    private ButtonGroup dataTypeModes;
    private JPanel dataTypePanel;
    private JRadioButton[] dataTypeButtons;
    private JButton displayTable;
    private JButton done;

    public MultiRunControlPanel(MultiRunWindow mainWindow, int defaultDataType) {
        this.setBackground(Color.lightGray);
        this.dataTypeModes = new ButtonGroup();
        this.dataTypePanel = new JPanel();
        this.dataTypeButtons = new JRadioButton[4];
        for (int type = 0; type < 4; ++type) {
            this.dataTypeButtons[type] = new JRadioButton(MultiRunData.getTypeName(type), type == defaultDataType);
            this.dataTypeButtons[type].addItemListener(mainWindow);
            this.dataTypeModes.add(this.dataTypeButtons[type]);
            this.dataTypePanel.add(this.dataTypeButtons[type]);
        }
        this.dataTypePanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.displayTable = new JButton("Display Tables");
        this.displayTable.addActionListener(mainWindow);
        this.done = new JButton("Close Window");
        this.done.addActionListener(mainWindow);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.fill = 2;
        Util.gblAdd(this, this.dataTypePanel, gbc, 0, 0, 1, 2, 1, 0, 1, 1, 1, 1);
        gbc.fill = 1;
        Util.gblAdd(this, this.displayTable, gbc, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this, this.done, gbc, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1);
    }

    public int getSelectedIdx(ItemSelectable item) {
        JRadioButton dataTypeButton = (JRadioButton)item;
        for (int type = 0; type < 4; ++type) {
            if (dataTypeButton != this.dataTypeButtons[type]) continue;
            return type;
        }
        return -1;
    }
}

