/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.analysis.RangeHistory;
import projections.gui.JSelectField;
import projections.gui.JTimeTextField;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.U;
import projections.gui.Util;

public class RangeDialog
extends JDialog
implements ActionListener,
KeyListener,
FocusListener {
    int myRun = 0;
    protected static final int DIALOG_OK = 0;
    protected static final int DIALOG_CANCELLED = 1;
    ProjectionsWindow parentWindow;
    JPanel mainPanel;
    JPanel historyPanel;
    JPanel buttonPanel;
    JSelectField processorsField;
    JTimeTextField startTimeField;
    JTimeTextField endTimeField;
    JPanel timePanel;
    JPanel processorsPanel;
    JButton bOK;
    JButton bUpdate;
    JButton bCancel;
    JComboBox historyList;
    JButton bAddToHistory;
    JButton bRemoveFromHistory;
    JButton bSaveHistory;
    private JLabel startTextLabel;
    private JLabel endTextLabel;
    private JLabel totalTimeTextLabel;
    private JLabel processorTextLabel;
    private JLabel totalTimeLabel;
    private JLabel validTimeRangeLabel;
    private JLabel validProcessorsLabel;
    protected long totalTime;
    protected long totalValidTime;
    protected int numProcessors;
    protected OrderedIntList validProcessors = new OrderedIntList();
    protected long startTime = -1L;
    protected long endTime = -1L;
    RangeHistory history;
    private boolean layoutComplete = false;
    int dialogState;
    private boolean disableRange = false;

    public RangeDialog(ProjectionsWindow parentWindow, String titleString, boolean disableRange) {
        this(parentWindow, titleString);
        this.disableRange = disableRange;
    }

    public RangeDialog(ProjectionsWindow parentWindow, String titleString) {
        super(parentWindow, titleString, true);
        this.parentWindow = parentWindow;
        this.numProcessors = MainWindow.runObject[this.myRun].getNumProcessors();
        this.totalValidTime = this.totalTime = MainWindow.runObject[this.myRun].getTotalTime();
        this.history = new RangeHistory(MainWindow.runObject[this.myRun].getLogDirectory() + File.separator);
        this.setModal(true);
        this.dialogState = 1;
    }

    public void actionPerformed(ActionEvent evt) {
        JComboBox item;
        if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b == this.bOK) {
                JTextField someField = this.checkConsistent();
                if (someField != null) {
                    someField.selectAll();
                    someField.requestFocus();
                    return;
                }
                this.dialogState = 0;
                this.setVisible(false);
            } else {
                if (b == this.bUpdate) {
                    this.updateData(this.processorsField);
                    this.updateData(this.startTimeField);
                    this.updateData(this.endTimeField);
                    return;
                }
                if (b == this.bCancel) {
                    this.dialogState = 1;
                    this.setVisible(false);
                } else if (b == this.bAddToHistory) {
                    long start = this.startTimeField.getValue();
                    long end = this.endTimeField.getValue();
                    this.history.add(start, end);
                    String historyString = U.t(start) + " to " + U.t(end);
                    this.historyList.insertItemAt(historyString, 0);
                    this.historyList.setSelectedIndex(0);
                } else if (b == this.bRemoveFromHistory) {
                    int selected = this.historyList.getSelectedIndex();
                    if (selected != -1) {
                        this.history.remove(selected);
                        this.historyList.removeItemAt(selected);
                    }
                } else if (b == this.bSaveHistory) {
                    try {
                        this.history.save();
                    }
                    catch (IOException e) {
                        System.err.println("Save Error: " + e.toString());
                    }
                }
            }
        } else if (evt.getSource() instanceof JTextField) {
            this.updateData((JTextField)evt.getSource());
            this.bOK.setEnabled(true);
        } else if (evt.getSource() instanceof JComboBox && (item = (JComboBox)evt.getSource()) == this.historyList) {
            int selection = this.historyList.getSelectedIndex();
            if (selection == -1) {
                return;
            }
            this.startTimeField.setValue(this.history.getStartValue(selection));
            this.endTimeField.setValue(this.history.getEndValue(selection));
        }
    }

    public void focusGained(FocusEvent evt) {
    }

    public void focusLost(FocusEvent evt) {
        if (evt.getComponent() instanceof JTextField) {
            this.updateData((JTextField)evt.getComponent());
            this.bOK.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        int keycode = evt.getKeyCode();
        if (evt.getComponent() instanceof JTextField) {
            JTextField field = (JTextField)evt.getComponent();
            switch (keycode) {
                case 10: {
                    this.updateData(field);
                    this.bOK.setEnabled(true);
                    break;
                }
                case 9: {
                    this.updateData(field);
                    this.bOK.setEnabled(true);
                    break;
                }
                default: {
                    this.bOK.setEnabled(false);
                }
            }
        }
    }

    public void displayDialog() {
        if (!this.layoutComplete) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    RangeDialog.this.dialogState = 1;
                    RangeDialog.this.setVisible(false);
                }
            });
            this.mainPanel = this.createMainLayout();
            this.historyPanel = this.createHistoryLayout();
            this.buttonPanel = this.createButtonLayout();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel, "North");
            this.getContentPane().add((Component)this.historyPanel, "Center");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.layoutComplete = true;
            this.pack();
            this.setResizable(false);
        } else {
            this.setParameters();
        }
        this.setLocationRelativeTo(this.parentWindow);
        this.setVisible(true);
    }

    JPanel createMainLayout() {
        JPanel inputPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.processorsPanel = new JPanel();
        this.processorsPanel.setLayout(gbl);
        this.validProcessorsLabel = new JLabel("Valid Processors = " + MainWindow.runObject[this.myRun].getValidProcessorString(), 2);
        this.processorTextLabel = new JLabel("Processors :", 2);
        this.processorsField = new JSelectField(MainWindow.runObject[this.myRun].getValidProcessorString(), 12);
        this.processorsField.addActionListener(this);
        Util.gblAdd(this.processorsPanel, this.validProcessorsLabel, gbc, 0, 0, 2, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorTextLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorsField, gbc, 1, 1, 1, 1, 1, 1);
        this.timePanel = new JPanel();
        this.timePanel.setLayout(gbl);
        this.validTimeRangeLabel = new JLabel("Valid Time Range = " + U.t(0L) + " to " + U.t(MainWindow.runObject[this.myRun].getTotalTime()), 2);
        this.startTextLabel = new JLabel("Start Time :", 2);
        this.startTimeField = new JTimeTextField(0L, 12);
        this.endTextLabel = new JLabel("End Time :", 2);
        this.endTimeField = new JTimeTextField(MainWindow.runObject[this.myRun].getTotalTime(), 12);
        this.totalTimeTextLabel = new JLabel("Total Time selected :", 2);
        this.totalTimeLabel = new JLabel(U.t(MainWindow.runObject[this.myRun].getTotalTime()), 2);
        if (this.disableRange) {
            this.startTimeField.setEnabled(false);
            this.endTimeField.setEnabled(false);
        } else {
            this.startTimeField.addActionListener(this);
            this.endTimeField.addActionListener(this);
            this.startTimeField.addKeyListener(this);
            this.endTimeField.addKeyListener(this);
            this.startTimeField.addFocusListener(this);
            this.endTimeField.addFocusListener(this);
        }
        Util.gblAdd(this.timePanel, this.validTimeRangeLabel, gbc, 0, 0, 4, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.startTextLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.startTimeField, gbc, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.endTextLabel, gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.endTimeField, gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.totalTimeTextLabel, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.totalTimeLabel, gbc, 1, 2, 3, 1, 1, 1);
        if (this.disableRange) {
            Util.gblAdd(this.timePanel, new JLabel("Summary data compatible only with full time range."), gbc, 0, 3, 4, 1, 1, 1);
        }
        inputPanel.setLayout(gbl);
        Util.gblAdd(inputPanel, this.processorsPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(inputPanel, this.timePanel, gbc, 0, 1, 1, 1, 1, 1);
        return inputPanel;
    }

    JPanel createButtonLayout() {
        JPanel buttonPanel = new JPanel();
        this.bOK = new JButton("OK");
        this.bUpdate = new JButton("Update");
        this.bCancel = new JButton("Cancel");
        buttonPanel.add(this.bOK);
        buttonPanel.add(this.bUpdate);
        buttonPanel.add(this.bCancel);
        this.bOK.addActionListener(this);
        this.bUpdate.addActionListener(this);
        this.bCancel.addActionListener(this);
        return buttonPanel;
    }

    private JPanel createHistoryLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        JPanel historyPanel = new JPanel();
        historyPanel.setLayout(gbl);
        this.historyList = new JComboBox(this.history.getHistoryStrings());
        this.historyList.setEditable(false);
        this.historyList.setMaximumRowCount(10);
        this.historyList.setSelectedIndex(-1);
        this.bAddToHistory = new JButton("Add to History List");
        this.bRemoveFromHistory = new JButton("Remove selected History");
        this.bSaveHistory = new JButton("Save History to Disk");
        if (this.disableRange) {
            this.historyList.setEnabled(false);
            this.bAddToHistory.setEnabled(false);
            this.bRemoveFromHistory.setEnabled(false);
            this.bSaveHistory.setEnabled(false);
        } else {
            this.historyList.addActionListener(this);
            this.bAddToHistory.addActionListener(this);
            this.bRemoveFromHistory.addActionListener(this);
            this.bSaveHistory.addActionListener(this);
        }
        Util.gblAdd(historyPanel, this.historyList, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(historyPanel, this.bSaveHistory, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(historyPanel, this.bAddToHistory, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(historyPanel, this.bRemoveFromHistory, gbc, 1, 1, 1, 1, 1, 1);
        return historyPanel;
    }

    void updateData(JTextField field) {
        if (field instanceof JTimeTextField) {
            if (field == this.startTimeField || field == this.endTimeField) {
                this.totalTime = this.endTimeField.getValue() - this.startTimeField.getValue();
                this.totalTimeLabel.setText(U.t(this.totalTime));
            }
        } else if (!(field instanceof JSelectField) || field == this.processorsField) {
            // empty if block
        }
    }

    void setParameters() {
        this.startTime = this.startTimeField.getValue();
        this.endTime = this.endTimeField.getValue();
        this.validProcessors = this.getValidProcessors();
    }

    void updateFields() {
        this.startTimeField.setValue(this.startTime);
        this.endTimeField.setValue(this.endTime);
        this.processorsField.setText(this.validProcessors.listToString());
        this.updateDerived();
    }

    void updateDerived() {
        this.totalTime = this.endTimeField.getValue() - this.startTimeField.getValue();
        this.totalTimeLabel.setText(U.t(this.totalTime));
    }

    JTextField checkConsistent() {
        if (this.startTimeField.getValue() >= this.endTimeField.getValue()) {
            return this.startTimeField;
        }
        if (this.startTimeField.getValue() < 0L) {
            return this.startTimeField;
        }
        if (this.endTimeField.getValue() > this.totalValidTime) {
            return this.endTimeField;
        }
        return null;
    }

    public boolean isCancelled() {
        return this.dialogState == 1;
    }

    public boolean isModified() {
        return this.startTime != this.startTimeField.getValue() || this.endTime != this.endTimeField.getValue() || !this.validProcessors.equals(this.getValidProcessors());
    }

    public long getStartTime() {
        return this.startTimeField.getValue();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTimeField.getValue();
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public OrderedIntList getValidProcessors() {
        return this.processorsField.getValue(this.numProcessors);
    }

    public String getValidProcessorString() {
        return this.processorsField.getText();
    }

    public void setValidProcessors(OrderedIntList validPEs) {
        this.validProcessors = validPEs;
    }
}

