/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ToolTipManager;
import projections.analysis.PackTime;
import projections.analysis.ThreadManager;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.gui.Timeline.EntryMethodObject;
import projections.gui.Timeline.MainHandler;
import projections.gui.Timeline.MessageStructures;
import projections.gui.Timeline.ThreadedFileReader;
import projections.gui.Timeline.TimelineMessage;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.Timeline.UserEventObject;
import projections.misc.LogLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data {
    public static final int BlueGradientColors = 0;
    public static final int RandomColors = 1;
    int myRun = 0;
    private MainHandler modificationHandler = null;
    private float scaleFactor = 1.0f;
    private double preferredViewTime = -1.0;
    private int mostRecentScaledScreenWidth;
    LinkedList peToLine;
    private boolean colorByObjectId;
    private boolean colorByMemoryUsage;
    private boolean colorByUserSupplied;
    private int[] entries;
    private Color[] entryColor;
    Set<Integer> hiddenEntryPoints;
    public TreeMap allEntryMethodObjects;
    public TreeMap<Integer, TreeSet<UserEventObject>> allUserEventObjects;
    float[] processorUsage;
    float[] idleUsage;
    float[] packUsage;
    OrderedUsageList[] entryUsageList;
    private long beginTime;
    private long endTime;
    long oldBT;
    long oldET;
    long minMem;
    long maxMem;
    MessageStructures messageStructures;
    private boolean showPacks;
    private boolean showIdle;
    private boolean showMsgs;
    private boolean showUserEvents;
    public Font labelFont;
    public Font axisFont;
    private boolean useMinimalView = false;
    public Set drawMessagesForTheseObjects;
    public Set drawMessagesForTheseObjectsAlt;
    private boolean useCustomColors = false;
    private Color customForeground;
    private Color customBackground;
    private int numUserEventRows = 1;
    boolean drawNestedUserEventRows = false;
    public long minUserSupplied = 0L;
    public long maxUserSupplied = 0L;
    private int selection1 = -1;
    private int selection2 = -1;
    private int highlight = -1;
    private boolean keepViewCentered = false;
    private Set highlightedObjects;
    private boolean traceMessagesBackOnHover;
    private boolean traceMessagesForwardOnHover;
    private boolean traceOIDOnHover;
    private boolean useCompactView;
    private Component guiRoot;
    int colorSchemeForUserSupplied;

    public boolean useMinimalView() {
        return this.useMinimalView;
    }

    public Data(MainHandler rh) {
        this.modificationHandler = rh;
        this.showPacks = false;
        this.showMsgs = true;
        this.showIdle = true;
        this.showUserEvents = true;
        this.peToLine = new LinkedList();
        this.messageStructures = new MessageStructures(this);
        this.hiddenEntryPoints = new TreeSet<Integer>();
        this.oldBT = -1L;
        this.oldET = -1L;
        this.processorUsage = null;
        this.entryUsageList = null;
        this.minMem = Integer.MAX_VALUE;
        this.maxMem = Integer.MIN_VALUE;
        this.minUserSupplied = Integer.MAX_VALUE;
        this.maxUserSupplied = Integer.MIN_VALUE;
        this.beginTime = 0L;
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
        this.drawMessagesForTheseObjects = new HashSet();
        this.drawMessagesForTheseObjectsAlt = new HashSet();
        this.allEntryMethodObjects = null;
        this.entries = new int[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.entryColor = MainWindow.runObject[this.myRun].getColorMap();
        this.labelFont = new Font("SansSerif", 0, 12);
        this.axisFont = new Font("SansSerif", 0, 10);
        this.highlightedObjects = new HashSet();
        this.colorByMemoryUsage = false;
        this.colorByObjectId = false;
        this.colorByUserSupplied = false;
        this.customForeground = Color.white;
        this.customBackground = Color.black;
        this.loadGlobalPEList();
    }

    public void addProcessor(int pCreation) {
        Integer p = new Integer(pCreation);
        if (!this.peToLine.contains(p)) {
            this.peToLine.addLast(p);
            this.modificationHandler.notifyProcessorListHasChanged();
        }
    }

    public void setProcessorList(OrderedIntList processorList) {
        this.peToLine.clear();
        processorList.reset();
        int p = processorList.nextElement();
        Integer line = 0;
        while (p != -1) {
            Integer pe = new Integer(p);
            this.peToLine.addLast(pe);
            Integer n = line;
            Integer n2 = line = Integer.valueOf(line + 1);
            p = processorList.nextElement();
        }
    }

    private void loadGlobalPEList() {
        OrderedIntList processorList = MainWindow.runObject[this.myRun].getValidProcessorList();
        this.setProcessorList(processorList);
    }

    public OrderedIntList processorListOrdered() {
        OrderedIntList processorList = new OrderedIntList();
        for (Integer pe : this.peToLine) {
            processorList.insert(pe);
            System.out.println("processorList " + pe);
        }
        return processorList;
    }

    public void setFontSizes(int labelFontSize, int axisFontSize, boolean useBoldForLabel) {
        this.labelFont = useBoldForLabel ? new Font("SansSerif", 1, labelFontSize) : new Font("SansSerif", 0, labelFontSize);
        this.axisFont = new Font("SansSerif", 0, axisFontSize);
    }

    public long beginTime() {
        return this.beginTime;
    }

    public boolean colorbyObjectId() {
        return this.colorByObjectId;
    }

    public void createTLOArray(boolean useHelperThreads, Component rootWindow) {
        this.messageStructures.kill();
        if (this.beginTime >= this.oldBT && this.endTime <= this.oldET) {
            TreeMap oldEntryMethodObjects = this.allEntryMethodObjects;
            TreeMap<Integer, TreeSet<UserEventObject>> oldUserEventObjects = this.allUserEventObjects;
            this.allEntryMethodObjects = new TreeMap();
            this.allUserEventObjects = new TreeMap();
            for (Integer pe : this.peToLine) {
                if (!oldEntryMethodObjects.containsKey(pe)) continue;
                this.allEntryMethodObjects.put(pe, oldEntryMethodObjects.get(pe));
                this.allUserEventObjects.put(pe, oldUserEventObjects.get(pe));
                if (this.allEntryMethodObjects.containsKey(pe)) {
                    LinkedList objs = (LinkedList)this.allEntryMethodObjects.get(pe);
                    Iterator iter = objs.iterator();
                    while (iter.hasNext()) {
                        EntryMethodObject obj = (EntryMethodObject)iter.next();
                        if (obj.getEndTime() >= this.beginTime && obj.getBeginTime() <= this.endTime) continue;
                        iter.remove();
                    }
                }
                if (!this.allUserEventObjects.containsKey(pe)) continue;
                Iterator<UserEventObject> iter2 = this.allUserEventObjects.get(pe).iterator();
                while (iter2.hasNext()) {
                    UserEventObject obj = iter2.next();
                    if (obj.EndTime >= this.beginTime && obj.BeginTime <= this.endTime) continue;
                    iter2.remove();
                }
            }
        } else {
            this.allEntryMethodObjects = new TreeMap();
            this.allUserEventObjects = new TreeMap();
        }
        this.oldBT = this.beginTime;
        this.oldET = this.endTime;
        Date startReadingTime = new Date();
        LinkedList<ThreadedFileReader> readyReaders = new LinkedList<ThreadedFileReader>();
        Iterator peIter = this.peToLine.iterator();
        int pIdx = 0;
        while (peIter.hasNext()) {
            Integer pe = (Integer)peIter.next();
            if (!this.allEntryMethodObjects.containsKey(pe)) {
                readyReaders.add(new ThreadedFileReader(pe, pIdx, this));
            }
            ++pIdx;
        }
        if (rootWindow == null) {
            rootWindow = MainWindow.runObject[this.myRun].guiRoot;
        }
        ThreadManager threadManager = new ThreadManager("Loading Files in Parallel", readyReaders, rootWindow);
        threadManager.runThreads();
        for (int e = 0; e < MainWindow.runObject[this.myRun].getNumUserEntries(); ++e) {
            this.entries[e] = 0;
        }
        this.processorUsage = new float[this.numPEs()];
        this.entryUsageList = new OrderedUsageList[this.numPEs()];
        float[] entryUsageArray = new float[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.idleUsage = new float[this.numPEs()];
        this.packUsage = new float[this.numPEs()];
        for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
            entryUsageArray[i] = 0.0f;
        }
        for (int p = 0; p < this.numPEs(); ++p) {
            this.processorUsage[p] = 0.0f;
            this.idleUsage[p] = 0.0f;
            this.packUsage[p] = 0.0f;
        }
        for (Integer pe : this.allEntryMethodObjects.keySet()) {
            LinkedList objs = (LinkedList)this.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                float usage = obj.getUsage();
                int entryIndex = obj.getEntryIndex();
                if (entryIndex >= 0) {
                    int n = entryIndex;
                    this.entries[n] = this.entries[n] + 1;
                    int n2 = pe;
                    this.processorUsage[n2] = this.processorUsage[n2] + usage;
                    int n3 = pe;
                    this.packUsage[n3] = this.packUsage[n3] + obj.getPackUsage();
                    int n4 = entryIndex;
                    entryUsageArray[n4] = entryUsageArray[n4] + obj.getNonPackUsage();
                    continue;
                }
                int n = pe;
                this.idleUsage[n] = this.idleUsage[n] + usage;
            }
            this.entryUsageList[pe.intValue()] = new OrderedUsageList();
            for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
                if (!(entryUsageArray[i] > 0.0f)) continue;
                this.entryUsageList[pe].insert(entryUsageArray[i], i);
            }
        }
        this.messageStructures.create(useHelperThreads);
    }

    public void decreaseScaleFactor() {
        this.setScaleFactor((float)((int)(this.getScaleFactor() * 4.0f) - 1) / 4.0f);
    }

    private void displayMustBeRedrawn() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(true);
        }
    }

    public void displayMustBeRepainted() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void toggleMessageSendLine(EntryMethodObject obj) {
        TimelineMessage created_message = obj.creationMessage();
        if (created_message != null) {
            if (this.drawMessagesForTheseObjects.contains(obj)) {
                this.drawMessagesForTheseObjects.remove(obj);
            } else {
                this.drawMessagesForTheseObjects.add(obj);
            }
            this.displayMustBeRepainted();
        } else {
            this.modificationHandler.displayWarning("Message was sent from outside the current time range");
        }
    }

    public void addMessageSendLineAlt(Set s) {
        this.drawMessagesForTheseObjectsAlt.addAll(s);
    }

    public void addMessageSendLine(Set s) {
        this.drawMessagesForTheseObjects.addAll(s);
    }

    public void clearMessageSendLines() {
        this.drawMessagesForTheseObjects.clear();
        this.drawMessagesForTheseObjectsAlt.clear();
    }

    public long endTime() {
        return this.endTime;
    }

    public int[] entries() {
        return this.entries;
    }

    public Color[] entryColor() {
        return this.entryColor;
    }

    public Color getBackgroundColor() {
        if (this.useCustomColors) {
            return this.customBackground;
        }
        return MainWindow.runObject[this.myRun].background;
    }

    void getData(Integer pe) {
        LinkedList tl = new LinkedList();
        TreeSet userEvents = new TreeSet();
        LinkedList<EntryMethodObject> perPEObjects = new LinkedList<EntryMethodObject>();
        if (perPEObjects == null) {
            System.err.println("perPEOBjects was not allocated successfully!!!!");
        }
        try {
            if (!MainWindow.runObject[this.myRun].hasLogData()) {
                System.err.println("createTL: No log files available!");
                return;
            }
            MainWindow.runObject[this.myRun].logLoader.createtimeline(pe, this.beginTime, this.endTime, tl, userEvents);
        }
        catch (LogLoadException e) {
            System.err.println("LOG LOAD EXCEPTION");
            return;
        }
        this.getDataSyncSaveObjectLists(pe, perPEObjects, userEvents);
        long minMemThisPE = Long.MAX_VALUE;
        long maxMemThisPE = 0L;
        long minUserSuppliedThisPE = Long.MAX_VALUE;
        long maxUserSuppliedThisPE = 0L;
        for (TimelineEvent tle : tl) {
            Vector packlist;
            Vector msglist = tle.MsgsSent;
            TreeSet msgs = new TreeSet();
            if (msglist != null) {
                msgs.addAll(msglist);
            }
            int numpacks = (packlist = tle.PackTimes) == null ? 0 : packlist.size();
            PackTime[] packs = new PackTime[numpacks];
            for (int p = 0; p < numpacks; ++p) {
                packs[p] = (PackTime)packlist.elementAt(p);
            }
            if (tle == null) {
                System.out.println("tle is NULL");
            }
            if (msgs == null) {
                System.out.println("msgs is NULL");
            }
            if (pe == null) {
                System.out.println("pe is NULL");
            }
            if (perPEObjects == null) {
                System.out.println("perPEObjects is NULL");
            }
            EntryMethodObject obj = new EntryMethodObject(this, tle, msgs, packs, pe);
            perPEObjects.add(obj);
            if (tle != null && tle.memoryUsage != null) {
                if (tle.memoryUsage.longValue() > maxMemThisPE) {
                    maxMemThisPE = tle.memoryUsage.longValue();
                }
                if (tle.memoryUsage.longValue() < minMemThisPE) {
                    minMemThisPE = tle.memoryUsage.longValue();
                }
            }
            if (tle == null || tle.UserSpecifiedData == null) continue;
            if ((long)tle.UserSpecifiedData.intValue() > maxUserSuppliedThisPE) {
                maxUserSuppliedThisPE = tle.UserSpecifiedData.intValue();
            }
            if ((long)tle.UserSpecifiedData.intValue() >= minUserSuppliedThisPE) continue;
            minUserSuppliedThisPE = tle.UserSpecifiedData.intValue();
        }
        this.getDataSyncSaveMemUsage(minMemThisPE, maxMemThisPE, minUserSuppliedThisPE, maxUserSuppliedThisPE);
    }

    synchronized void getDataSyncSaveObjectLists(Integer pe, LinkedList perPEObjects, TreeSet userEvents) {
        this.allUserEventObjects.put(pe, userEvents);
        this.allEntryMethodObjects.put(pe, perPEObjects);
    }

    synchronized void getDataSyncSaveMemUsage(long minMemThisPE, long maxMemThisPE, long minUserSuppliedThisPE, long maxUserSuppliedThisPE) {
        if (minMemThisPE < this.minMem) {
            this.minMem = minMemThisPE;
        }
        if (maxMemThisPE > this.maxMem) {
            this.maxMem = maxMemThisPE;
        }
        if (minUserSuppliedThisPE < this.minUserSupplied) {
            this.minUserSupplied = minUserSuppliedThisPE;
        }
        if (maxUserSuppliedThisPE > this.maxUserSupplied) {
            this.maxUserSupplied = maxUserSuppliedThisPE;
        }
        if (this.memoryUsageValid()) {
            System.out.println("memory usage seen in the logs ranges from : " + this.minMem / 1024L / 1024L + "MB to " + this.maxMem / 1024L / 1024L + "MB");
        }
    }

    private boolean memoryUsageValid() {
        return this.maxMem != Integer.MIN_VALUE && this.minMem != Integer.MAX_VALUE && this.maxMem != 0L;
    }

    public Color getForegroundColor() {
        if (this.useCustomColors) {
            return this.customForeground;
        }
        return MainWindow.runObject[this.myRun].foreground;
    }

    public int getNumUserEvents() {
        Iterator<TreeSet<UserEventObject>> iter = this.allUserEventObjects.values().iterator();
        int num = 0;
        while (iter.hasNext()) {
            num += iter.next().size();
        }
        return num;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void increaseScaleFactor() {
        this.setScaleFactor((float)((int)(this.getScaleFactor() * 4.0f) + 1) / 4.0f);
    }

    public int lineWidth(int actualDisplayWidth) {
        return actualDisplayWidth - 2 * this.offset();
    }

    public int maxLabelLen() {
        return 70;
    }

    public int numPs() {
        return this.peToLine.size();
    }

    public int numPEs() {
        return MainWindow.runObject[this.myRun].getNumProcessors();
    }

    public int offset() {
        if (this.useMinimalView()) {
            return this.maxLabelLen() / 2;
        }
        return 5 + this.maxLabelLen() / 2;
    }

    public int leftOffset() {
        return this.offset();
    }

    public int topOffset() {
        if (this.useMinimalView() || this.useCompactView()) {
            return 1;
        }
        return 4;
    }

    public int bottomOffset() {
        if (this.useMinimalView() || this.useCompactView()) {
            return 1;
        }
        return 4;
    }

    public int scaledScreenWidth(int actualDisplayWidth) {
        this.mostRecentScaledScreenWidth = (int)((float)actualDisplayWidth * this.scaleFactor);
        return this.mostRecentScaledScreenWidth;
    }

    public int screenHeight() {
        return this.singleTimelineHeight() * this.numPs();
    }

    public int barheight() {
        if (this.useCompactView()) {
            return 12;
        }
        return 16;
    }

    public int singleTimelineHeight() {
        return this.topOffset() + this.userEventRectHeight() + this.barheight() + this.messageSendHeight() + this.bottomOffset();
    }

    public int userEventRectHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        if (this.drawNestedUserEventRows) {
            return 12 * this.getNumUserEventRows();
        }
        return 8 * this.getNumUserEventRows();
    }

    public void setHandler(MainHandler rh) {
        this.modificationHandler = rh;
        this.displayMustBeRedrawn();
    }

    public void setNewRange(long beginTime, long endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.setScaleFactor(1.0f);
    }

    public void setRange(long beginTime, long endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public void setScaleFactor(float scale_) {
        this.scaleFactor = scale_;
        if ((double)this.scaleFactor < 1.0) {
            this.scaleFactor = 1.0f;
        }
        this.displayMustBeRedrawn();
    }

    public long startTime() {
        return this.beginTime();
    }

    public long totalTime() {
        return this.endTime - this.beginTime;
    }

    public boolean selectionValid() {
        return this.selection1 >= 0 && this.selection2 >= 0 && this.selection1 != this.selection2;
    }

    public boolean highlightValid() {
        return this.highlight >= 0;
    }

    public void invalidateSelection() {
        this.selection1 = -1;
        this.selection2 = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    public int leftSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection1;
        }
        return this.selection2;
    }

    public int rightSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection2;
        }
        return this.selection1;
    }

    public void setSelection1(int value) {
        this.selection1 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void setSelection2(int value) {
        this.selection2 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void removeHighlight() {
        this.highlight = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    public void setHighlight(int x) {
        this.highlight = x;
        this.modificationHandler.refreshDisplay(false);
    }

    public int getHighlight() {
        return this.highlight;
    }

    public double getHighlightTime() {
        return this.screenToTime(this.getHighlight());
    }

    public double leftSelectionTime() {
        return this.screenToTime(this.leftSelection());
    }

    public double rightSelectionTime() {
        return this.screenToTime(this.rightSelection());
    }

    public long screenToTime(int xPixelCoord) {
        double fractionAlongAxis = (double)(xPixelCoord - this.leftOffset()) / (double)(this.mostRecentScaledScreenWidth - 2 * this.offset());
        return Math.round((double)this.beginTime + fractionAlongAxis * (double)(this.endTime - this.beginTime));
    }

    public int timeToScreenPixelRight(double time) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelLeft(double time) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixel(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelLeft(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelRight(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public void setPreferredViewTimeCenter(double time) {
        if (time > (double)this.beginTime && time < (double)this.endTime) {
            this.preferredViewTime = time;
        }
    }

    public int getNewPreferredViewCenter(int newScreenWidth) {
        double value = this.preferredViewTime;
        int coord = this.timeToScreenPixel(value, newScreenWidth);
        return coord;
    }

    public void resetPreferredView() {
        this.preferredViewTime = -1.0;
    }

    public boolean hasNewPreferredView() {
        return this.preferredViewTime >= 0.0 && (double)this.scaleFactor > 1.0;
    }

    public void setUseMinimalMargins(boolean useMinimalMargins) {
        this.useMinimalView = useMinimalMargins;
    }

    public void keepViewCentered(boolean b) {
        this.keepViewCentered = b;
    }

    public boolean keepViewCentered() {
        return this.keepViewCentered;
    }

    public int messageSendHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        return 5;
    }

    public int messagePackHeight() {
        return 3;
    }

    public void clickTraceSender(EntryMethodObject obj) {
        if (!this.useMinimalView()) {
            this.addProcessor(obj.pCreation);
            this.toggleMessageSendLine(obj);
        }
    }

    public void clearObjectHighlights() {
        this.highlightedObjects.clear();
    }

    public void HighlightObjects(Set objects) {
        this.highlightedObjects.addAll(objects);
    }

    public boolean isObjectDimmed(Object o) {
        if (this.highlightedObjects.size() == 0) {
            return false;
        }
        return !this.highlightedObjects.contains(o);
    }

    public boolean traceMessagesBackOnHover() {
        return this.traceMessagesBackOnHover;
    }

    public boolean traceMessagesForwardOnHover() {
        return this.traceMessagesForwardOnHover;
    }

    public boolean traceOIDOnHover() {
        return this.traceOIDOnHover;
    }

    public void setTraceMessagesBackOnHover(boolean traceMessagesOnHover) {
        this.traceMessagesBackOnHover = traceMessagesOnHover;
        if (traceMessagesOnHover) {
            this.SetToolTipDelayLarge();
        } else {
            this.SetToolTipDelaySmall();
        }
    }

    public void setTraceMessagesForwardOnHover(boolean traceMessagesForwardOnHover) {
        this.traceMessagesForwardOnHover = traceMessagesForwardOnHover;
        if (traceMessagesForwardOnHover) {
            this.SetToolTipDelayLarge();
        } else {
            this.SetToolTipDelaySmall();
        }
    }

    public void setTraceOIDOnHover(boolean showOIDOnHover) {
        this.traceOIDOnHover = showOIDOnHover;
    }

    public void SetToolTipDelaySmall() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(600000);
    }

    public void SetToolTipDelayLarge() {
        ToolTipManager.sharedInstance().setInitialDelay(2000);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    public Color getMessageColor() {
        return Color.white;
    }

    public Color getMessageAltColor() {
        return Color.yellow;
    }

    public void showUserEvents(boolean b) {
        this.showUserEvents = b;
    }

    public boolean showUserEvents() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showUserEvents;
    }

    public void setColorByDefault() {
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.displayMustBeRepainted();
    }

    public void setColorByMemoryUsage() {
        if (this.memoryUsageValid()) {
            this.colorByMemoryUsage = true;
            this.colorByObjectId = false;
            this.colorByUserSupplied = false;
            this.displayMustBeRepainted();
        } else {
            this.modificationHandler.displayWarning("No memory usage entries found. Use traceMemoryUsage() and gnu malloc in the application");
        }
    }

    public void setColorByUserSupplied(int colorScheme) {
        this.colorSchemeForUserSupplied = colorScheme;
        this.colorByUserSupplied = true;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.displayMustBeRepainted();
    }

    public void setColorByIndex() {
        this.colorByObjectId = true;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.displayMustBeRepainted();
    }

    public boolean colorByUserSupplied() {
        return this.colorByUserSupplied;
    }

    public boolean colorByMemoryUsage() {
        return this.colorByMemoryUsage;
    }

    public void fixTachyons() {
        System.out.println("The fix tachyons feature is still experimental. It will probably not work well if new processors are loaded, or ranges are changed");
        int numIterations = 100;
        long threshold_us = 10L;
        System.out.println("Executing at most " + numIterations + " times or until no tachyons longer than " + threshold_us + "us are found");
        for (int iteration = 0; iteration < numIterations; ++iteration) {
            long minLatency = Integer.MAX_VALUE;
            int minSender = -1;
            int minDest = -1;
            for (Integer pe : this.allEntryMethodObjects.keySet()) {
                LinkedList objs = (LinkedList)this.allEntryMethodObjects.get(pe);
                for (EntryMethodObject obj : objs) {
                    TimelineMessage m = obj.creationMessage();
                    if (m == null) continue;
                    long sendTime = m.Time;
                    long executeTime = obj.getBeginTime();
                    long latency = executeTime - sendTime;
                    int senderPE = m.srcPE;
                    int executingPE = obj.pCurrent;
                    if (minLatency <= latency) continue;
                    minLatency = latency;
                    minSender = senderPE;
                    minDest = executingPE;
                }
            }
            System.out.println("Processor " + minDest + " is lagging behind by " + -1L * minLatency + "us");
            Integer laggingPE = new Integer(minDest);
            long shift = -1L * minLatency;
            if (shift < threshold_us) {
                System.out.println("No tachyons go back further than " + threshold_us + " us");
                break;
            }
            for (EntryMethodObject e : (LinkedList)this.allEntryMethodObjects.get(laggingPE)) {
                e.shiftTimesBy(shift);
                for (TimelineMessage msg : e.messages) {
                    msg.shiftTimesBy(shift);
                }
            }
            for (UserEventObject obj : this.allUserEventObjects.get(laggingPE)) {
                obj.shiftTimesBy(shift);
            }
        }
        this.displayMustBeRedrawn();
    }

    public void setCompactView(boolean b) {
        this.useCompactView = b;
        this.displayMustBeRedrawn();
    }

    public boolean showPacks() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showPacks;
    }

    public boolean showMsgs() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showMsgs;
    }

    public boolean showIdle() {
        return this.showIdle;
    }

    public void showIdle(boolean b) {
        this.showIdle = b;
    }

    public void showPacks(boolean b) {
        this.showPacks = b;
    }

    public void showMsgs(boolean b) {
        this.showMsgs = b;
    }

    public boolean useCompactView() {
        return this.useCompactView;
    }

    public void guiRoot(TimelineWindow timelineWindow) {
        this.guiRoot = timelineWindow;
    }

    public int whichTimelineVerticalPosition(int PE) {
        if (this.peToLine == null) {
            throw new RuntimeException("peToLine is null");
        }
        if (!this.peToLine.contains(new Integer(PE))) {
            throw new RuntimeException("peToLine does not contain pe " + PE);
        }
        return this.peToLine.indexOf(new Integer(PE));
    }

    public int whichPE(int verticalPosition) {
        Integer which = (Integer)this.peToLine.get(verticalPosition);
        return which;
    }

    public void movePEToLine(int PE, int newPos) {
        Integer p = new Integer(PE);
        this.peToLine.remove(p);
        this.peToLine.add(newPos, p);
        this.displayMustBeRedrawn();
    }

    public void setBackgroundColor(Color c) {
        this.customBackground = c;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setForegroundColor(Color c) {
        this.customForeground = c;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setColors(Color backgroundColor, Color foregroundColor) {
        this.setBackgroundColor(backgroundColor);
        this.setForegroundColor(foregroundColor);
    }

    public void printUserEventInfo() {
        System.out.println("printUserEventInfo()");
        HashMap<Integer, Long> min = new HashMap<Integer, Long>();
        HashMap<Integer, Long> max = new HashMap<Integer, Long>();
        HashMap<Integer, Long> total = new HashMap<Integer, Long>();
        HashMap<Integer, Long> count = new HashMap<Integer, Long>();
        HashMap<Integer, String> name = new HashMap<Integer, String>();
        for (Integer pe : this.allUserEventObjects.keySet()) {
            for (UserEventObject obj : this.allUserEventObjects.get(pe)) {
                if (obj.Type != 2) continue;
                long BeginTime = obj.BeginTime;
                long EndTime = obj.EndTime;
                Integer UserEventID = new Integer(obj.UserEventID);
                long duration = EndTime - BeginTime;
                if (!min.containsKey(UserEventID)) {
                    min.put(UserEventID, new Long(duration));
                    max.put(UserEventID, new Long(duration));
                    total.put(UserEventID, new Long(duration));
                    count.put(UserEventID, new Long(1L));
                    name.put(UserEventID, obj.getName());
                    continue;
                }
                if ((Long)min.get(UserEventID) > duration) {
                    min.put(UserEventID, new Long(duration));
                }
                if ((Long)max.get(UserEventID) < duration) {
                    max.put(UserEventID, new Long(duration));
                }
                total.put(UserEventID, (Long)total.get(UserEventID) + new Long(duration));
                count.put(UserEventID, (Long)count.get(UserEventID) + new Long(1L));
            }
        }
        for (Integer UserEventID : min.keySet()) {
            double avg = ((Long)total.get(UserEventID)).doubleValue() / ((Long)count.get(UserEventID)).doubleValue();
            System.out.print("User Event #" + UserEventID + "  \"" + name.get(UserEventID) + "\"");
            System.out.print("    count = " + count.get(UserEventID));
            System.out.print("    min   = " + min.get(UserEventID) + " us");
            System.out.print("    max   = " + max.get(UserEventID) + " us");
            System.out.print("    avg   = " + avg + " us");
            System.out.print("    total = " + total.get(UserEventID) + " us");
            System.out.println();
        }
    }

    public int determineUserEventNestings() {
        int maxDepth = 0;
        for (Integer pe : this.allUserEventObjects.keySet()) {
            Stack<Long> activeEndTimes = new Stack<Long>();
            for (UserEventObject obj : this.allUserEventObjects.get(pe)) {
                if (obj.Type != 2) continue;
                long BeginTime = obj.BeginTime;
                long EndTime = obj.EndTime;
                while (activeEndTimes.size() > 0 && (Long)activeEndTimes.peek() <= BeginTime) {
                    activeEndTimes.pop();
                }
                activeEndTimes.push(EndTime);
                obj.setNestedRow(activeEndTimes.size() - 1);
                if (activeEndTimes.size() <= maxDepth) continue;
                maxDepth = activeEndTimes.size();
            }
        }
        return maxDepth;
    }

    public void showNestedUserEvents(boolean b) {
        this.drawNestedUserEventRows = b;
        if (b) {
            this.setNumUserEventRows(this.determineUserEventNestings());
        } else {
            this.setNumUserEventRows(1);
        }
        this.displayMustBeRedrawn();
    }

    public void setNumUserEventRows(int numUserEventRows) {
        this.numUserEventRows = numUserEventRows;
    }

    public int getNumUserEventRows() {
        return this.numUserEventRows;
    }

    public int entryMethodLocationTop(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.userEventRectHeight();
    }

    public int entryMethodLocationHeight() {
        return this.barheight() + this.messageSendHeight();
    }

    public int userEventLocationTop(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset();
    }

    public int userEventLocationBottom(int pe) {
        return this.userEventLocationTop(pe) + this.userEventRectHeight();
    }

    public int horizontalLineLocationTop(int i) {
        return this.singleTimelineHeight() * i + this.topOffset() + this.userEventRectHeight() + this.barheight() / 2;
    }

    public int messageSendLocationY(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.userEventRectHeight() + this.barheight() + this.messageSendHeight();
    }

    public int messageRecvLocationY(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.userEventRectHeight();
    }

    public void dropPEsUnrelatedToPE(Integer pe) {
        this.dropPEsUnrelatedToObjects((Collection)this.allEntryMethodObjects.get(pe));
    }

    public void dropPEsUnrelatedToObject(EntryMethodObject obj) {
        System.out.println("dropPEsUnrelatedToObject()");
        HashSet<EntryMethodObject> set = new HashSet<EntryMethodObject>();
        set.add(obj);
        this.dropPEsUnrelatedToObjects(set);
    }

    public void dropPEsUnrelatedToObjects(Collection<EntryMethodObject> objs) {
        System.out.println("dropPEsUnrelatedToObjects()");
        HashSet<EntryMethodObject> allRelatedEntries = new HashSet<EntryMethodObject>();
        for (EntryMethodObject obj : objs) {
            allRelatedEntries.add(obj);
            allRelatedEntries.addAll(obj.traceForwardDependencies());
            allRelatedEntries.addAll(obj.traceBackwardDependencies());
        }
        HashSet<Integer> relatedPEs = new HashSet<Integer>();
        for (EntryMethodObject o : allRelatedEntries) {
            relatedPEs.add(o.pCurrent);
        }
        this.dropPEsNotInList(relatedPEs);
    }

    void dropPEsNotInList(Set keepPEs) {
        HashSet currentPEs = new HashSet();
        currentPEs.addAll(this.peToLine);
        for (Integer p : currentPEs) {
            if (keepPEs.contains(p)) continue;
            this.peToLine.remove(p);
        }
        this.modificationHandler.notifyProcessorListHasChanged();
    }

    public Hashtable<Integer, String> getEntryNames() {
        Hashtable entryNames = MainWindow.runObject[this.myRun].getSts().getEntryNames();
        Hashtable entryChareNames = MainWindow.runObject[this.myRun].getSts().getEntryChareNames();
        Hashtable<Integer, String> result = new Hashtable<Integer, String>();
        for (Integer id : entryNames.keySet()) {
            result.put(id, entryNames.get(id) + "::" + entryChareNames.get(id));
        }
        return result;
    }

    public void makeEntryVisibleID(Integer id) {
        this.hiddenEntryPoints.remove(id);
        this.displayMustBeRepainted();
    }

    public void makeEntryInvisibleID(Integer id) {
        this.hiddenEntryPoints.add(id);
        this.displayMustBeRepainted();
    }

    public boolean entryIsHiddenID(Integer id) {
        return this.hiddenEntryPoints.contains(id);
    }

    public boolean entryIsVisibleID(Integer id) {
        return !this.hiddenEntryPoints.contains(id);
    }
}

