/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

public class TimelineMessage
implements Comparable {
    public long Time;
    public int Entry;
    public int MsgLen;
    public int EventID;
    public int SenderEventID;
    private int[] destPEs;
    private int numPEs;
    public int srcPE;

    public TimelineMessage(int srcPE, int senderEventID, long t, int e, int mlen, int EventID) {
        this(srcPE, senderEventID, t, e, mlen, EventID, null);
    }

    public TimelineMessage(int srcPE, int senderEventID, long t, int e, int mlen, int EventID, int[] destPEs) {
        this.SenderEventID = senderEventID;
        this.srcPE = srcPE;
        this.Time = t;
        this.Entry = e;
        this.MsgLen = mlen;
        this.EventID = EventID;
        this.numPEs = destPEs != null ? destPEs.length : 0;
        this.destPEs = destPEs;
    }

    public TimelineMessage(int srcPE, int senderEventID, long t, int e, int mlen, int EventID, int numPEs) {
        this.SenderEventID = senderEventID;
        this.Time = t;
        this.srcPE = srcPE;
        this.Entry = e;
        this.MsgLen = mlen;
        this.EventID = EventID;
        this.numPEs = numPEs;
        this.destPEs = null;
    }

    public int compareTo(Object o) {
        TimelineMessage other = (TimelineMessage)o;
        if (this.srcPE == other.srcPE) {
            return this.EventID - other.EventID;
        }
        return this.srcPE - other.srcPE;
    }

    public String destination(int totalPE) {
        if (this.isMulticast()) {
            String ds = "";
            for (int i = 0; i < this.numPEs; ++i) {
                ds = ds + this.destPEs[i];
                if (i >= this.numPEs - 1) continue;
                ds = ds + ",";
            }
            return "Multicast to " + this.numPEs + " PEs: " + ds;
        }
        if (this.isBroadcast()) {
            if (this.numPEs == totalPE) {
                return "Group Broadcast";
            }
            return "NodeGroup Broadcast";
        }
        return "Unicast to unknown";
    }

    public boolean isBroadcast() {
        return this.numPEs > 0 && this.destPEs == null;
    }

    public boolean isMulticast() {
        return this.numPEs > 0 && this.destPEs != null;
    }

    public boolean isUnicast() {
        return this.numPEs == 0;
    }

    public void shiftTimesBy(long shift) {
        this.Time += shift;
    }
}

