/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import projections.gui.MainWindow;
import projections.gui.Timeline.Data;

public class UserEventObject
extends JComponent
implements Comparable,
MouseListener,
ActionListener {
    static int myRun = 0;
    public static final int SINGLE = 1;
    public static final int PAIR = 2;
    public int Type;
    public long BeginTime;
    public long EndTime;
    public int UserEventID;
    public int CharmEventID;
    private Data data;
    private int pe;
    private String note;
    static final String popupChangeColor = "Change Color";
    private int nestedRow;

    public UserEventObject(int pe, long t, int e, int event, int type) {
        this.setFocusable(false);
        this.Type = type;
        this.BeginTime = this.EndTime = t;
        this.UserEventID = e;
        this.CharmEventID = event;
        this.pe = pe;
        this.addMouseListener(this);
    }

    public UserEventObject(int pe, long t, String note) {
        this.setFocusable(false);
        this.BeginTime = this.EndTime = t;
        this.pe = pe;
        this.note = note;
        this.addMouseListener(this);
    }

    public String getName() {
        if (this.note != null) {
            return this.note;
        }
        if (MainWindow.runObject[myRun].getUserEventName(this.UserEventID) == null) {
            return "";
        }
        return MainWindow.runObject[myRun].getUserEventName(this.UserEventID);
    }

    public Color getColor() {
        Color c = MainWindow.runObject[myRun].getUserEventColor(this.UserEventID);
        if (c != null) {
            return c;
        }
        return Color.white;
    }

    public void setLocationAndSize(Data data, int actualDisplayWidth) {
        this.data = data;
        int left = data.timeToScreenPixel(this.BeginTime, actualDisplayWidth);
        int rightCoord = data.timeToScreenPixel(this.EndTime, actualDisplayWidth);
        if (this.EndTime > data.endTime()) {
            rightCoord = data.timeToScreenPixel(data.endTime(), actualDisplayWidth) - 5;
        }
        if (this.BeginTime < data.beginTime()) {
            left = data.timeToScreenPixel(data.beginTime(), actualDisplayWidth) + 5;
        }
        int width = rightCoord - left + 1;
        int heightPerRow = data.userEventRectHeight() / data.getNumUserEventRows();
        int bottom = data.userEventLocationBottom(this.pe);
        if (data.drawNestedUserEventRows) {
            bottom -= heightPerRow * this.nestedRow;
        }
        int top = bottom - heightPerRow;
        int height = heightPerRow;
        if (this.getName().contains("***")) {
            top = 3;
            height = data.screenHeight() - top;
        }
        if (this.note == null) {
            this.setToolTipText("<html><body><p><i>User Traced Event:</i> <b>" + this.getName() + "</b></p><p><i>Duration:</i> " + (this.EndTime - this.BeginTime) + " us</p><p><i>event:</i> " + this.UserEventID + "</p><p><i>occurred on PE:</i> " + this.pe + "</p></html></body>");
        } else {
            this.setToolTipText("<html><body><p><i>User Supplied Note:</i></p><p></p>" + this.note + "</html></body>");
        }
        this.setBounds(left, top, width, height);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.data.showUserEvents()) {
            g.setColor(this.getColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.getName() != null) {
                int leftpad = 3;
                int rightpad = 3;
                int toppad = 1;
                int bottompad = 1;
                int fontsize = this.getHeight() - toppad - bottompad;
                g.setFont(this.data.labelFont);
                FontMetrics fm = g.getFontMetrics();
                int stringWidth = fm.stringWidth(this.getName());
                if (fontsize >= 9 && stringWidth < this.getWidth() - leftpad - rightpad) {
                    g.setColor(Color.black);
                    g.drawString(this.getName(), leftpad, toppad + fontsize);
                    g.setPaintMode();
                }
            }
        }
    }

    public void shiftTimesBy(long shift) {
        this.BeginTime += shift;
        this.EndTime += shift;
    }

    public int compareTo(Object o) {
        UserEventObject ueo = (UserEventObject)o;
        if (this.pe != ueo.pe) {
            return this.pe - ueo.pe;
        }
        if (this.BeginTime != ueo.BeginTime) {
            return (int)(this.BeginTime - ueo.BeginTime);
        }
        if (this.EndTime != ueo.EndTime) {
            return (int)(ueo.EndTime - this.EndTime);
        }
        if (this != ueo) {
            return this.UserEventID - ueo.UserEventID;
        }
        System.err.println("ERROR: compareTo not working correctly for class UserEventObject");
        return 0;
    }

    public void setNestedRow(int row) {
        this.nestedRow = row;
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getModifiers() != 16) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(popupChangeColor);
            menuItem.addActionListener(this);
            popup.add(menuItem);
            popup.show(this, evt.getX(), evt.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Color c;
        String arg;
        if (e.getSource() instanceof JMenuItem && (arg = ((JMenuItem)e.getSource()).getText()).equals(popupChangeColor) && (c = JColorChooser.showDialog(null, "Choose color for " + this.getName(), this.getColor())) != null) {
            MainWindow.runObject[myRun].setUserEventColor(this.UserEventID, c);
            this.data.displayMustBeRepainted();
        }
    }
}

