/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class UserEventsWindow
extends GenericGraphWindow
implements ActionListener,
ColorSelectable {
    UserEventsWindow thisWindow;
    static int myRun = 0;
    private JPanel mainPanel;
    private JPanel controlPanel;
    int startInterval;
    int endInterval;
    long intervalSize;
    OrderedIntList processorList;
    private int numActivities = MainWindow.runObject[myRun].getNumUserDefinedEvents();
    private String[] activityNames = MainWindow.runObject[myRun].getUserEventNames();
    private double[][] graphData;
    private long[][] numCalls;
    private Color[] graphColors = ColorManager.createColorMap(this.numActivities);

    public UserEventsWindow(MainWindow mainWindow) {
        super("Projections User Events Tool - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    private void createLayout() {
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        JPanel graphPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
    }

    protected void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(mbar);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (UserEventsWindow.this.dialog.isModified()) {
                        UserEventsWindow.this.constructToolData();
                    }
                    return null;
                }

                public void finished() {
                    UserEventsWindow.this.setGraphSpecificData();
                    UserEventsWindow.this.thisWindow.setVisible(true);
                }
            };
            worker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = dialog.getIntervalSize();
        this.startInterval = (int)dialog.getStartInterval();
        this.endInterval = (int)dialog.getEndInterval();
        this.processorList = dialog.getValidProcessors();
        super.getDialogData();
    }

    public void setDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        dialog.setIntervalSize(this.intervalSize);
        dialog.setValidProcessors(this.processorList);
        super.setDialogData();
    }

    void constructToolData() {
        int nextPe = 0;
        int count = 0;
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[UserEventsWindow.myRun].guiRoot, "Reading log files", "", 0, this.processorList.size());
        progressBar.setNote("Reading");
        progressBar.setProgress(0);
        this.graphData = new double[this.processorList.size()][];
        this.numCalls = new long[this.processorList.size()][];
        while (this.processorList.hasMoreElements()) {
            nextPe = this.processorList.nextElement();
            progressBar.setProgress(count);
            progressBar.setNote("[PE: " + nextPe + " ] Reading Data.");
            if (progressBar.isCanceled()) {
                return;
            }
            this.graphData[count] = new double[this.numActivities];
            this.numCalls[count] = new long[this.numActivities];
            GenericLogReader reader = new GenericLogReader(nextPe, MainWindow.runObject[myRun].getVersion());
            try {
                LogEntryData logData = reader.nextEventOfType(100);
                LogEntryData logDataEnd = reader.nextEventOfType(100);
                while (logData.time < (long)this.startInterval * this.intervalSize) {
                    logData = reader.nextEventOfType(100);
                    logDataEnd = reader.nextEventOfType(100);
                }
                int eventIndex = 0;
                do {
                    eventIndex = MainWindow.runObject[myRun].getUserDefinedEventIndex(logData.userEventID);
                    double[] dArray = this.graphData[count];
                    int n = eventIndex;
                    dArray[n] = dArray[n] + (double)(logDataEnd.time - logData.time);
                    long[] lArray = this.numCalls[count];
                    int n2 = eventIndex;
                    lArray[n2] = lArray[n2] + 1L;
                    logData = reader.nextEventOfType(100);
                    logDataEnd = reader.nextEventOfType(100);
                } while (logDataEnd.time <= (long)this.endInterval * this.intervalSize);
                reader.close();
            }
            catch (EOFException e) {
                try {
                    reader.close();
                }
                catch (IOException evt) {
                    System.err.println("ERROR: UserEvents Window failed to read log file for processor " + nextPe);
                    System.err.println(e);
                    System.exit(-1);
                }
            }
            catch (IOException e) {
                System.err.println("ERROR: UserEvents Window failed to read log file for processor " + nextPe);
                System.err.println(e);
                System.exit(-1);
            }
            ++count;
        }
        progressBar.close();
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Processors", this.processorList);
        this.setYAxis("Time (us)", "us");
        this.setDataSource("User Events", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public void applyDialogColors() {
        this.setDataSource("User Events", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        String[] rString = new String[]{"Name: " + this.activityNames[yVal], "Time Spent: " + U.t((long)this.graphData[xVal][yVal]), "Count: " + this.numCalls[xVal][yVal]};
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JButton) && e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }
}

