/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import projections.gui.MainWindow;

public class Util {
    static int myRun = 0;

    public static void gblAdd(Container target, Component c, GridBagConstraints gbc, int x, int y, int dx, int dy, int wx, int wy) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = dx;
        gbc.gridheight = dy;
        gbc.weightx = wx;
        gbc.weighty = wy;
        target.add(c, gbc);
    }

    public static void gblAdd(Container target, Component c, GridBagConstraints gbc, int x, int y, int dx, int dy, int wx, int wy, int I1, int I2, int I3, int I4) {
        Insets oldInsets = gbc.insets;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = dx;
        gbc.gridheight = dy;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.insets = new Insets(I1, I2, I3, I4);
        target.add(c, gbc);
        gbc.insets = oldInsets;
    }

    public static int getBestIncrement(int initialIncrement) {
        int[] indices = new int[]{1, 2, 5, 25};
        int best = -1;
        for (int i = 0; i < indices.length; ++i) {
            int t = 0;
            int sum = 0;
            while ((sum = (int)((double)indices[i] * Math.pow(10.0, t))) < initialIncrement) {
                ++t;
            }
            if (sum - initialIncrement >= best - initialIncrement && best >= 0) continue;
            best = sum;
        }
        return best;
    }

    public static Menu makeMenu(Object parent, Object[] items, Object target) {
        Menu m = null;
        if (parent instanceof Menu) {
            m = (Menu)parent;
        } else if (parent instanceof String) {
            m = new Menu((String)parent);
        } else {
            return null;
        }
        for (int i = 0; i < items.length; ++i) {
            MenuItem mi;
            if (items[i] instanceof String) {
                mi = new MenuItem((String)items[i]);
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
                continue;
            }
            if (items[i] instanceof CheckboxMenuItem && target instanceof ItemListener) {
                CheckboxMenuItem cmi = (CheckboxMenuItem)items[i];
                cmi.addItemListener((ItemListener)target);
                m.add(cmi);
                continue;
            }
            if (items[i] instanceof MenuItem) {
                mi = (MenuItem)items[i];
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
                continue;
            }
            if (items[i] != null) continue;
            m.addSeparator();
        }
        return m;
    }

    public static JMenu makeJMenu(Object parent, Object[] items, boolean[] enabled, Object target) {
        JMenu m = null;
        if (parent instanceof JMenu) {
            m = (JMenu)parent;
        } else if (parent instanceof String) {
            m = new JMenu((String)parent);
        } else {
            return null;
        }
        for (int i = 0; i < items.length; ++i) {
            JMenuItem cmi;
            JMenuItem mi;
            if (items[i] instanceof String) {
                mi = new JMenuItem((String)items[i]);
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
                continue;
            }
            if (items[i] instanceof JCheckBoxMenuItem && target instanceof ItemListener) {
                cmi = (JCheckBoxMenuItem)items[i];
                cmi.addItemListener((ItemListener)target);
                m.add(cmi);
                continue;
            }
            if (items[i] instanceof JRadioButtonMenuItem) {
                cmi = (JRadioButtonMenuItem)items[i];
                cmi.addActionListener((ActionListener)target);
                m.add(cmi);
                continue;
            }
            if (items[i] instanceof JMenuItem) {
                mi = (JMenuItem)items[i];
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
                continue;
            }
            if (items[i] instanceof String[]) {
                String[] subMenuStr = (String[])items[i];
                JMenu subMenu = new JMenu(subMenuStr[0]);
                m.add(subMenu);
                for (int index = 1; index < subMenuStr.length; ++index) {
                    JMenuItem mi2 = new JMenuItem(subMenuStr[index]);
                    if (target instanceof ActionListener) {
                        mi2.addActionListener((ActionListener)target);
                    }
                    subMenu.add(mi2);
                }
                continue;
            }
            if (items[i] != null) continue;
            m.addSeparator();
        }
        return m;
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean[] andFilters(boolean[] filter1, boolean[] filter2) {
        boolean[] newFilter = new boolean[filter1.length];
        for (int i = 0; i < newFilter.length; ++i) {
            newFilter[i] = filter1[i] && filter2[i];
        }
        return newFilter;
    }

    public static void saveColors(Color[] colors, String graphType, String filePath) throws IOException {
        File filename = new File("bin/color.map");
        int again = filePath == null ? 0 : 1;
        do {
            boolean fileExists = filename.exists();
            RandomAccessFile accessFile = new RandomAccessFile(filename, "rw");
            String tempString = new String();
            int numOfGraph = 1;
            String[] typeArray = new String[numOfGraph];
            typeArray[0] = "Timeline Graph";
            if (!fileExists) {
                for (int i = 0; i < numOfGraph; ++i) {
                    accessFile.writeBytes(typeArray[i] + "\n");
                    for (int j = 0; j < colors.length; ++j) {
                        accessFile.writeBytes(j + " ");
                        accessFile.writeBytes(String.valueOf(MainWindow.runObject[myRun].getEntryColor(j).getRed()));
                        accessFile.writeBytes(" ");
                        accessFile.writeBytes(String.valueOf(MainWindow.runObject[myRun].getEntryColor(j).getGreen()));
                        accessFile.writeBytes(" ");
                        accessFile.writeBytes(String.valueOf(MainWindow.runObject[myRun].getEntryColor(j).getBlue()));
                        accessFile.writeBytes(";     ");
                    }
                    accessFile.writeBytes("                    ");
                    accessFile.writeBytes("\n");
                    accessFile.writeBytes("\n");
                }
            }
            long tempLong = 0L;
            accessFile.seek(tempLong);
            for (int i = 0; i < numOfGraph; ++i) {
                if (graphType.compareTo(typeArray[i]) != 0) continue;
                int lineNumber = 3 * i + 1;
                for (int k = 0; k < lineNumber; ++k) {
                    tempString = accessFile.readLine();
                }
                for (int j = 0; j < colors.length; ++j) {
                    accessFile.writeBytes(j + " ");
                    accessFile.writeBytes(String.valueOf(colors[j].getRed()));
                    accessFile.writeBytes(" ");
                    accessFile.writeBytes(String.valueOf(colors[j].getGreen()));
                    accessFile.writeBytes(" ");
                    accessFile.writeBytes(String.valueOf(colors[j].getBlue()));
                    accessFile.writeBytes(";     ");
                }
            }
            if (filePath != null) {
                filename = new File(filePath);
            }
            accessFile.close();
        } while (--again >= 0);
    }

    public static void restoreColors(Color[] colors, String Useless) throws IOException, ClassNotFoundException {
        FileInputStream fileStream = new FileInputStream(MainWindow.runObject[myRun].getLogDirectory() + File.separator + "color.map");
        ObjectInputStream objStream = new ObjectInputStream(fileStream);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = (Color)objStream.readObject();
        }
        objStream.close();
    }
}

