/*
 * Decompiled with CFR 0.152.
 */
package charm.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Vector3d {
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double v) {
        this.y = this.z = v;
        this.x = this.z;
    }

    public Vector3d(double X, double Y, double Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public final void copyFrom(Vector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public final double magSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double magnitude() {
        return Math.sqrt(this.magSqr());
    }

    public final Vector3d normalize() {
        return this.scaleBy(1.0 / this.magnitude());
    }

    public final Vector3d plus(Vector3d a) {
        return new Vector3d(this.x + a.x, this.y + a.y, this.z + a.z);
    }

    public final Vector3d minus(Vector3d a) {
        return new Vector3d(this.x - a.x, this.y - a.y, this.z - a.z);
    }

    public final Vector3d scaleBy(double scale) {
        return new Vector3d(scale * this.x, scale * this.y, scale * this.z);
    }

    public final double dot(Vector3d a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public final Vector3d cross(Vector3d b) {
        return new Vector3d(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public static Vector3d read(DataInputStream is) throws IOException {
        Vector3d ret = new Vector3d();
        ret.x = is.readDouble();
        ret.y = is.readDouble();
        ret.z = is.readDouble();
        return ret;
    }

    public void write(DataOutputStream os) throws IOException {
        os.writeDouble(this.x);
        os.writeDouble(this.y);
        os.writeDouble(this.z);
    }
}

