/*
 * Decompiled with CFR 0.152.
 */
package charm.ccs;

import charm.ccs.CcsServer;
import charm.ccs.PythonAbstract;
import charm.ccs.PythonIterator;

public class PythonExecute
extends PythonAbstract {
    private static final int localmagic = 37492037;
    private int codeLength;
    private String code;
    private int methodNameLength;
    private String methodName;
    private int infoSize;
    private PythonIterator info;
    private int interpreter;
    private byte flags;
    private static final int memorySize = 48;
    private static final byte FLAG_PERSISTENT = -128;
    private static final byte FLAG_KEEPPRINT = 64;
    private static final byte FLAG_HIGHLEVEL = 32;
    private static final byte FLAG_ITERATE = 16;
    private static final byte FLAG_WAIT = 8;

    public PythonExecute(String string, boolean bl, boolean bl2, int n) {
        this.magic = 37492085;
        this.codeLength = string.length();
        this.code = string;
        this.methodNameLength = 0;
        this.infoSize = 0;
        this.flags = 0;
        if (bl) {
            this.flags = (byte)(this.flags | 0xFFFFFF80);
            this.flags = (byte)(this.flags | 0x40);
        }
        if (bl2) {
            this.flags = (byte)(this.flags | 0x20);
        }
        this.interpreter = n;
    }

    public PythonExecute(String string, String string2, PythonIterator pythonIterator, boolean bl, boolean bl2, int n) {
        this.magic = 37492085;
        this.codeLength = string.length();
        this.code = string;
        this.methodNameLength = string2.length();
        this.methodName = string2;
        this.infoSize = pythonIterator.size();
        this.info = pythonIterator;
        this.flags = 0;
        if (bl) {
            this.flags = (byte)(this.flags | 0xFFFFFF80);
            this.flags = (byte)(this.flags | 0x40);
        }
        if (bl2) {
            this.flags = (byte)(this.flags | 0x20);
        }
        this.interpreter = n;
    }

    public void setCode(String string) {
        this.codeLength = string.length();
        this.code = string;
    }

    public void setMethodName(String string) {
        this.methodNameLength = string.length();
        this.methodName = string;
    }

    public void setIterator(PythonIterator pythonIterator) {
        this.infoSize = pythonIterator.size();
        this.info = pythonIterator;
    }

    public void setPersistent(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0xFFFFFF80) : (byte)(this.flags & 0x7F);
    }

    public void setIterate(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    public void setHighLevel(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x20) : (byte)(this.flags & 0xFFFFFFDF);
    }

    public void setKeepPrint(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x40) : (byte)(this.flags & 0xFFFFFFBF);
    }

    public void setWait(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    public void setInterpreter(int n) {
        this.interpreter = n;
    }

    public boolean isPersistent() {
        return (this.flags & 0xFFFFFF80) != 0;
    }

    public boolean isIterate() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isHighLevel() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isKeepPrint() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isKeepWait() {
        return (this.flags & 8) != 0;
    }

    public int getInterpreter() {
        return this.interpreter;
    }

    public int size() {
        return 48 + this.codeLength + 1 + this.methodNameLength + 1 + this.infoSize;
    }

    public byte[] pack() {
        byte[] byArray = new byte[this.size()];
        CcsServer.writeInt(byArray, 0, this.magic);
        CcsServer.writeInt(byArray, 4, this.codeLength);
        CcsServer.writeInt(byArray, 16, this.methodNameLength);
        CcsServer.writeInt(byArray, 28, this.infoSize);
        CcsServer.writeInt(byArray, 40, this.interpreter);
        byArray[44] = this.flags;
        CcsServer.writeString(byArray, 48, this.codeLength + 1, this.code);
        if (this.methodNameLength > 0) {
            CcsServer.writeString(byArray, 48 + this.codeLength + 1, this.methodNameLength + 1, this.methodName);
        }
        if (this.infoSize > 0) {
            CcsServer.writeBytes(byArray, 48 + this.codeLength + this.methodNameLength + 2, this.infoSize, this.info.pack());
        }
        return byArray;
    }

    public void unpack() {
    }

    public void print() {
    }
}

