package projector.core;

import java.io.*;
import java.util.*;

/**
 * Author: Arun Singla 
 * May 2, 2002
 */

/**
 * PTCReader  
 * Projector Trace Configuration Reader 
 */
public class PTCReader
{
	private static final int INVALID_EVENT_ID = -1;

 	public int numProcs;		// number of processors the application was run on

	public int maxLangs;		// maximum ID of registered languages
	public int numLangs;		// number of registered languages
	public int [] langIDs;		// id of the languages;
	public String[]   lName;	// languages used in application

	public int   []   maxEvents;// maximum event ID registered for each language
	public int   []   numEvents;// number of events registered for each language
	public String[][] eName;	// events associated with each language

	public PTCReader(String fName) throws AbortException
	{
		BufferedReader inFile;
		try {
		//Debug.print("PTCReader:creating BufferedReader for PTC file ...");

		inFile = new BufferedReader(new FileReader(fName));

		numProcs = Integer.parseInt(inFile.readLine());

		//Debug.print("PTCReader:reading registered languages ...");
		StringTokenizer st = new StringTokenizer(inFile.readLine(), " ");
		maxLangs  = Integer.parseInt(st.nextToken())+1; // maximum languageID + 1
		numLangs  = Integer.parseInt(st.nextToken());
		lName     = new String[maxLangs];
		for(int i=0; i<numLangs; i++) {
			// lName[languageID] = languageName
			lName[Integer.parseInt(st.nextToken())] = st.nextToken();
		}

		// Debug.print("PTCReader:reading registered events ...");
		maxEvents = new int   [maxLangs];
		numEvents = new int   [maxLangs];
		eName     = new String[maxLangs][];
		langIDs = new int[numLangs];
		//initialize 'maxEvents' and 'numEvents'
		for(int i=0; i<maxLangs; i++) {
			maxEvents[i] = numEvents[i] = INVALID_EVENT_ID;
		}

		for(int i=0; i<numLangs; i++) {

			StringTokenizer st1 = new StringTokenizer(inFile.readLine(), " ");
			int lID = Integer.parseInt(st1.nextToken());
			langIDs[i] = lID;
			//Debug.print("PTCReader:reading language "+lID);
			maxEvents[lID] = Integer.parseInt(st1.nextToken())+1; // maximum eventID + 1
			numEvents[lID] = Integer.parseInt(st1.nextToken());
			eName[lID] = new String[maxEvents[lID]];
			for(int j=0; j<numEvents[lID]; j++) {
				// eName[eventType] = eventName;
				
				eName[lID][Integer.parseInt(st1.nextToken())] = st1.nextToken();
			}
		}
		}
		catch(FileNotFoundException e) {
			System.err.println("PTCReader:projector trace configuration file not found ... " + fName);
			throw new AbortException("PTCReader:FileNotFoundException");
		}
		catch(NumberFormatException e) {
			System.err.println("PTCReader:corrupted projector trace configuration file ... " + fName);
			throw new AbortException("PTCReader:NumberFormatException");
		}
		catch(ArrayIndexOutOfBoundsException e) {
			throw new AbortException("PTCReader:ArrayIndexOutOfBoundsException");
		}
		catch(IOException e) {
			System.err.println("PTCReader:corrupted projector trace configuration file ... " + fName);
			throw new AbortException("PTCReader:IOException");
		}

		//close BufferedReader
		try{
		inFile.close();
		}
		catch(IOException e){
			System.err.println("PTCReader:IOException while closing BufferedReader ... " +fName);
			throw new AbortException("PTCReader:IOException");
		}
	}
}

