package test;

import java.io.*;
import projector.core.*;
import projector.charm.*;
import projections.misc.*;
import projections.analysis.*;
import projections.gui.*;

/**
 * Author: Arun Singla 
 * May 2, 2002
 */

public class LogTest 
{
	public static void main(String[] args) 
	{
		Debug.print("LogTest:main ...");
		String path=null, pgm=null;
		int    numProc=0;
		try{
			path = args[0];
			pgm  = args[1];
			numProc = Integer.parseInt(args[2]);
		}
		catch(Exception e) {
			System.err.println("usage: java LogTest path pgm numProc");
			System.exit(1);
		}

		// create TraceReader to read projector log files
		Debug.print("LogTest:main: creating TraceReader");
		TraceReader tReader = null;
		try{
		tReader = new TraceReader(path, pgm);
		} catch(AbortException e) {
			System.err.println(e.eMsg);
			e.printStackTrace();
			System.exit(1);
		}

		CharmEventObject ceObj = new CharmEventObject(); ceObj.language = 2;
		LogEntryData     leObj = new LogEntryData();

		for(int i=0; i<numProc; i++) {
			boolean ceof = false;
			boolean leof = false;
			boolean match = true;
			Debug.print("LogTest:main: comparing log files");
			Debug.print("	"+path+pgm+"."+i+".charm.log");
			Debug.print("	"+path+pgm+"."+i+".log");
			ceObj.proc = i;

			// create GenericLogReader to read projection log files
			GenericLogReader gReader = new GenericLogReader(path+pgm+"."+i+".log", 5.0);

			while(true) {	// while NOT end of 'any' of log files
			// get next event from projector log
			if(!leof) {
			try{
			leObj.type = leObj.mtype = leObj.entry = leObj.event = leObj.pe = leObj.msglen = 0;
			gReader.nextEvent(leObj);
			if(leObj.type == 14 || leObj.type == 15 || leObj.type == 8 || 
			   leObj.type == 9)
			   //leObj.type == 9 || leObj.type == -1)
				continue;
			} catch(EOFException e) {	// end of projections log file
				leof = true;
			} catch(IOException e) {
				System.err.println(e);
				e.printStackTrace();
				System.exit(1);
			}
			}

			// get next event from projector log
			if(match) {
			if(!ceof) {
			try{
			ceObj.eventType = ceObj.mtype = ceObj.entry = ceObj.eventID = ceObj.pe = ceObj.msgLen = 0;
			ceof = !tReader.nextEvent(ceObj);
			} catch(AbortException e) {
				System.err.println(e.eMsg);
				e.printStackTrace();
				System.exit(1);
			}
			}
			}
			
			if(leof && ceof)	// end of both log files
				break;
			if(!leof && !ceof) {
				// compare the events and print if mismatch
				//System.out.println("Comparing ");
				//System.out.println("	PROJECTION:	"+i+", "+leObj.type+", "+leObj.time);
				//System.out.println("	PROJECTOR :	"+ceObj.proc+", "+ceObj.eventType+", "+ceObj.timestamp);

				if(ceObj.eventType != leObj.type) {
					System.out.println("UNMATCHED ===>");
					System.out.println("	PROJECTION:	"+i+", "+leObj.type+", "+leObj.time);
					System.out.println("	PROJECTOR :	"+ceObj.proc+", "+ceObj.eventType+", "+ceObj.timestamp);
					match = false;
				}
				else { 
					match = true;
					if(ceObj.eventType != leObj.type  ||
				   	   ceObj.mtype     != leObj.mtype ||
				       ceObj.entry     != leObj.entry ||
				   	   ceObj.pe 	   != leObj.pe    ||
				   	   ceObj.msgLen    != leObj.msglen) {

					System.out.println("UNMATCHED ===>");
					System.out.println("	PROJECTION:	"+i+", "+leObj.type+", "+leObj.time);
					System.out.println("	PROJECTOR :	"+ceObj.proc+", "+ceObj.eventType+", "+ceObj.timestamp);
					}
				}
			}
			else {	// end of one log file
				System.out.println("UNMATCHED ===>");
				if(!leof)
					System.out.println(" 	PROJECTION:	"+i+", "+leObj.type+", "+leObj.time);
				if(!ceof)
					System.out.println("	PROJECTOR :	"+ceObj.proc+", "+ceObj.eventType+", "+ceObj.timestamp);
			}
			}
		}
	}
}
