package jade.JJ;

import antlr.collections.AST;
import antlr.CommonAST;
import antlr.Token;

public class ASTJ extends CommonAST implements jade.JavaTokenTypes {
    // A flag; has different meaning based on the type of the node.
    // for PACKAGE_DEF, is a mainmodule?
    // for CLASS_DEF, is a mainChare?
    public boolean status = false;
    public boolean isLVALUE = false;

    public void initialize(AST t) {
        super.initialize(t);
        ASTJ tj = (ASTJ)t;
        status = tj.status;
        isLVALUE = tj.isLVALUE;
    }

    // Tracking line numbers does not work yet.
    private int line = 0;
    public void initialize(Token tok) {
        super.initialize(tok);
        line=tok.getLine();
    }
    public int getLine(){
        return line;
    }

    public void print() {
        System.out.println("ASTJ " + toString() + " status=" + status + " isLVALUE=" + isLVALUE );
    }

    /** Index starts at 0. */
    public AST getChild(int index) {
	AST c = this.getFirstChild();
	if ( c==null ) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
	}
	int i = 0;
	while ( c!=null && i<index ) {
            c = c.getNextSibling();
            i++;
	}
	return c;
    }  

    public ASTJ getNode(String s)
    {
        return J.getNode(this, s);
    }

    public int numChildren() {
	AST c = this.getFirstChild();
	int i = 0;
	while ( c!=null ) {
            c = c.getNextSibling();
            i++;
	}
	return i;
    }  

    /** Given a MODIFIERS node, determines if any modifier in it
     * matches the string s. */
    public boolean isX(String s) {
        AST i=this.getFirstChild();
        while(i!=null) {
            if (i.getText().equalsIgnoreCase(s))
                return true;
            i = i.getNextSibling();
        }
        return false;
    }

    public boolean isX(String[] s) {
        AST i=this.getFirstChild();
        while(i!=null) {
            int j;
            for (j=0; j<s.length; j++)
                if (i.getText().equalsIgnoreCase(s[j]))
                    return true;
            i = i.getNextSibling();
        }
        return false;
    }

    /** When 'this' is an ObjBlock, hasMain() will scan the ObjBlock
        for a node of type METHOD_DEF (currently 9) with name
        "main" */
    public boolean hasMain() {
        AST i=this.getFirstChild();
        while(i!=null) {
            if ( (i.getType() == METHOD_DEF)
                 && ((ASTJ)i).getChild(2).getText().equalsIgnoreCase("main"))
                return true;
            i = i.getNextSibling();
        }
        return false;
    }

    public boolean isTypeMSA()
    {
        return this.getType() == TYPE && this.getFirstChild()!=null && J.isStrMSA(this.getFirstChild().getText());
    }

    public String toStringTree(int depth) {
        return toStringList(depth);
    }

    public String toStringList(int depth) {
        AST t = this;
        String ts="";
//         if ( t.getFirstChild()!=null ) ts+=" (";
        for(int i=0; i<depth; i++)
            ts += "  ";
        ts += "(" + ((CommonAST)this).toString()+"\n";
        if ( t.getFirstChild()!=null ) {
            ts += ((ASTJ)t.getFirstChild()).toStringList(depth+1);
        }
//         if ( t.getFirstChild()!=null ) ts+=" )";
        if ( t.getNextSibling()!=null ) {
            ts += ((ASTJ)t.getNextSibling()).toStringList(depth);
        }
        for(int i=0; i<depth; i++)
            ts += "  ";
        ts += ")\n";
        return ts;
    }

}

//     public ASTJ() {
//         super();
//         System.out.println("ASTJ!");
//     }


//     public void genID(StringBuffer sb) {
//         if (getType() == JavaTreeParserTokenTypes.IDENT)
//             sb.append(getText());
//         else if (getType() == DOT) {
//             ((ASTJ)getFirstChild()).genID(sb);
//             sb.append("." + getNextSibling().getText());
//         }
//     }
