/* Declaration of the class that represents the results of the simulation process
 * $Source: /cvsroot/charm-6.1.3/src/ck-ldb/LBSimulation.h,v $
 * $Author: cheelee $
 * $Date: 2008-09-09 21:25:09 $
 * $Revision: 1.6 $
 */
#ifndef SIMRESULTS_H
#define SIMRESULTS_H

#include <charm++.h>
#include "CentralLB.h"

class LBSimulation
{
public:
  static int doSimulation;
  static char* dumpFile;
  static int dumpStep;
  static int dumpStepSize;
  static int simStep;
  static int simStepSize;
  static int simProcs;
  static int procsChanged;

  static int showDecisionsOnly;
public:
  LBSimulation(int numPes_);
  ~LBSimulation();
  void reset();
  void SetProcessorLoad(int pe, double load, double bgload);
  void PrintSimulationResults();
  void PrintDecisions(LBMigrateMsg *m);
  void PrintDifferences(LBSimulation *realSim, BaseLB::LDStats *stats);
private:
  LBInfo  lbinfo;
  int numPes;
  friend class CentralLB;   // so that we don't have to provide little get/put functions
};

#endif /* SIMRESULTS_H */
