/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.pdata;

import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import charm.debug.pdata.ChareTypePList;
import charm.debug.pdata.EpInfo;
import charm.debug.pdata.GenericPList;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class EpPList
extends GenericPList
implements Cloneable {
    protected Vector systemEps = new Vector();
    protected Vector userEps = new Vector();
    private ChareTypePList chareList;

    public Vector getUserEps() {
        return this.userEps;
    }

    public Vector getSystemEps() {
        return this.systemEps;
    }

    public EpInfo getEntryFor(int index) {
        int i;
        for (i = 0; i < this.userEps.size(); ++i) {
            if (((EpInfo)this.userEps.elementAt((int)i)).epIdx != index) continue;
            return (EpInfo)this.userEps.elementAt(i);
        }
        for (i = 0; i < this.systemEps.size(); ++i) {
            if (((EpInfo)this.systemEps.elementAt((int)i)).epIdx != index) continue;
            return (EpInfo)this.systemEps.elementAt(i);
        }
        return null;
    }

    public void setLookups(ChareTypePList chare) {
        this.chareList = chare;
    }

    @Override
    public boolean needRefresh() {
        return false;
    }

    @Override
    public void populate(DefaultListModel model) {
        int i;
        for (i = 0; i < this.userEps.size(); ++i) {
            model.addElement(this.userEps.elementAt(i));
        }
        for (i = 0; i < this.systemEps.size(); ++i) {
            model.addElement(this.systemEps.elementAt(i));
        }
    }

    @Override
    public void load(PList list) {
        this.systemEps.clear();
        this.userEps.clear();
        for (PAbstract cur = list.elementAt(0); cur != null; cur = cur.getNext()) {
            PList lcur = (PList)cur;
            PString name = (PString)lcur.elementNamed("name");
            PNative index = (PNative)lcur.elementNamed("index");
            PNative msgIdx = (PNative)lcur.elementNamed("msgIdx");
            PNative chareIdx = (PNative)lcur.elementNamed("chareIdx");
            PNative inCharm = (PNative)lcur.elementNamed("inCharm");
            if (inCharm.getIntValue(0) == 1) {
                this.systemEps.add(new EpInfo(name.getString(), index.getIntValue(0), msgIdx.getIntValue(0), this.chareList.elementAt(chareIdx.getIntValue(0))));
                continue;
            }
            this.userEps.add(new EpInfo(name.getString(), index.getIntValue(0), msgIdx.getIntValue(0), this.chareList.elementAt(chareIdx.getIntValue(0))));
        }
    }

    public Object clone() {
        int i;
        EpPList ret = new EpPList();
        ret.chareList = this.chareList;
        ret.systemEps = new Vector();
        for (i = 0; i < this.systemEps.size(); ++i) {
            ret.systemEps.add(((EpInfo)this.systemEps.elementAt(i)).clone());
        }
        ret.userEps = new Vector();
        for (i = 0; i < this.userEps.size(); ++i) {
            ret.userEps.add(((EpInfo)this.userEps.elementAt(i)).clone());
        }
        return ret;
    }
}

