/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.LogFileViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import projections.analysis.GenericLogReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

public class LogFileViewerTextArea
extends JPanel {
    static int myRun = 0;
    public JTextPane textPane;
    public JScrollPane scrollPane;

    public LogFileViewerTextArea() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 500));
        String text = new String("<html><body>Log Not Yet Loaded</body></html>");
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setContentType("text/html");
        this.textPane.setText(text);
        this.scrollPane = new JScrollPane(this.textPane);
        this.add((Component)this.scrollPane, "Center");
    }

    public void setPE(int PE, long startTime, long endTime) {
        if (!MainWindow.runObject[myRun].hasLogData()) {
            this.textPane.setText("<h1>ERROR: Don't have any log data</h1>");
            return;
        }
        StringBuilder htmlFormattedTable = new StringBuilder(50000);
        htmlFormattedTable.append("<html><body><font size=+2> All events in log for PE " + PE + " with times between " + startTime + " and " + endTime + "</font>");
        htmlFormattedTable.append("<table><tr><td><h2>Time</h2><td><h2>Event type and description</h2>");
        try {
            GenericLogReader reader = new GenericLogReader(PE, MainWindow.runObject[myRun].getVersion());
            while (true) {
                LogEntryData data = reader.nextEvent();
                if (data.time < startTime || data.time > endTime) continue;
                htmlFormattedTable.append("<tr><td>" + data.time + "<td>");
                htmlFormattedTable.append(data.htmlFormattedDescription());
                if (data.type != 3 && data.type != 15) continue;
                htmlFormattedTable.append("<tr>");
            }
        }
        catch (Exception e) {
            htmlFormattedTable.append("</table></body></html>");
            this.textPane.setText(htmlFormattedTable.toString());
            this.textPane.setSelectionStart(0);
            this.textPane.setSelectionEnd(0);
            return;
        }
    }
}

