/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

public abstract class RealDoubleFFT {
    int n;

    public RealDoubleFFT(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The transform length must be >=0 : " + n);
        }
        this.n = n;
    }

    protected void checkData(double[] data, int i0, int stride) {
        if (i0 < 0) {
            throw new IllegalArgumentException("The offset must be >=0 : " + i0);
        }
        if (stride < 1) {
            throw new IllegalArgumentException("The stride must be >=1 : " + stride);
        }
        if (i0 + stride * (this.n - 1) + 1 > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.n + ":" + "i0=" + i0 + " stride=" + stride + " data.length=" + data.length);
        }
    }

    public void transform(double[] data) {
        this.transform(data, 0, 1);
    }

    public abstract void transform(double[] var1, int var2, int var3);

    public abstract double[] toWraparoundOrder(double[] var1);

    public abstract double[] toWraparoundOrder(double[] var1, int var2, int var3);

    public void backtransform(double[] data) {
        this.backtransform(data, 0, 1);
    }

    public abstract void backtransform(double[] var1, int var2, int var3);

    public double normalization() {
        return 1.0 / (double)this.n;
    }

    public void inverse(double[] data) {
        this.inverse(data, 0, 1);
    }

    public void inverse(double[] data, int i0, int stride) {
        this.backtransform(data, i0, stride);
        double norm = this.normalization();
        for (int i = 0; i < this.n; ++i) {
            int n = i0 + stride * i;
            data[n] = data[n] * norm;
        }
    }
}

