/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import projections.gui.Timeline.Data;

public class ChooseEntriesWindow
extends JFrame {
    Data data;
    Hashtable<Integer, String> entryNames;
    Vector<Vector> tabledata;
    Vector<String> columnNames;

    ChooseEntriesWindow(Data _data) {
        this.data = _data;
        this.createLayout();
    }

    void createLayout() {
        this.setTitle("Choose which entry methods are displayed");
        this.columnNames = new Vector();
        this.columnNames.add(new String("Visible"));
        this.columnNames.add(new String("Entry Method"));
        this.columnNames.add(new String("ID"));
        this.tabledata = new Vector();
        this.entryNames = this.data.getEntryNames();
        for (Integer id : this.entryNames.keySet()) {
            String name = this.entryNames.get(id);
            Vector<Object> tableRow = new Vector<Object>();
            Boolean b = this.data.entryIsVisibleID(id);
            tableRow.add(b);
            tableRow.add(name);
            tableRow.add(id);
            this.tabledata.add(tableRow);
        }
        MyTableModel tableModel = new MyTableModel();
        JTable table = new JTable(tableModel);
        this.initColumnSizes(table);
        JScrollPane scroller = new JScrollPane(table);
        scroller.setHorizontalScrollBarPolicy(30);
        this.setContentPane(scroller);
        this.pack();
        this.setSize(800, 400);
        this.setVisible(true);
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(70);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(680);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return col < 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return ChooseEntriesWindow.this.tabledata.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return ChooseEntriesWindow.this.tabledata.get(rowIndex).get(columnIndex);
        }

        public String getColumnName(int col) {
            return ChooseEntriesWindow.this.columnNames.get(col);
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                Boolean newValue = (Boolean)value;
                Integer id = (Integer)ChooseEntriesWindow.this.tabledata.get(row).get(2);
                if (newValue.booleanValue()) {
                    ChooseEntriesWindow.this.data.makeEntryVisibleID(id);
                } else {
                    ChooseEntriesWindow.this.data.makeEntryInvisibleID(id);
                }
            }
            ChooseEntriesWindow.this.tabledata.get(row).set(col, value);
            this.fireTableCellUpdated(row, col);
        }
    }
}

