/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.AllocationPoint;
import charm.debug.MemoryLog;
import charm.debug.ParDebug;
import charm.debug.inspect.Inspector;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class AllocationTreePanel
extends JPanel {
    private JScrollPane scroll;
    private AllocationPoint root;
    private ByteBuffer buf;
    private JTree tree;

    public AllocationTreePanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 500));
        this.scroll = new JScrollPane();
        this.add(this.scroll);
    }

    public void loadTree(JFrame frame) {
        int inputValue;
        String input = JOptionPane.showInputDialog("Processor to load (-1 for all)");
        try {
            inputValue = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (inputValue == -1) {
            frame.setTitle("Combined Allocation Tree");
        } else {
            frame.setTitle("Allocation Tree Processor " + input);
        }
        if (inputValue == -1) {
            inputValue = 0;
        }
        byte[] allocationTree = ParDebug.server.sendCcsRequestBytes("ccs_debug_allocationTree", input, inputValue);
        this.buf = ByteBuffer.wrap(allocationTree).order(Inspector.getByteOrder());
        this.root = new AllocationPoint(null);
        this.root.readPuppedBuffer(this.buf);
        this.tree = new JTree(this.root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.scroll.setViewportView(this.tree);
    }

    public void loadMemoryLogs(List logs, boolean removeFreed) {
        this.root = new AllocationPoint(null);
        Hashtable<MemoryLog, MemoryLog> allAllocations = new Hashtable<MemoryLog, MemoryLog>();
        if (logs != null) {
            for (MemoryLog log : logs) {
                if (removeFreed && log.getLocation() == 0L) {
                    this.root = new AllocationPoint(null);
                    allAllocations.clear();
                    this.root.addMemoryLog(log, -1);
                    this.root.getChildWithLocation((long)0L).size = log.getSizeAfter();
                    continue;
                }
                if (log.getSize() > 0) {
                    this.root.addMemoryLog(log, -1);
                    if (!removeFreed) continue;
                    allAllocations.put(log, log);
                    continue;
                }
                if (log.getSize() >= 0 || !removeFreed) continue;
                MemoryLog pair = (MemoryLog)allAllocations.remove(log);
                if (pair != null) {
                    this.root.removeMemoryLog(pair, -1);
                    continue;
                }
                this.root.removeMemoryLog(log, -1);
            }
        }
        this.tree = new JTree(this.root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.setVisibleRowCount(20);
        this.scroll.setViewportView(this.tree);
        for (int i = 0; i < 10; ++i) {
            this.tree.expandRow(i);
        }
    }
}

