/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import projections.analysis.AsciiLineParser;
import projections.analysis.PointCapableReader;
import projections.analysis.ProjectionsReader;
import projections.gui.Analysis;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

public class GenericLogReader
extends ProjectionsReader
implements PointCapableReader {
    static int myRun = 0;
    private double version;
    private BufferedReader reader;
    private long lastRecordedTime = 0L;
    private LogEntryData lastBeginEvent = new LogEntryData();
    private boolean endComputationOccurred;

    public GenericLogReader(String filename, double Nversion) {
        super(filename, String.valueOf(Nversion));
        this.lastBeginEvent.setValid(false);
        this.endComputationOccurred = false;
        try {
            this.reader = new BufferedReader(new FileReader(filename));
            this.version = Nversion;
            this.reader.readLine();
        }
        catch (IOException e) {
            System.err.println("Error reading file " + filename);
        }
    }

    public GenericLogReader(int peNum, double Nversion) {
        super(MainWindow.runObject[myRun].getLogName(peNum), String.valueOf(Nversion));
        this.lastBeginEvent.setValid(false);
        this.endComputationOccurred = false;
        try {
            this.reader = new BufferedReader(new FileReader(this.sourceString));
            this.version = Nversion;
            this.reader.readLine();
        }
        catch (IOException e) {
            System.err.println("Error reading file " + this.sourceString);
        }
    }

    protected boolean checkAvailable() {
        File sourceFile = new File(this.sourceString);
        return sourceFile.canRead();
    }

    public String interpretNote(String input) {
        Analysis a = MainWindow.runObject[myRun];
        String modified = input;
        if (modified.contains("<EP")) {
            int numEntries = a.getEntryCount();
            for (int i = 0; i < numEntries; ++i) {
                String name = a.getEntryFullNameByID(i);
                modified = modified.replace("<EP " + i + ">", name);
            }
        }
        return modified;
    }

    public LogEntryData nextEvent() throws IOException, EOFException {
        LogEntryData data = new LogEntryData();
        String line = this.reader.readLine();
        AsciiLineParser parser = new AsciiLineParser(line);
        if (line == null) {
            if (!this.endComputationOccurred) {
                this.endComputationOccurred = true;
                data.type = 7;
                data.time = this.lastRecordedTime;
                System.err.println("[" + this.sourceString + "] WARNING: Partial or Corrupted Projections log. Faked END_COMPUTATION entry added for last recorded time of " + data.time);
            } else {
                throw new EOFException();
            }
        }
        data.type = parser.nextInt();
        switch (data.type) {
            case 14: {
                this.lastBeginEvent.time = data.time = parser.nextLong();
                this.lastBeginEvent.pe = data.pe = parser.nextInt();
                this.lastBeginEvent.setValid(true);
                break;
            }
            case 15: {
                data.time = parser.nextLong();
                data.pe = parser.nextInt();
                this.lastBeginEvent.setValid(false);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                data.time = parser.nextLong();
                data.pe = parser.nextInt();
                break;
            }
            case 26: {
                data.userSupplied = new Integer(parser.nextInt());
                break;
            }
            case 28: {
                data.time = new Integer(parser.nextInt()).intValue();
                Integer strlen = new Integer(parser.nextInt());
                data.note = this.interpretNote(parser.restOfLine());
                break;
            }
            case 27: {
                data.memoryUsage = new Integer(parser.nextInt());
                break;
            }
            case 1: {
                data.mtype = parser.nextInt();
                data.entry = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                data.msglen = this.version >= 2.0 ? parser.nextInt() : -1;
                if (!(this.version >= 5.0)) break;
                data.sendTime = parser.nextLong();
                break;
            }
            case 20: {
                data.mtype = parser.nextInt();
                data.entry = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                data.msglen = this.version >= 2.0 ? parser.nextInt() : -1;
                if (this.version >= 5.0) {
                    data.sendTime = parser.nextLong();
                }
                data.numPEs = parser.nextInt();
                break;
            }
            case 21: {
                data.mtype = parser.nextInt();
                data.entry = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                data.msglen = this.version >= 2.0 ? parser.nextInt() : -1;
                if (this.version >= 5.0) {
                    data.sendTime = parser.nextLong();
                }
                data.numPEs = parser.nextInt();
                data.destPEs = new int[data.numPEs];
                for (int i = 0; i < data.numPEs; ++i) {
                    data.destPEs[i] = parser.nextInt();
                }
                break;
            }
            case 2: {
                this.lastBeginEvent.mtype = data.mtype = parser.nextInt();
                this.lastBeginEvent.entry = data.entry = parser.nextInt();
                this.lastBeginEvent.time = data.time = parser.nextLong();
                this.lastBeginEvent.event = data.event = parser.nextInt();
                this.lastBeginEvent.pe = data.pe = parser.nextInt();
                if (this.version >= 2.0) {
                    this.lastBeginEvent.msglen = data.msglen = parser.nextInt();
                } else {
                    data.msglen = -1;
                    this.lastBeginEvent.msglen = -1;
                }
                if (this.version >= 4.0) {
                    this.lastBeginEvent.recvTime = data.recvTime = parser.nextLong();
                    this.lastBeginEvent.id[0] = data.id[0] = parser.nextInt();
                    this.lastBeginEvent.id[1] = data.id[1] = parser.nextInt();
                    this.lastBeginEvent.id[2] = data.id[2] = parser.nextInt();
                }
                if (this.version >= 7.0) {
                    this.lastBeginEvent.id[3] = data.id[3] = parser.nextInt();
                }
                if (this.version >= 6.5) {
                    this.lastBeginEvent.cpuStartTime = data.cpuStartTime = parser.nextLong();
                }
                if (this.version >= 6.6) {
                    this.lastBeginEvent.numPerfCounts = data.numPerfCounts = parser.nextInt();
                    this.lastBeginEvent.perfCounts = new long[data.numPerfCounts];
                    data.perfCounts = new long[data.numPerfCounts];
                    for (int i = 0; i < data.numPerfCounts; ++i) {
                        this.lastBeginEvent.perfCounts[i] = data.perfCounts[i] = parser.nextLong();
                    }
                }
                this.lastBeginEvent.setValid(true);
                break;
            }
            case 3: {
                data.mtype = parser.nextInt();
                data.entry = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                data.msglen = this.version >= 2.0 ? parser.nextInt() : -1;
                if (this.version >= 6.5) {
                    data.cpuEndTime = parser.nextLong();
                }
                if (!(this.version >= 6.6)) break;
                data.numPerfCounts = parser.nextInt();
                data.perfCounts = new long[data.numPerfCounts];
                for (int i = 0; i < data.numPerfCounts; ++i) {
                    data.perfCounts[i] = parser.nextLong();
                }
                break;
            }
            case 11: {
                data.time = parser.nextLong();
                this.lastBeginEvent.setValid(false);
                break;
            }
            case 12: {
                data.time = parser.nextLong();
                break;
            }
            case 22: {
                data.time = parser.nextLong();
                data.entry = parser.nextInt();
                data.lineNo = parser.nextInt();
                data.funcName = parser.restOfLine();
                break;
            }
            case 23: {
                data.time = parser.nextLong();
                data.entry = parser.nextInt();
                break;
            }
            case 10: {
                data.mtype = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                data.msglen = parser.nextInt();
                break;
            }
            case 4: 
            case 5: {
                data.mtype = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                break;
            }
            case 8: 
            case 9: {
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                break;
            }
            case 6: {
                data.time = parser.nextLong();
                break;
            }
            case 7: {
                data.time = parser.nextLong();
                this.endComputationOccurred = true;
                break;
            }
            case 13: {
                data.entry = data.userEventID = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                break;
            }
            case 100: {
                data.entry = data.userEventID = parser.nextInt();
                data.time = parser.nextLong();
                data.event = parser.nextInt();
                data.pe = parser.nextInt();
                break;
            }
            default: {
                data.type = -1;
            }
        }
        this.lastRecordedTime = data.time;
        return data;
    }

    public LogEntryData nextEventOnOrAfter(long timestamp) throws IOException, EOFException {
        return this.seqLookForNextEventOnOrAfter(timestamp);
    }

    private LogEntryData seqLookForNextEventOnOrAfter(long timestamp) throws IOException, EOFException {
        LogEntryData data = new LogEntryData();
        do {
            data = this.nextEvent();
            while (data.type == -1) {
                data = this.nextEvent();
            }
        } while (data.time < timestamp);
        return data;
    }

    public LogEntryData nextEventOfType(int eventType) throws IOException, EOFException {
        LogEntryData data = new LogEntryData();
        do {
            data = this.nextEvent();
        } while (data.type != eventType);
        return data;
    }

    public LogEntryData getLastBE() {
        if (this.lastBeginEvent.isValid()) {
            return this.lastBeginEvent;
        }
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

