/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public abstract class ProjectionsWindow
extends JFrame
implements ActionListener {
    private Button[] window;
    protected MainWindow parentWindow;
    public RangeDialog dialog;

    protected abstract void windowInit();

    protected abstract void showDialog();

    protected abstract void getDialogData();

    protected void setDialogData() {
        if (this.dialog != null) {
            this.dialog.updateFields();
        }
    }

    public ProjectionsWindow(MainWindow parentWindow) {
        this("", parentWindow);
    }

    public ProjectionsWindow(String title, MainWindow parentWindow) {
        this.parentWindow = parentWindow;
        this.setTitle(title);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjectionsWindow.this.close();
            }
        });
        this.windowInit();
    }

    public void setLayout(JPanel mainPanel) {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(gbl);
        Util.gblAdd(contentPane, mainPanel, gbc, 0, 1, 1, 1, 1, 1);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() instanceof Button) {
            Button b = (Button)ae.getSource();
            for (int k = 0; k < 18 && b != this.window[k]; ++k) {
            }
        }
    }

    public void close() {
        this.dispose();
        this.parentWindow.closeChildWindow(this);
    }

    public void addProcessor(int pe) {
    }
}

