package projector.language;

import projector.core.*;

/**
 * Author: Arun Singla 
 * May 2, 2002
 */


/**
 * CharmEventObject  
 */
public class CharmEventObject extends GeneralEventObject
{
	// the following attributes is a superset of those in 'LogEntryData.java'
    public int  mtype;		// message type
    public int  entry;		// chare entry point index
    public int  eventID;	// event number
    public int  msgLen;		// message length
	public int  pe;			// processing element

	public CharmEventObject() {}

	public CharmEventObject(GeneralEventObject geObj){
		super(geObj);
	}

	/**
	 * void parseIData(int[])
	 * - extract meaningful log parameters from the argument integer array
	 */
  	public void parseIData(int[] iData) throws AbortException
	{
		switch(eventType) {
		case EventType._E_CREATION:
		case EventType._E_BEGIN_PROCESSING:
		case EventType._E_END_PROCESSING:
			mtype   = iData[0];
			entry   = iData[1];
			eventID = iData[2];
			pe	    = iData[3];
			if(iData.length == 5) {
				msgLen = iData[4];
			}else{
				msgLen = 0;	
			}
		break;

		//TODO: some of these events haven't been traced properly yet
		case EventType._E_BEGIN_INTERRUPT:
		case EventType._E_END_INTERRUPT:
		case EventType._E_MSG_RECV_CHARM:
		case EventType._E_USER_EVENT_CHARM:
		break;
		
		case EventType._E_ENQUEUE:
		case EventType._E_DEQUEUE:
			mtype = iData[0];
			eventID = iData[1];
			pe = iData[2];
		break;
	
		// following events do not have any event specific log fields
		case EventType._E_BEGIN_COMPUTATION:
		case EventType._E_END_COMPUTATION:
		break;

		case EventType._E_BEGIN_PACK:
		case EventType._E_END_PACK:
		case EventType._E_BEGIN_UNPACK:
		case EventType._E_END_UNPACK:
			pe = iData[0];
		break;

		default:
			throw new AbortException("CharmEventObject:parseIData(int[]):Unidentified EventID");
		}
	}
}

