/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import projections.analysis.CallStackManager;
import projections.analysis.GenericLogReader;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.PopUpAble;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class FunctionTool
extends GenericGraphWindow
implements PopUpAble {
    int myRun = 0;
    private JPanel mainPanel = new JPanel();
    private JPanel graphPanel;
    private JPanel radioButtonPanel;
    private JRadioButton countCB;
    private JRadioButton timeCB;
    private double[][] countData;
    private double[][] timeData;
    private String currentArrayName = "";
    FunctionTool thisWindow;

    public FunctionTool(MainWindow mainWindow) {
        super("Function tracing", mainWindow);
        this.setLayout(this.mainPanel);
        this.createLayout();
        this.setPopupText("timeData");
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    private void setPopupText(String input) {
        this.currentArrayName = input;
    }

    protected void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.graphPanel = this.getMainPanel();
        this.radioButtonPanel = new JPanel();
        ButtonGroup group = new ButtonGroup();
        this.countCB = new JRadioButton("Call Counts", false);
        this.timeCB = new JRadioButton("Time Spent", true);
        group.add(this.countCB);
        group.add(this.timeCB);
        this.countCB.addActionListener(this);
        this.timeCB.addActionListener(this);
        Util.gblAdd(this.radioButtonPanel, this.countCB, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.radioButtonPanel, this.timeCB, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.graphPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.radioButtonPanel, gbc, 0, 2, 1, 1, 0, 0);
    }

    protected void setGraphSpecificData() {
        if (this.currentArrayName.equals("timeData")) {
            this.setDataSource("Total Function Time", this.timeData, MainWindow.runObject[this.myRun].getFunctionColors(), this.thisWindow);
            this.setXAxis("Processor", "");
            this.setYAxis("Time Spent in Function", "us");
        } else if (this.currentArrayName.equals("countData")) {
            this.setDataSource("Total Function Calls", this.countData, MainWindow.runObject[this.myRun].getFunctionColors(), this.thisWindow);
            this.setXAxis("Processor", "");
            this.setYAxis("# Times Called", "");
        }
        super.refreshGraph();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    FunctionTool.this.getData();
                    return null;
                }

                public void finished() {
                    FunctionTool.this.setGraphSpecificData();
                    FunctionTool.this.thisWindow.setVisible(true);
                    FunctionTool.this.thisWindow.repaint();
                }
            };
            worker.start();
        }
    }

    public void repaint() {
        super.refreshGraph();
    }

    void getData() {
        LogEntryData logEntry = new LogEntryData();
        OrderedIntList validPEs = MainWindow.runObject[this.myRun].getValidProcessorList();
        validPEs.reset();
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        CallStackManager stack = new CallStackManager();
        int[] activeThread = new int[3];
        this.countData = new double[validPEs.size()][numFunc];
        this.timeData = new double[validPEs.size()][numFunc];
        int curPeArrayIndex = 0;
        ProgressMonitor progressBar = new ProgressMonitor(this, "Reading log files", "", 0, validPEs.size());
        while (validPEs.hasMoreElements()) {
            int pe = validPEs.nextElement();
            try {
                if (progressBar.isCanceled()) {
                    progressBar.close();
                    return;
                }
                progressBar.setNote("[PE: " + pe + " ] Reading data");
                progressBar.setProgress(curPeArrayIndex + 1);
                this.validate();
                GenericLogReader reader = new GenericLogReader(MainWindow.runObject[this.myRun].getLogName(pe), MainWindow.runObject[this.myRun].getVersion());
                double lastFuncTime = 0.0;
                logEntry = reader.nextEventOfType(2);
                while (true) {
                    switch (logEntry.type) {
                        case 2: {
                            if (logEntry.entry != 0) break;
                            lastFuncTime = logEntry.time;
                            activeThread[0] = logEntry.id[0];
                            activeThread[1] = logEntry.id[1];
                            activeThread[2] = logEntry.id[2];
                            break;
                        }
                        case 3: {
                            if (logEntry.entry != 0) break;
                            Integer stackEntry = (Integer)stack.read(activeThread[0], activeThread[1], activeThread[2]);
                            if (stackEntry != null) {
                                double[] dArray = this.timeData[curPeArrayIndex];
                                int n = stackEntry;
                                dArray[n] = dArray[n] + ((double)logEntry.time - lastFuncTime);
                            }
                            activeThread[0] = -1;
                            activeThread[1] = -1;
                            activeThread[2] = -1;
                            break;
                        }
                        case 22: {
                            Integer stackEntry = (Integer)stack.read(activeThread[0], activeThread[1], activeThread[2]);
                            if (stackEntry != null) {
                                double[] dArray = this.timeData[curPeArrayIndex];
                                int n = stackEntry;
                                dArray[n] = dArray[n] + ((double)logEntry.time - lastFuncTime);
                            }
                            stack.push(new Integer(logEntry.entry), activeThread[0], activeThread[1], activeThread[2]);
                            lastFuncTime = logEntry.time;
                            double[] dArray = this.countData[curPeArrayIndex];
                            int n = logEntry.entry;
                            dArray[n] = dArray[n] + 1.0;
                            break;
                        }
                        case 23: {
                            Integer stackEntry = (Integer)stack.pop(activeThread[0], activeThread[1], activeThread[2]);
                            if (stackEntry != null) {
                                if (logEntry.entry != stackEntry) {
                                    System.err.println("ERROR: Function end type " + logEntry.entry + " does not match stack " + "type " + stackEntry);
                                    System.exit(-1);
                                }
                                double[] dArray = this.timeData[curPeArrayIndex];
                                int n = logEntry.entry;
                                dArray[n] = dArray[n] + ((double)logEntry.time - lastFuncTime);
                            } else {
                                System.err.println("ERROR: Impossible for an empty stack when processing end of function");
                                System.exit(-1);
                            }
                            lastFuncTime = logEntry.time;
                        }
                    }
                    logEntry = reader.nextEvent();
                }
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                System.err.println("Failed to read log at processor [" + pe + "]");
            }
            ++curPeArrayIndex;
        }
        progressBar.close();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() instanceof JRadioButton) {
            JRadioButton cb = (JRadioButton)ae.getSource();
            if (cb == this.countCB) {
                this.setPopupText("countData");
                this.setGraphSpecificData();
            } else if (cb == this.timeCB) {
                this.setPopupText("timeData");
                this.setGraphSpecificData();
            }
        }
        super.actionPerformed(ae);
    }

    public String[] getPopup(int pe, int funcID) {
        String[] popupText = new String[3];
        if (this.currentArrayName.equals("timeData")) {
            popupText[0] = "Processor: " + pe;
            popupText[1] = "Function: " + MainWindow.runObject[this.myRun].getFunctionName(funcID);
            popupText[2] = "Time spent (us): " + (long)this.timeData[pe][funcID];
        } else if (this.currentArrayName.equals("countData")) {
            popupText[0] = "Processor: " + pe;
            popupText[1] = "Function: " + MainWindow.runObject[this.myRun].getFunctionName(funcID);
            popupText[2] = "Times called: " + (int)this.countData[pe][funcID];
        }
        return popupText;
    }
}

